/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.mcpserver;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.common.McpTransportContext;
import io.modelcontextprotocol.server.McpStatelessServerHandler;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpStatelessServerTransport;
import io.modelcontextprotocol.util.Assert;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import reactor.core.publisher.Mono;

public class OpenSearchMcpStatelessServerTransportProvider
implements McpStatelessServerTransport {
    @Generated
    private static final Logger log = LogManager.getLogger(OpenSearchMcpStatelessServerTransportProvider.class);
    private final ObjectMapper objectMapper;
    private McpStatelessServerHandler mcpHandler;

    public OpenSearchMcpStatelessServerTransportProvider(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null");
        this.objectMapper = objectMapper;
    }

    public void setMcpHandler(McpStatelessServerHandler mcpHandler) {
        this.mcpHandler = mcpHandler;
        log.info("MCP handler set for stateless transport provider: {}", (Object)(mcpHandler != null ? "SUCCESS" : "FAILED"));
    }

    public Mono<Void> closeGracefully() {
        log.debug("Closing stateless MCP transport provider gracefully");
        return Mono.empty();
    }

    public Mono<McpSchema.JSONRPCMessage> handleRequest(McpSchema.JSONRPCMessage message) {
        try {
            if (this.mcpHandler == null) {
                log.error("MCP handler is null - server may not be properly initialized");
                return Mono.error((Throwable)new RuntimeException("MCP handler not initialized"));
            }
            if (message instanceof McpSchema.JSONRPCRequest) {
                McpSchema.JSONRPCRequest request = (McpSchema.JSONRPCRequest)message;
                log.debug("Handling JSON-RPC request: {}", (Object)request.method());
                return this.mcpHandler.handleRequest(McpTransportContext.EMPTY, request).map(response -> response);
            }
            log.error("Unknown message type: {}", (Object)message.getClass().getSimpleName());
            return Mono.error((Throwable)new RuntimeException("Unknown message type"));
        }
        catch (Exception e) {
            log.error("Failed to handle MCP request: {}", (Object)e.getMessage(), (Object)e);
            return Mono.error((Throwable)e);
        }
    }
}

