﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/wisdom/ConnectWisdomService_EXPORTS.h>
#include <aws/wisdom/model/GroupingConfiguration.h>
#include <aws/wisdom/model/QuickResponseContents.h>
#include <aws/wisdom/model/QuickResponseStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace ConnectWisdomService {
namespace Model {

/**
 * <p>Information about the quick response.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/QuickResponseData">AWS
 * API Reference</a></p>
 */
class QuickResponseData {
 public:
  AWS_CONNECTWISDOMSERVICE_API QuickResponseData() = default;
  AWS_CONNECTWISDOMSERVICE_API QuickResponseData(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONNECTWISDOMSERVICE_API QuickResponseData& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONNECTWISDOMSERVICE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The Amazon Connect contact channels this quick response applies to. The
   * supported contact channel types include <code>Chat</code>.</p>
   */
  inline const Aws::Vector<Aws::String>& GetChannels() const { return m_channels; }
  inline bool ChannelsHasBeenSet() const { return m_channelsHasBeenSet; }
  template <typename ChannelsT = Aws::Vector<Aws::String>>
  void SetChannels(ChannelsT&& value) {
    m_channelsHasBeenSet = true;
    m_channels = std::forward<ChannelsT>(value);
  }
  template <typename ChannelsT = Aws::Vector<Aws::String>>
  QuickResponseData& WithChannels(ChannelsT&& value) {
    SetChannels(std::forward<ChannelsT>(value));
    return *this;
  }
  template <typename ChannelsT = Aws::String>
  QuickResponseData& AddChannels(ChannelsT&& value) {
    m_channelsHasBeenSet = true;
    m_channels.emplace_back(std::forward<ChannelsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The media type of the quick response content.</p> <ul> <li> <p>Use
   * <code>application/x.quickresponse;format=plain</code> for quick response written
   * in plain text.</p> </li> <li> <p>Use
   * <code>application/x.quickresponse;format=markdown</code> for quick response
   * written in richtext.</p> </li> </ul>
   */
  inline const Aws::String& GetContentType() const { return m_contentType; }
  inline bool ContentTypeHasBeenSet() const { return m_contentTypeHasBeenSet; }
  template <typename ContentTypeT = Aws::String>
  void SetContentType(ContentTypeT&& value) {
    m_contentTypeHasBeenSet = true;
    m_contentType = std::forward<ContentTypeT>(value);
  }
  template <typename ContentTypeT = Aws::String>
  QuickResponseData& WithContentType(ContentTypeT&& value) {
    SetContentType(std::forward<ContentTypeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The contents of the quick response.</p>
   */
  inline const QuickResponseContents& GetContents() const { return m_contents; }
  inline bool ContentsHasBeenSet() const { return m_contentsHasBeenSet; }
  template <typename ContentsT = QuickResponseContents>
  void SetContents(ContentsT&& value) {
    m_contentsHasBeenSet = true;
    m_contents = std::forward<ContentsT>(value);
  }
  template <typename ContentsT = QuickResponseContents>
  QuickResponseData& WithContents(ContentsT&& value) {
    SetContents(std::forward<ContentsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The timestamp when the quick response was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedTime() const { return m_createdTime; }
  inline bool CreatedTimeHasBeenSet() const { return m_createdTimeHasBeenSet; }
  template <typename CreatedTimeT = Aws::Utils::DateTime>
  void SetCreatedTime(CreatedTimeT&& value) {
    m_createdTimeHasBeenSet = true;
    m_createdTime = std::forward<CreatedTimeT>(value);
  }
  template <typename CreatedTimeT = Aws::Utils::DateTime>
  QuickResponseData& WithCreatedTime(CreatedTimeT&& value) {
    SetCreatedTime(std::forward<CreatedTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description of the quick response.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  QuickResponseData& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The configuration information of the user groups that the quick response is
   * accessible to.</p>
   */
  inline const GroupingConfiguration& GetGroupingConfiguration() const { return m_groupingConfiguration; }
  inline bool GroupingConfigurationHasBeenSet() const { return m_groupingConfigurationHasBeenSet; }
  template <typename GroupingConfigurationT = GroupingConfiguration>
  void SetGroupingConfiguration(GroupingConfigurationT&& value) {
    m_groupingConfigurationHasBeenSet = true;
    m_groupingConfiguration = std::forward<GroupingConfigurationT>(value);
  }
  template <typename GroupingConfigurationT = GroupingConfiguration>
  QuickResponseData& WithGroupingConfiguration(GroupingConfigurationT&& value) {
    SetGroupingConfiguration(std::forward<GroupingConfigurationT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Whether the quick response is active.</p>
   */
  inline bool GetIsActive() const { return m_isActive; }
  inline bool IsActiveHasBeenSet() const { return m_isActiveHasBeenSet; }
  inline void SetIsActive(bool value) {
    m_isActiveHasBeenSet = true;
    m_isActive = value;
  }
  inline QuickResponseData& WithIsActive(bool value) {
    SetIsActive(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the knowledge base.</p>
   */
  inline const Aws::String& GetKnowledgeBaseArn() const { return m_knowledgeBaseArn; }
  inline bool KnowledgeBaseArnHasBeenSet() const { return m_knowledgeBaseArnHasBeenSet; }
  template <typename KnowledgeBaseArnT = Aws::String>
  void SetKnowledgeBaseArn(KnowledgeBaseArnT&& value) {
    m_knowledgeBaseArnHasBeenSet = true;
    m_knowledgeBaseArn = std::forward<KnowledgeBaseArnT>(value);
  }
  template <typename KnowledgeBaseArnT = Aws::String>
  QuickResponseData& WithKnowledgeBaseArn(KnowledgeBaseArnT&& value) {
    SetKnowledgeBaseArn(std::forward<KnowledgeBaseArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the knowledge base. This should not be a QUICK_RESPONSES
   * type knowledge base if you're storing Wisdom Content resource to it. Can be
   * either the ID or the ARN. URLs cannot contain the ARN.</p>
   */
  inline const Aws::String& GetKnowledgeBaseId() const { return m_knowledgeBaseId; }
  inline bool KnowledgeBaseIdHasBeenSet() const { return m_knowledgeBaseIdHasBeenSet; }
  template <typename KnowledgeBaseIdT = Aws::String>
  void SetKnowledgeBaseId(KnowledgeBaseIdT&& value) {
    m_knowledgeBaseIdHasBeenSet = true;
    m_knowledgeBaseId = std::forward<KnowledgeBaseIdT>(value);
  }
  template <typename KnowledgeBaseIdT = Aws::String>
  QuickResponseData& WithKnowledgeBaseId(KnowledgeBaseIdT&& value) {
    SetKnowledgeBaseId(std::forward<KnowledgeBaseIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The language code value for the language in which the quick response is
   * written.</p>
   */
  inline const Aws::String& GetLanguage() const { return m_language; }
  inline bool LanguageHasBeenSet() const { return m_languageHasBeenSet; }
  template <typename LanguageT = Aws::String>
  void SetLanguage(LanguageT&& value) {
    m_languageHasBeenSet = true;
    m_language = std::forward<LanguageT>(value);
  }
  template <typename LanguageT = Aws::String>
  QuickResponseData& WithLanguage(LanguageT&& value) {
    SetLanguage(std::forward<LanguageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the user who last updated the quick
   * response data.</p>
   */
  inline const Aws::String& GetLastModifiedBy() const { return m_lastModifiedBy; }
  inline bool LastModifiedByHasBeenSet() const { return m_lastModifiedByHasBeenSet; }
  template <typename LastModifiedByT = Aws::String>
  void SetLastModifiedBy(LastModifiedByT&& value) {
    m_lastModifiedByHasBeenSet = true;
    m_lastModifiedBy = std::forward<LastModifiedByT>(value);
  }
  template <typename LastModifiedByT = Aws::String>
  QuickResponseData& WithLastModifiedBy(LastModifiedByT&& value) {
    SetLastModifiedBy(std::forward<LastModifiedByT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The timestamp when the quick response data was last modified.</p>
   */
  inline const Aws::Utils::DateTime& GetLastModifiedTime() const { return m_lastModifiedTime; }
  inline bool LastModifiedTimeHasBeenSet() const { return m_lastModifiedTimeHasBeenSet; }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  void SetLastModifiedTime(LastModifiedTimeT&& value) {
    m_lastModifiedTimeHasBeenSet = true;
    m_lastModifiedTime = std::forward<LastModifiedTimeT>(value);
  }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  QuickResponseData& WithLastModifiedTime(LastModifiedTimeT&& value) {
    SetLastModifiedTime(std::forward<LastModifiedTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the quick response.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  QuickResponseData& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the quick response.</p>
   */
  inline const Aws::String& GetQuickResponseArn() const { return m_quickResponseArn; }
  inline bool QuickResponseArnHasBeenSet() const { return m_quickResponseArnHasBeenSet; }
  template <typename QuickResponseArnT = Aws::String>
  void SetQuickResponseArn(QuickResponseArnT&& value) {
    m_quickResponseArnHasBeenSet = true;
    m_quickResponseArn = std::forward<QuickResponseArnT>(value);
  }
  template <typename QuickResponseArnT = Aws::String>
  QuickResponseData& WithQuickResponseArn(QuickResponseArnT&& value) {
    SetQuickResponseArn(std::forward<QuickResponseArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the quick response.</p>
   */
  inline const Aws::String& GetQuickResponseId() const { return m_quickResponseId; }
  inline bool QuickResponseIdHasBeenSet() const { return m_quickResponseIdHasBeenSet; }
  template <typename QuickResponseIdT = Aws::String>
  void SetQuickResponseId(QuickResponseIdT&& value) {
    m_quickResponseIdHasBeenSet = true;
    m_quickResponseId = std::forward<QuickResponseIdT>(value);
  }
  template <typename QuickResponseIdT = Aws::String>
  QuickResponseData& WithQuickResponseId(QuickResponseIdT&& value) {
    SetQuickResponseId(std::forward<QuickResponseIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The shortcut key of the quick response. The value should be unique across the
   * knowledge base.</p>
   */
  inline const Aws::String& GetShortcutKey() const { return m_shortcutKey; }
  inline bool ShortcutKeyHasBeenSet() const { return m_shortcutKeyHasBeenSet; }
  template <typename ShortcutKeyT = Aws::String>
  void SetShortcutKey(ShortcutKeyT&& value) {
    m_shortcutKeyHasBeenSet = true;
    m_shortcutKey = std::forward<ShortcutKeyT>(value);
  }
  template <typename ShortcutKeyT = Aws::String>
  QuickResponseData& WithShortcutKey(ShortcutKeyT&& value) {
    SetShortcutKey(std::forward<ShortcutKeyT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the quick response data.</p>
   */
  inline QuickResponseStatus GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(QuickResponseStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline QuickResponseData& WithStatus(QuickResponseStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The tags used to organize, track, or control access for this resource.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
  inline bool TagsHasBeenSet() const { return m_tagsHasBeenSet; }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  QuickResponseData& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
  QuickResponseData& AddTags(TagsKeyT&& key, TagsValueT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Aws::String> m_channels;
  bool m_channelsHasBeenSet = false;

  Aws::String m_contentType;
  bool m_contentTypeHasBeenSet = false;

  QuickResponseContents m_contents;
  bool m_contentsHasBeenSet = false;

  Aws::Utils::DateTime m_createdTime{};
  bool m_createdTimeHasBeenSet = false;

  Aws::String m_description;
  bool m_descriptionHasBeenSet = false;

  GroupingConfiguration m_groupingConfiguration;
  bool m_groupingConfigurationHasBeenSet = false;

  bool m_isActive{false};
  bool m_isActiveHasBeenSet = false;

  Aws::String m_knowledgeBaseArn;
  bool m_knowledgeBaseArnHasBeenSet = false;

  Aws::String m_knowledgeBaseId;
  bool m_knowledgeBaseIdHasBeenSet = false;

  Aws::String m_language;
  bool m_languageHasBeenSet = false;

  Aws::String m_lastModifiedBy;
  bool m_lastModifiedByHasBeenSet = false;

  Aws::Utils::DateTime m_lastModifiedTime{};
  bool m_lastModifiedTimeHasBeenSet = false;

  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  Aws::String m_quickResponseArn;
  bool m_quickResponseArnHasBeenSet = false;

  Aws::String m_quickResponseId;
  bool m_quickResponseIdHasBeenSet = false;

  Aws::String m_shortcutKey;
  bool m_shortcutKeyHasBeenSet = false;

  QuickResponseStatus m_status{QuickResponseStatus::NOT_SET};
  bool m_statusHasBeenSet = false;

  Aws::Map<Aws::String, Aws::String> m_tags;
  bool m_tagsHasBeenSet = false;
};

}  // namespace Model
}  // namespace ConnectWisdomService
}  // namespace Aws
