﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/s3-crt/S3Crt_EXPORTS.h>
#include <aws/s3-crt/model/IntelligentTieringAndOperator.h>
#include <aws/s3-crt/model/Tag.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace S3Crt {
namespace Model {

/**
 * <p>The <code>Filter</code> is used to identify objects that the S3
 * Intelligent-Tiering configuration applies to.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/IntelligentTieringFilter">AWS
 * API Reference</a></p>
 */
class IntelligentTieringFilter {
 public:
  AWS_S3CRT_API IntelligentTieringFilter() = default;
  AWS_S3CRT_API IntelligentTieringFilter(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_S3CRT_API IntelligentTieringFilter& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_S3CRT_API void AddToNode(Aws::Utils::Xml::XmlNode& parentNode) const;

  ///@{
  /**
   * <p>An object key name prefix that identifies the subset of objects to which the
   * rule applies.</p>  <p>Replacement must be made for object keys
   * containing special characters (such as carriage returns) when using XML
   * requests. For more information, see <a
   * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints">
   * XML related object key constraints</a>.</p>
   */
  inline const Aws::String& GetPrefix() const { return m_prefix; }
  inline bool PrefixHasBeenSet() const { return m_prefixHasBeenSet; }
  template <typename PrefixT = Aws::String>
  void SetPrefix(PrefixT&& value) {
    m_prefixHasBeenSet = true;
    m_prefix = std::forward<PrefixT>(value);
  }
  template <typename PrefixT = Aws::String>
  IntelligentTieringFilter& WithPrefix(PrefixT&& value) {
    SetPrefix(std::forward<PrefixT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Tag& GetTag() const { return m_tag; }
  inline bool TagHasBeenSet() const { return m_tagHasBeenSet; }
  template <typename TagT = Tag>
  void SetTag(TagT&& value) {
    m_tagHasBeenSet = true;
    m_tag = std::forward<TagT>(value);
  }
  template <typename TagT = Tag>
  IntelligentTieringFilter& WithTag(TagT&& value) {
    SetTag(std::forward<TagT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A conjunction (logical AND) of predicates, which is used in evaluating a
   * metrics filter. The operator must have at least two predicates, and an object
   * must match all of the predicates in order for the filter to apply.</p>
   */
  inline const IntelligentTieringAndOperator& GetAnd() const { return m_and; }
  inline bool AndHasBeenSet() const { return m_andHasBeenSet; }
  template <typename AndT = IntelligentTieringAndOperator>
  void SetAnd(AndT&& value) {
    m_andHasBeenSet = true;
    m_and = std::forward<AndT>(value);
  }
  template <typename AndT = IntelligentTieringAndOperator>
  IntelligentTieringFilter& WithAnd(AndT&& value) {
    SetAnd(std::forward<AndT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_prefix;
  bool m_prefixHasBeenSet = false;

  Tag m_tag;
  bool m_tagHasBeenSet = false;

  IntelligentTieringAndOperator m_and;
  bool m_andHasBeenSet = false;
};

}  // namespace Model
}  // namespace S3Crt
}  // namespace Aws
