/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.dialogs.SelectDataSourceDialog;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;

public abstract class TargetPrefPage
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    protected static final Log log = Log.getLog(TargetPrefPage.class);
    private IAdaptable element;
    private DBPDataSourceContainer dataSourceContainer;
    private DBNDataSource containerNode;
    private Button dataSourceSettingsButton;
    private Control configurationBlockControl;
    private Link changeSettingsTargetLink;
    private ControlEnableState blockEnableState;

    protected TargetPrefPage() {
    }

    public final boolean isDataSourcePreferencePage() {
        return this.dataSourceContainer != null;
    }

    protected boolean supportsGlobalOptions() {
        return true;
    }

    protected abstract boolean hasDataSourceSpecificOptions(DBPDataSourceContainer var1);

    protected abstract boolean supportsDataSourceSpecificOptions();

    protected void createPreferenceHeader(Composite composite) {
    }

    protected abstract void loadPreferences(@NotNull DBPPreferenceStore var1);

    protected abstract void savePreferences(@NotNull DBPPreferenceStore var1);

    protected abstract void clearPreferences(@NotNull DBPPreferenceStore var1);

    @NotNull
    protected abstract String getPropertyPageID();

    @Nullable
    public DBPDataSourceContainer getDataSourceContainer() {
        return this.dataSourceContainer;
    }

    @Nullable
    public DBPDataSourceContainer getOriginalDataSourceContainer() {
        return this.dataSourceContainer.getProject().getDataSourceRegistry().getDataSource(this.dataSourceContainer.getId());
    }

    public void init(IWorkbench workbench) {
    }

    public IAdaptable getElement() {
        return this.element;
    }

    public void setElement(IAdaptable element) {
        this.element = element;
        if (this.element == null) {
            return;
        }
        this.dataSourceContainer = element instanceof DBPDataSourceContainer ? (DBPDataSourceContainer)element : null;
        this.containerNode = (DBNDataSource)element.getAdapter(DBNDataSource.class);
        if (this.containerNode == null) {
            DBPDataSourceContainer dsContainer = (DBPDataSourceContainer)element.getAdapter(DBPDataSourceContainer.class);
            if (dsContainer != null) {
                this.containerNode = (DBNDataSource)DBWorkbench.getPlatform().getNavigatorModel().findNode((DBSObject)dsContainer);
            } else {
                IDatabaseEditorInput dbInput = (IDatabaseEditorInput)element.getAdapter(IDatabaseEditorInput.class);
                if (dbInput != null) {
                    DBNDatabaseNode dbNode = dbInput.getNavigatorNode();
                    if (dbNode instanceof DBNDataSource) {
                        this.containerNode = (DBNDataSource)dbNode;
                    }
                } else if (element instanceof DBPContextProvider) {
                    DBCExecutionContext context = ((DBPContextProvider)element).getExecutionContext();
                    if (context != null) {
                        this.containerNode = (DBNDataSource)DBWorkbench.getPlatform().getNavigatorModel().findNode((DBSObject)context.getDataSource().getContainer());
                    }
                } else if (element instanceof DBPDataSourceContainer) {
                    this.containerNode = (DBNDataSource)DBWorkbench.getPlatform().getNavigatorModel().findNode((DBSObject)((DBPDataSourceContainer)element));
                }
            }
        }
        if (this.dataSourceContainer == null && this.containerNode != null) {
            this.dataSourceContainer = this.containerNode.getDataSourceContainer();
        }
    }

    public void applyData(Object data) {
        if (this.containerNode == null && data instanceof IAdaptable) {
            this.setElement((IAdaptable)data);
        }
    }

    protected Label createDescriptionLabel(Composite parent) {
        if (this.isDataSourcePreferencePage()) {
            if (this.supportsGlobalOptions()) {
                Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)2);
                composite.setFont(parent.getFont());
                composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                this.dataSourceSettingsButton = new Button(composite, 32);
                this.dataSourceSettingsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        boolean enabled = TargetPrefPage.this.dataSourceSettingsButton.getSelection();
                        TargetPrefPage.this.enableDataSourceSpecificSettings(enabled);
                    }
                });
                this.dataSourceSettingsButton.setText(NLS.bind((String)UINavigatorMessages.pref_page_target_button_use_datasource_settings, (Object)this.dataSourceContainer.getName()));
                UIUtils.setDefaultTextControlWidthHint((Control)this.dataSourceSettingsButton);
                this.dataSourceSettingsButton.setFont(parent.getFont());
                this.changeSettingsTargetLink = this.createLink(composite, UINavigatorMessages.pref_page_target_link_show_global_settings);
                this.changeSettingsTargetLink.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
            }
        } else if (this.supportsDataSourceSpecificOptions()) {
            this.changeSettingsTargetLink = this.createLink(parent, UINavigatorMessages.pref_page_target_link_show_datasource_settings);
            this.changeSettingsTargetLink.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        }
        Label horizontalLine = new Label(parent, 258);
        horizontalLine.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.createPreferenceHeader(parent);
        return super.createDescriptionLabel(parent);
    }

    protected Control createContents(Composite parent) {
        this.configurationBlockControl = super.createContents(parent);
        DBPPreferenceStore store = this.getTargetPreferenceStore();
        this.loadPreferences(store);
        if (this.isDataSourcePreferencePage()) {
            boolean useProjectSettings = this.hasDataSourceSpecificOptions(this.getDataSourceContainer());
            this.enableDataSourceSpecificSettings(useProjectSettings);
        }
        return this.configurationBlockControl;
    }

    protected DBPPreferenceStore getTargetPreferenceStore() {
        return this.isDataSourcePreferencePage() ? this.getDataSourceContainer().getPreferenceStore() : DBWorkbench.getPlatform().getPreferenceStore();
    }

    private Link createLink(Composite composite, String text) {
        Link link = UIUtils.createLink((Composite)composite, (String)("<A>" + text + "</A>"), (SelectionListener)new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TargetPrefPage.this.doLinkActivated((Link)e.widget);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        link.setFont(composite.getFont());
        return link;
    }

    protected void enableDataSourceSpecificSettings(boolean useProjectSpecificSettings) {
        if (this.dataSourceSettingsButton != null) {
            this.dataSourceSettingsButton.setSelection(useProjectSpecificSettings);
        }
        this.enablePreferenceContent(useProjectSpecificSettings);
        this.updateLinkVisibility();
        this.doStatusChanged();
    }

    protected void doStatusChanged() {
    }

    protected void enablePreferenceContent(boolean enable) {
        if (enable) {
            if (this.blockEnableState != null) {
                this.blockEnableState.restore();
                this.blockEnableState = null;
            }
        } else {
            if (this.blockEnableState != null) {
                this.blockEnableState.restore();
            }
            this.blockEnableState = ControlEnableState.disable((Control)this.configurationBlockControl);
        }
    }

    protected boolean useDataSourceSettings() {
        if (!this.supportsGlobalOptions()) {
            return true;
        }
        return this.isDataSourcePreferencePage() && this.dataSourceSettingsButton != null && this.dataSourceSettingsButton.getSelection();
    }

    private void updateLinkVisibility() {
        if (this.changeSettingsTargetLink == null || this.changeSettingsTargetLink.isDisposed()) {
            return;
        }
        if (this.isDataSourcePreferencePage()) {
            this.changeSettingsTargetLink.setEnabled(true);
        }
    }

    private void doLinkActivated(Link link) {
        DBNDatabaseNode dsNode;
        DBPDataSourceContainer dataSource;
        SelectDataSourceDialog dialog;
        PreferenceDialog prefDialog = null;
        if (this.isDataSourcePreferencePage()) {
            prefDialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)this.getPropertyPageID(), null, null);
        } else if (this.supportsDataSourceSpecificOptions() && (dialog = new SelectDataSourceDialog(this.getShell(), null, null)).open() != 1 && (dataSource = dialog.getDataSource()) != null && (dsNode = DBNUtils.getNodeByObject((DBSObject)dataSource)) instanceof DBNDataSource) {
            prefDialog = PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)dsNode, (String)this.getPropertyPageID(), null, null);
        }
        if (prefDialog != null) {
            prefDialog.open();
        }
    }

    protected void performApply() {
        this.performOk();
    }

    public final boolean performOk() {
        DBPPreferenceStore store = this.getTargetPreferenceStore();
        if (this.isDataSourcePreferencePage() && !this.useDataSourceSettings()) {
            this.clearPreferences(store);
            PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        } else {
            this.savePreferences(store);
        }
        return super.performOk();
    }
}

