/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import org.freeplane.core.resources.components.ButtonSelectorPanel;
import org.freeplane.core.resources.components.PropertyBean;
import org.freeplane.core.ui.svgicons.FixSizeIconWrapper;

public class ButtonPanelProperty
extends PropertyBean {
    protected final JButton startButton;
    protected final ButtonSelectorPanel buttons;

    public ButtonPanelProperty(String name, ButtonSelectorPanel buttons) {
        super(name);
        this.buttons = buttons;
        this.startButton = new JButton();
        this.startButton.setName(name);
        this.startButton.setDefaultCapable(false);
        this.startButton.addActionListener(this::showButtonPanel);
        Dimension iconSize = buttons.getMaximumIconSize();
        this.startButton.setIcon(new FixSizeIconWrapper(iconSize.width, iconSize.height));
    }

    @Override
    public String getValue() {
        return this.buttons.getValue();
    }

    @Override
    public JComponent getValueComponent() {
        return this.startButton;
    }

    @Override
    public void appendToForm(DefaultFormBuilder builder) {
        this.appendToForm(builder, this.startButton);
    }

    public Vector<String> getPossibleValues() {
        return this.buttons.getPossibleValues();
    }

    @Override
    public void setEnabled(boolean pEnabled) {
        if (this.startButton.isEnabled() != pEnabled) {
            this.startButton.setEnabled(pEnabled);
            super.setEnabled(pEnabled);
        }
    }

    @Override
    public void setValue(String value) {
        this.buttons.setValue(value);
        JToggleButton selectedButton = this.buttons.getSelectedButton();
        Icon icon = this.startButton.getIcon();
        this.startButton.setIcon(new FixSizeIconWrapper(icon.getIconWidth(), icon.getIconHeight(), selectedButton.getIcon()));
        this.startButton.setToolTipText(selectedButton.getToolTipText());
    }

    private void showButtonPanel(ActionEvent e) {
        this.buttons.showButtonDialog(this.startButton, this::firePropertyChangeEvent);
    }
}

