/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.bootimg;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.bootimg.BootImageHeader;
import ghidra.file.formats.android.bootimg.BootImageUtil;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class BootImageHeaderV3
extends BootImageHeader {
    private String magic;
    private int kernel_size;
    private int ramdisk_size;
    private int os_version;
    private int header_size;
    private int[] reserved;
    private int header_version;
    private String cmdline;

    public BootImageHeaderV3(BinaryReader reader) throws IOException {
        this.magic = reader.readNextAsciiString(8);
        this.kernel_size = reader.readNextInt();
        this.ramdisk_size = reader.readNextInt();
        this.os_version = reader.readNextInt();
        this.header_size = reader.readNextInt();
        this.reserved = reader.readNextIntArray(4);
        this.header_version = reader.readNextInt();
        this.cmdline = reader.readNextAsciiString(1536);
    }

    @Override
    public String getMagic() {
        return this.magic;
    }

    @Override
    public int getPageSize() {
        return 4096;
    }

    @Override
    public int getKernelSize() {
        return this.kernel_size;
    }

    @Override
    public int getKernelPageCount() {
        return (int)(this.pageAlign(this.kernel_size) / 4096L);
    }

    @Override
    public long getKernelOffset() {
        return 4096L;
    }

    @Override
    public int getRamdiskSize() {
        return this.ramdisk_size;
    }

    @Override
    public int getRamdiskPageCount() {
        return (int)(this.pageAlign(Integer.toUnsignedLong(this.ramdisk_size)) / 4096L);
    }

    @Override
    public int getRamdiskOffset() {
        return 4096 + this.getKernelPageCount() * 4096;
    }

    @Override
    public long getSecondOffset() {
        return 0L;
    }

    @Override
    public int getSecondSize() {
        return 0;
    }

    @Override
    public int getSecondPageCount() {
        return 0;
    }

    public int getOSVersion() {
        return this.os_version;
    }

    public int getHeaderSize() {
        return this.header_size;
    }

    public int[] getReserved() {
        return this.reserved;
    }

    public int getHeaderVersion() {
        return this.header_version;
    }

    @Override
    public String getCommandLine() {
        return this.cmdline;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("boot_img_hdr_v3", 0);
        structure.add(UTF8, 8, "magic", null);
        structure.add(DWORD, "kernel_size", null);
        structure.add(DWORD, "ramdisk_size", null);
        structure.add(DWORD, "os_version", BootImageUtil.getOSVersionString(this.os_version));
        structure.add(DWORD, "header_size", null);
        ArrayDataType array = new ArrayDataType(DWORD, 4, DWORD.getLength());
        structure.add((DataType)array, "reserved", null);
        structure.add(DWORD, "header_version", null);
        structure.add(UTF8, 1536, "cmdline", null);
        return structure;
    }
}

