/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.fbpk.v1;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.fbpk.FBPT;
import ghidra.file.formats.android.fbpk.FBPT_Entry;
import ghidra.file.formats.android.fbpk.v1.FBPTv1_Entry;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FBPTv1
extends FBPT {
    private String magic;
    private int nEntries;
    private List<FBPT_Entry> entries = new ArrayList<FBPT_Entry>();

    public FBPTv1(BinaryReader reader) throws IOException {
        this.magic = reader.readNextAsciiString("FBPT".length());
        reader.readNextInt();
        reader.readNextInt();
        reader.readNextInt();
        this.nEntries = reader.readNextInt();
        reader.readNextInt();
        reader.readNextInt();
        reader.readNextInt();
        reader.readNextInt();
        reader.readNextInt();
        reader.readNextInt();
        reader.readNextInt();
        reader.readNextInt();
        reader.readNextInt();
        reader.readNextInt();
        reader.readNextInt();
        reader.readNextInt();
        reader.readNextInt();
        for (int i = 0; i < this.nEntries; ++i) {
            this.entries.add(new FBPTv1_Entry(reader, i == this.nEntries - 1));
        }
    }

    @Override
    public String getMagic() {
        return this.magic;
    }

    public int getNEntries() {
        return this.nEntries;
    }

    @Override
    public List<FBPT_Entry> getEntries() {
        return this.entries;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(FBPTv1.class.getSimpleName(), 0);
        struct.add(STRING, "FBPT".length(), "magic", null);
        struct.add(DWORD, "unknown0", null);
        struct.add(DWORD, "unknown1", null);
        struct.add(DWORD, "unknown2", null);
        struct.add(DWORD, "nEntries", null);
        struct.add(DWORD, "unknown3", null);
        struct.add(DWORD, "unknown4", null);
        struct.add(DWORD, "unknown5", null);
        struct.add(DWORD, "unknown6", null);
        struct.add(DWORD, "unknown7", null);
        struct.add(DWORD, "unknown8", null);
        struct.add(DWORD, "unknown9", null);
        struct.add(DWORD, "unknownA", null);
        struct.add(DWORD, "unknownB", null);
        struct.add(DWORD, "unknownC", null);
        struct.add(DWORD, "unknownD", null);
        struct.add(DWORD, "unknownE", null);
        struct.add(DWORD, "unknownF", null);
        return struct;
    }
}

