/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.listing;

import generic.theme.GColor;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.util.viewer.listingpanel.ListingBackgroundColorModel;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.program.TraceProgramView;
import java.awt.Color;
import java.math.BigInteger;
import java.util.Map;

public class MemoryStateListingBackgroundColorModel
implements ListingBackgroundColorModel {
    private static final Color COLOR_BACKGROUND_ERROR = DebuggerResources.COLOR_BACKGROUND_ERROR;
    private static final GColor COLOR_BACKGROUND_UNKNOWN = DebuggerResources.COLOR_BACKGROUND_STALE;
    private static final Color COLOR_BACKGROUND_UNKNOWN_BLENDED = COLOR_BACKGROUND_UNKNOWN.withAlpha(127);
    private Color defaultBackgroundColor = new GColor("color.bg");
    private AddressIndexMap addressIndexMap;
    private TraceProgramView view;
    private TraceMemoryManager memory;

    public MemoryStateListingBackgroundColorModel(ListingPanel listingPanel) {
        this.modelDataChanged(listingPanel);
    }

    public Color getBackgroundColor(BigInteger index) {
        if (this.view == null) {
            return this.defaultBackgroundColor;
        }
        Address address = this.addressIndexMap.getAddress(index);
        if (address == null) {
            return this.defaultBackgroundColor;
        }
        Map.Entry state = this.memory.getViewState(this.view.getSnap(), address);
        if (state == null) {
            return this.defaultBackgroundColor;
        }
        switch ((TraceMemoryState)state.getValue()) {
            case UNKNOWN: {
                return this.getUnknownColor(address);
            }
            case ERROR: {
                return COLOR_BACKGROUND_ERROR;
            }
        }
        return this.defaultBackgroundColor;
    }

    protected Color getUnknownColor(Address address) {
        long snap = this.view.getSnap();
        Map.Entry ent = this.memory.getViewMostRecentStateEntry(snap, address);
        if (ent == null || ent.getValue() != TraceMemoryState.KNOWN) {
            return COLOR_BACKGROUND_UNKNOWN;
        }
        TraceMemoryRegion region = this.memory.getRegionContaining(((TraceAddressSnapRange)ent.getKey()).getY1().longValue(), address);
        if (region != null && !region.isWrite(snap)) {
            return COLOR_BACKGROUND_UNKNOWN_BLENDED;
        }
        return COLOR_BACKGROUND_UNKNOWN;
    }

    public Color getDefaultBackgroundColor() {
        return this.defaultBackgroundColor;
    }

    public void setDefaultBackgroundColor(Color c) {
        this.defaultBackgroundColor = c;
    }

    public void modelDataChanged(ListingPanel listingPanel) {
        this.addressIndexMap = listingPanel.getAddressIndexMap();
        Program program = listingPanel.getProgram();
        if (!(program instanceof TraceProgramView)) {
            this.view = null;
            this.memory = null;
            return;
        }
        TraceProgramView view = (TraceProgramView)program;
        this.view = view;
        this.memory = view.getTrace().getMemoryManager();
    }
}

