/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.indices.names;

import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.jrt.JrtFileSystem;
import com.intellij.util.indexing.FileContent;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.konan.FileWithMetadata;
import org.jetbrains.kotlin.analysis.decompiler.psi.BuiltInDefinitionFile;
import org.jetbrains.kotlin.analysis.decompiler.psi.KotlinBuiltInFileType;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.KotlinMetadataStubBuilder;
import org.jetbrains.kotlin.load.kotlin.KotlinBinaryClassCache;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmNameResolver;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmProtoBufUtil;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001e\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u000e\u0010\r\u001a\u0004\u0018\u00010\f*\u00020\u0006H\u0000\u001a\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u0006H\u0000\u001a\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u0015H\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"ALLOWED_METADATA_EXTENSIONS", "", "", "readKotlinMetadataDefinition", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata$Compatible;", "fileContent", "Lcom/intellij/util/indexing/FileContent;", "readProtoPackageData", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmNameResolver;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Package;", "kotlinJvmBinaryClass", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;", "toKotlinJvmBinaryClass", "packageName", "Lorg/jetbrains/kotlin/name/FqName;", "getPackageName", "(Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;)Lorg/jetbrains/kotlin/name/FqName;", "toCompatibleFileWithMetadata", "Lorg/jetbrains/kotlin/analysis/decompiler/konan/FileWithMetadata$Compatible;", "getJrtModuleRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.base.indices"})
@SourceDebugExtension(value={"SMAP\ninternalUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 internalUtils.kt\norg/jetbrains/kotlin/idea/base/indices/names/InternalUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n2746#2,3:94\n19652#3,2:97\n1#4:99\n*S KotlinDebug\n*F\n+ 1 internalUtils.kt\norg/jetbrains/kotlin/idea/base/indices/names/InternalUtilsKt\n*L\n34#1:94,3\n47#1:97,2\n*E\n"})
public final class InternalUtilsKt {
    @NotNull
    private static final List<String> ALLOWED_METADATA_EXTENSIONS;

    @Nullable
    public static final KotlinMetadataStubBuilder.FileWithMetadata.Compatible readKotlinMetadataDefinition(@NotNull FileContent fileContent) {
        boolean bl;
        KotlinMetadataStubBuilder.FileWithMetadata.Compatible definition;
        block11: {
            boolean bl2;
            block10: {
                Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
                if (!Intrinsics.areEqual((Object)fileContent.getFileType(), (Object)KotlinBuiltInFileType.INSTANCE)) {
                    return null;
                }
                String string = fileContent.getFileName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
                String fileName = string;
                Iterable $this$none$iv = ALLOWED_METADATA_EXTENSIONS;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!StringsKt.endsWith$default((String)fileName, (String)it, (boolean)false, (int)2, null)) continue;
                        bl2 = false;
                        break block10;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                return null;
            }
            byte[] byArray = fileContent.getContent();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getContent(...)");
            VirtualFile virtualFile = fileContent.getFile().getParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
            KotlinMetadataStubBuilder.FileWithMetadata fileWithMetadata = BuiltInDefinitionFile.Companion.read$default((BuiltInDefinitionFile.Companion)BuiltInDefinitionFile.Companion, (byte[])byArray, (VirtualFile)virtualFile, (boolean)false, (int)4, null);
            KotlinMetadataStubBuilder.FileWithMetadata.Compatible compatible = fileWithMetadata instanceof KotlinMetadataStubBuilder.FileWithMetadata.Compatible ? (KotlinMetadataStubBuilder.FileWithMetadata.Compatible)fileWithMetadata : null;
            if (compatible == null) {
                return null;
            }
            definition = compatible;
            int nestingLevel = definition.getPackageFqName().pathSegments().size();
            VirtualFile virtualFile2 = (VirtualFile)SequencesKt.firstOrNull((Sequence)SequencesKt.drop((Sequence)SequencesKt.generateSequence((Object)fileContent.getFile(), InternalUtilsKt::readKotlinMetadataDefinition$lambda$1), (int)(nestingLevel + 1)));
            if (virtualFile2 == null) {
                return null;
            }
            VirtualFile rootPackageDirectory = virtualFile2;
            VirtualFile virtualFile3 = rootPackageDirectory.findChild("META-INF");
            if (virtualFile3 == null) {
                return null;
            }
            VirtualFile metaInfDirectory = virtualFile3;
            VirtualFile[] virtualFileArray = metaInfDirectory.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
            Object[] $this$none$iv = virtualFileArray;
            boolean $i$f$none = false;
            for (Object element$iv : $this$none$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)it.getExtension(), (Object)"kotlin_module")) continue;
                bl = false;
                break block11;
            }
            bl = true;
        }
        if (bl) {
            return null;
        }
        return definition;
    }

    @Nullable
    public static final Pair<JvmNameResolver, ProtoBuf.Package> readProtoPackageData(@NotNull KotlinJvmBinaryClass kotlinJvmBinaryClass) {
        Intrinsics.checkNotNullParameter((Object)kotlinJvmBinaryClass, (String)"kotlinJvmBinaryClass");
        KotlinClassHeader header = kotlinJvmBinaryClass.getClassHeader();
        String[] stringArray = header.getData();
        if (stringArray == null && (stringArray = header.getIncompatibleData()) == null) {
            return null;
        }
        String[] data = stringArray;
        String[] stringArray2 = header.getStrings();
        if (stringArray2 == null) {
            return null;
        }
        String[] strings = stringArray2;
        return JvmProtoBufUtil.readPackageDataFrom((String[])data, (String[])strings);
    }

    @Nullable
    public static final KotlinJvmBinaryClass toKotlinJvmBinaryClass(@NotNull FileContent $this$toKotlinJvmBinaryClass) {
        KotlinClassFinder.Result result2;
        Intrinsics.checkNotNullParameter((Object)$this$toKotlinJvmBinaryClass, (String)"<this>");
        try {
            VirtualFile virtualFile = $this$toKotlinJvmBinaryClass.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            KotlinClassFinder.Result result3 = KotlinBinaryClassCache.Companion.getKotlinBinaryClassOrClassFileContent$default((KotlinBinaryClassCache.Companion)KotlinBinaryClassCache.Companion, (VirtualFile)virtualFile, (MetadataVersion)MetadataVersion.INSTANCE, (byte[])$this$toKotlinJvmBinaryClass.getContent(), null, (int)8, null);
            if (result3 == null) {
                return null;
            }
            result2 = result3;
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            return null;
        }
        KotlinClassFinder.Result result4 = result2;
        KotlinClassFinder.Result.KotlinClass kotlinClass = result4 instanceof KotlinClassFinder.Result.KotlinClass ? (KotlinClassFinder.Result.KotlinClass)result4 : null;
        if (kotlinClass == null) {
            return null;
        }
        KotlinClassFinder.Result.KotlinClass kotlinClass2 = kotlinClass;
        return kotlinClass2.getKotlinJvmBinaryClass();
    }

    @NotNull
    public static final FqName getPackageName(@NotNull KotlinJvmBinaryClass $this$packageName) {
        FqName fqName2;
        Intrinsics.checkNotNullParameter((Object)$this$packageName, (String)"<this>");
        String string = $this$packageName.getClassHeader().getPackageName();
        if (string != null) {
            String p0 = string;
            boolean bl = false;
            fqName2 = new FqName(p0);
        } else {
            fqName2 = $this$packageName.getClassId().getPackageFqName();
        }
        return fqName2;
    }

    @Nullable
    public static final FileWithMetadata.Compatible toCompatibleFileWithMetadata(@NotNull FileContent $this$toCompatibleFileWithMetadata) {
        Intrinsics.checkNotNullParameter((Object)$this$toCompatibleFileWithMetadata, (String)"<this>");
        VirtualFile virtualFile = $this$toCompatibleFileWithMetadata.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        FileWithMetadata fileWithMetadata = FileWithMetadata.Companion.forPackageFragment(virtualFile);
        return fileWithMetadata instanceof FileWithMetadata.Compatible ? (FileWithMetadata.Compatible)fileWithMetadata : null;
    }

    @Nullable
    public static final VirtualFile getJrtModuleRoot(@NotNull VirtualFile $this$getJrtModuleRoot) {
        Intrinsics.checkNotNullParameter((Object)$this$getJrtModuleRoot, (String)"<this>");
        VirtualFile currentFile = $this$getJrtModuleRoot;
        while (!JrtFileSystem.isModuleRoot((VirtualFile)currentFile)) {
            if (currentFile.getParent() != null) continue;
            return null;
        }
        return currentFile;
    }

    private static final VirtualFile readKotlinMetadataDefinition$lambda$1(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }

    static {
        Object[] objectArray = new String[]{".kotlin_builtins", ".kotlin_metadata"};
        ALLOWED_METADATA_EXTENSIONS = CollectionsKt.listOf((Object[])objectArray);
    }
}

