/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.classLoading;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DexDebugFacility;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.AbstractAndroidClassLoadingAdapter;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassLoadingAdapter;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoad;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/AndroidOClassLoadingAdapter;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/AbstractAndroidClassLoadingAdapter;", "<init>", "()V", "isApplicable", "", "context", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "info", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassLoadingAdapter$Companion$ClassInfoForEvaluator;", "resolveClassLoaderClass", "Lcom/sun/jdi/ClassType;", "loadClasses", "Lcom/sun/jdi/ClassLoaderReference;", "classes", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassToLoad;", "kotlin.jvm-debugger.evaluation"})
public final class AndroidOClassLoadingAdapter
extends AbstractAndroidClassLoadingAdapter {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicable(@NotNull ExecutionContext context, @NotNull ClassLoadingAdapter.Companion.ClassInfoForEvaluator info2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        ClassLoadingAdapter.Companion.ClassInfoForEvaluator $this$isApplicable_u24lambda_u240 = info2;
        boolean bl = false;
        if (!$this$isApplicable_u24lambda_u240.isCompilingEvaluatorPreferred()) return false;
        VirtualMachine virtualMachine = context.getEvaluationContext().getVirtualMachineProxy().getVirtualMachine();
        Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"getVirtualMachine(...)");
        if (!DexDebugFacility.INSTANCE.isDex(virtualMachine)) return false;
        return true;
    }

    private final ClassType resolveClassLoaderClass(ExecutionContext context) {
        ClassType classType;
        try {
            ClassLoaderReference classLoader = context.getClassLoader();
            ReferenceType referenceType = this.tryLoadClass(context, "dalvik.system.InMemoryDexClassLoader", classLoader);
            classType = referenceType instanceof ClassType ? (ClassType)referenceType : null;
        }
        catch (EvaluateException e) {
            classType = null;
        }
        return classType;
    }

    @Override
    @NotNull
    public ClassLoaderReference loadClasses(@NotNull ExecutionContext context, @NotNull Collection<ClassToLoad> classes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        ClassType classType = this.resolveClassLoaderClass(context);
        if (classType == null) {
            throw new IllegalStateException("InMemoryDexClassLoader class not found".toString());
        }
        ClassType inMemoryClassLoaderClass = classType;
        Method method = inMemoryClassLoaderClass.concreteMethodByName("<init>", "(Ljava/nio/ByteBuffer;Ljava/lang/ClassLoader;)V");
        if (method == null) {
            throw new IllegalStateException("Constructor method not found".toString());
        }
        Method constructorMethod = method;
        byte[] byArray = this.dex(context, classes);
        if (byArray == null) {
            throw new IllegalStateException("Can't dex classes".toString());
        }
        byte[] dexBytes = byArray;
        ArrayReference arrayReference = DebuggerUtilsEx.mirrorOfByteArray((byte[])dexBytes, (EvaluationContext)((EvaluationContext)context.getEvaluationContext()));
        Intrinsics.checkNotNullExpressionValue((Object)arrayReference, (String)"mirrorOfByteArray(...)");
        ArrayReference dexBytesMirror = arrayReference;
        ObjectReference dexByteBuffer = this.wrapToByteBuffer(dexBytesMirror, context);
        ClassLoaderReference classLoader = context.getClassLoader();
        Object[] objectArray = new ObjectReference[]{dexByteBuffer, classLoader};
        List args = CollectionsKt.listOf((Object[])objectArray);
        ObjectReference objectReference = context.newInstance(inMemoryClassLoaderClass, constructorMethod, args);
        Intrinsics.checkNotNull((Object)objectReference, (String)"null cannot be cast to non-null type com.sun.jdi.ClassLoaderReference");
        ClassLoaderReference newClassLoader = (ClassLoaderReference)objectReference;
        context.keepReference(newClassLoader);
        return newClassLoader;
    }
}

