/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.injection;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.base.fe10.analysis.AnnotationDescriptorUtils;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.idea.base.injection.InjectionInfo;
import org.jetbrains.kotlin.idea.base.injection.KotlinLanguageInjectionContributorBase;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.caches.resolve.ResolveInDispatchThreadManagerKt;
import org.jetbrains.kotlin.idea.injection.KotlinLanguageInjectionContributor;
import org.jetbrains.kotlin.idea.injection.KotlinLanguageInjectionSupport;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.KtReferenceKt;
import org.jetbrains.kotlin.idea.search.usagesSearch.SearchHelpersKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J$\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001f\u001a\u00020 H\u0002R\u001d\u0010\u0004\u001a\u0004\u0018\u00010\u00058VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/injection/KotlinLanguageInjectionContributor;", "Lorg/jetbrains/kotlin/idea/base/injection/KotlinLanguageInjectionContributorBase;", "<init>", "()V", "kotlinSupport", "Lorg/jetbrains/kotlin/idea/injection/KotlinLanguageInjectionSupport;", "getKotlinSupport", "()Lorg/jetbrains/kotlin/idea/injection/KotlinLanguageInjectionSupport;", "kotlinSupport$delegate", "Lkotlin/Lazy;", "hasCallableId", "", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "packageName", "Lorg/jetbrains/kotlin/name/FqName;", "callableName", "Lorg/jetbrains/kotlin/name/Name;", "resolveReference", "Lcom/intellij/psi/PsiElement;", "reference", "Lcom/intellij/psi/PsiReference;", "injectionInfoByAnnotation", "Lorg/jetbrains/kotlin/idea/base/injection/InjectionInfo;", "callableDeclaration", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "injectionInfoByParameterAnnotation", "functionReference", "Lorg/jetbrains/kotlin/idea/references/KtReference;", "argumentName", "argumentIndex", "", "annotated", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotated;", "kotlin.injection.k1"})
@SourceDebugExtension(value={"SMAP\nKotlinLanguageInjectionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinLanguageInjectionContributor.kt\norg/jetbrains/kotlin/idea/injection/KotlinLanguageInjectionContributor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 AnnotationDescriptorUtils.kt\norg/jetbrains/kotlin/base/fe10/analysis/AnnotationDescriptorUtils\n*L\n1#1,76:1\n295#2,2:77\n808#2,11:80\n27#3:79\n*S KotlinDebug\n*F\n+ 1 KotlinLanguageInjectionContributor.kt\norg/jetbrains/kotlin/idea/injection/KotlinLanguageInjectionContributor\n*L\n62#1:77,2\n31#1:80,11\n70#1:79\n*E\n"})
public final class KotlinLanguageInjectionContributor
extends KotlinLanguageInjectionContributorBase {
    @NotNull
    private final Lazy kotlinSupport$delegate = LazyKt.lazy(KotlinLanguageInjectionContributor::kotlinSupport_delegate$lambda$0);

    @Override
    @Nullable
    public KotlinLanguageInjectionSupport getKotlinSupport() {
        Lazy lazy = this.kotlinSupport$delegate;
        return (KotlinLanguageInjectionSupport)((Object)lazy.getValue());
    }

    @Override
    public boolean hasCallableId(@NotNull KtCallExpression $this$hasCallableId, @NotNull FqName packageName, @NotNull Name callableName) {
        Intrinsics.checkNotNullParameter((Object)$this$hasCallableId, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)callableName, (String)"callableName");
        CallableDescriptor callableDescriptor = ResolutionUtils.resolveToCall((KtElement)$this$hasCallableId, BodyResolveMode.PARTIAL);
        if (callableDescriptor == null || (callableDescriptor = callableDescriptor.getCandidateDescriptor()) == null || (callableDescriptor = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)callableDescriptor))) == null) {
            return false;
        }
        CallableDescriptor fqName2 = callableDescriptor;
        return Intrinsics.areEqual((Object)fqName2.parent(), (Object)packageName) && Intrinsics.areEqual((Object)fqName2.shortName(), (Object)callableName);
    }

    @Override
    @Nullable
    public PsiElement resolveReference(@NotNull PsiReference reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        return (PsiElement)ResolveInDispatchThreadManagerKt.allowResolveInDispatchThread(() -> KotlinLanguageInjectionContributor.resolveReference$lambda$1(reference));
    }

    @Override
    @Nullable
    public InjectionInfo injectionInfoByAnnotation(@NotNull KtCallableDeclaration callableDeclaration) {
        Intrinsics.checkNotNullParameter((Object)callableDeclaration, (String)"callableDeclaration");
        String packageName = callableDeclaration.getContainingKtFile().getPackageFqName().asString();
        String string = StandardNames.BUILT_INS_PACKAGE_NAME.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String kotlinPackage = string;
        if (Intrinsics.areEqual((Object)packageName, (Object)kotlinPackage) || StringsKt.startsWith$default((String)packageName, (String)(kotlinPackage + "."), (boolean)false, (int)2, null)) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)ResolveInDispatchThreadManagerKt.allowResolveInDispatchThread(() -> KotlinLanguageInjectionContributor.injectionInfoByAnnotation$lambda$2(callableDeclaration));
        if (declarationDescriptor == null) {
            return null;
        }
        DeclarationDescriptor descriptor2 = declarationDescriptor;
        return this.injectionInfoByAnnotation((Annotated)descriptor2);
    }

    @Override
    @Nullable
    public InjectionInfo injectionInfoByParameterAnnotation(@NotNull KtReference functionReference, @Nullable Name argumentName2, int argumentIndex) {
        ValueParameterDescriptor valueParameterDescriptor;
        Intrinsics.checkNotNullParameter((Object)functionReference, (String)"functionReference");
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)ResolveInDispatchThreadManagerKt.allowResolveInDispatchThread(() -> KotlinLanguageInjectionContributor.injectionInfoByParameterAnnotation$lambda$3(functionReference));
        if (functionDescriptor == null) {
            return null;
        }
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        if (argumentName2 != null) {
            Object v2;
            block5: {
                List list2 = functionDescriptor2.getValueParameters();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
                Iterable $this$firstOrNull$iv = list2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)argumentName2)) continue;
                    v2 = element$iv;
                    break block5;
                }
                v2 = null;
            }
            valueParameterDescriptor = v2;
        } else {
            List list3 = functionDescriptor2.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getValueParameters(...)");
            valueParameterDescriptor = (ValueParameterDescriptor)CollectionsKt.getOrNull((List)list3, (int)argumentIndex);
        }
        if (valueParameterDescriptor == null) {
            return null;
        }
        ValueParameterDescriptor parameterDescriptor = valueParameterDescriptor;
        return this.injectionInfoByAnnotation((Annotated)parameterDescriptor);
    }

    private final InjectionInfo injectionInfoByAnnotation(Annotated annotated) {
        Annotated $this$findAnnotation$iv = annotated;
        boolean $i$f$findAnnotation = false;
        AnnotationDescriptor annotationDescriptor = AnnotationDescriptorUtils.findAnnotation($this$findAnnotation$iv, Language.class);
        if (annotationDescriptor == null) {
            return null;
        }
        AnnotationDescriptor injectAnnotation = annotationDescriptor;
        String string = AnnotationDescriptorUtils.getStringValue(injectAnnotation, (KProperty)injectionInfoByAnnotation.languageId.1.INSTANCE);
        if (string == null) {
            return null;
        }
        String languageId2 = string;
        String prefix2 = AnnotationDescriptorUtils.getStringValue(injectAnnotation, (KProperty)injectionInfoByAnnotation.prefix.1.INSTANCE);
        String suffix2 = AnnotationDescriptorUtils.getStringValue(injectAnnotation, (KProperty)injectionInfoByAnnotation.suffix.1.INSTANCE);
        return new InjectionInfo(languageId2, prefix2, suffix2);
    }

    /*
     * WARNING - void declaration
     */
    private static final KotlinLanguageInjectionSupport kotlinSupport_delegate$lambda$0() {
        void var3_3;
        void $this$filterIsInstanceTo$iv$iv;
        Collection collection = InjectorUtils.getActiveInjectionSupports();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getActiveInjectionSupports(...)");
        Iterable $this$filterIsInstance$iv = collection;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KotlinLanguageInjectionSupport)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (KotlinLanguageInjectionSupport)((Object)CollectionsKt.firstOrNull((List)((List)var3_3)));
    }

    private static final PsiElement resolveReference$lambda$1(PsiReference $reference) {
        return $reference.resolve();
    }

    private static final DeclarationDescriptor injectionInfoByAnnotation$lambda$2(KtCallableDeclaration $callableDeclaration) {
        return SearchHelpersKt.getDescriptor((KtDeclaration)$callableDeclaration);
    }

    private static final FunctionDescriptor injectionInfoByParameterAnnotation$lambda$3(KtReference $functionReference) {
        BindingContext bindingContext = ResolutionUtils.analyze($functionReference.getElement(), BodyResolveMode.PARTIAL_WITH_DIAGNOSTICS);
        Object object = CollectionsKt.singleOrNull((Iterable)KtReferenceKt.resolveToDescriptors($functionReference, bindingContext));
        return object instanceof FunctionDescriptor ? (FunctionDescriptor)object : null;
    }
}

