/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.classes;

import com.intellij.rt.coverage.instrumentation.InstrumentationUtils;
import com.intellij.rt.coverage.instrumentation.data.InstrumentationData;
import com.intellij.rt.coverage.instrumentation.data.Key;
import com.intellij.rt.coverage.instrumentation.filters.classes.ClassSignatureFilter;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;

public class KotlinSerializerFilter
implements ClassSignatureFilter {
    public static final String SERIALIZER_SUFFIX = "$$serializer";

    /*
     * WARNING - void declaration
     */
    public boolean shouldIgnore(InstrumentationData context) {
        void var1_1;
        void var2_2;
        void var3_3;
        ClassReader cr = context.get(Key.CLASS_READER);
        String className = context.get(Key.CLASS_INTERNAL_NAME);
        if (!className.endsWith(SERIALIZER_SUFFIX)) {
            return false;
        }
        String[] interfaces = cr.getInterfaces();
        if (interfaces.length != 1 || !"kotlinx/serialization/internal/GeneratedSerializer".equals(var3_3[0])) {
            return false;
        }
        String parentName = InstrumentationUtils.getParentClassIfIsInner(cr);
        return parentName != null && ((String)var2_2 + SERIALIZER_SUFFIX).equals(var1_1);
    }
}

