/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.coverage.gnu.trove;

import org.jetbrains.coverage.gnu.trove.PrimeFinder;

public abstract class THash
implements Cloneable {
    protected transient int _size;
    protected transient int _free;
    protected static final float DEFAULT_LOAD_FACTOR = 0.8f;
    protected static final int DEFAULT_INITIAL_CAPACITY = 4;
    protected float _loadFactor;
    protected int _maxSize;

    public THash() {
        this(4, 0.8f);
    }

    /*
     * WARNING - void declaration
     */
    public THash(int initialCapacity) {
        this((int)var1_1, 0.8f);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public THash(int initialCapacity, float loadFactor) {
        void var2_2;
        void var1_1;
        this._loadFactor = loadFactor;
        this.setUp((int)((float)var1_1 / var2_2) + 1);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    public int size() {
        return this._size;
    }

    protected abstract int capacity();

    /*
     * WARNING - void declaration
     */
    public void ensureCapacity(int desiredCapacity) {
        if (desiredCapacity > this._maxSize - this.size()) {
            void var1_1;
            this.rehash(PrimeFinder.nextPrime((int)((float)var1_1 + (float)this.size() / this._loadFactor) + 2));
            THash tHash = this;
            tHash.computeMaxSize(tHash.capacity());
        }
    }

    public void compact() {
        THash tHash = this;
        tHash.rehash(PrimeFinder.nextPrime((int)((float)tHash.size() / this._loadFactor) + 2));
        THash tHash2 = this;
        tHash2.computeMaxSize(tHash2.capacity());
    }

    public final void trimToSize() {
        this.compact();
    }

    protected void removeAt(int index) {
        --this._size;
    }

    public void clear() {
        this._size = 0;
        this._free = this.capacity();
    }

    /*
     * WARNING - void declaration
     */
    protected int setUp(int initialCapacity) {
        void var1_1;
        int capacity = PrimeFinder.nextPrime(initialCapacity);
        this.computeMaxSize(capacity);
        return (int)var1_1;
    }

    protected abstract void rehash(int var1);

    /*
     * WARNING - void declaration
     */
    private final void computeMaxSize(int capacity) {
        void var1_1;
        this._maxSize = Math.min(capacity - 1, (int)((float)capacity * this._loadFactor));
        this._free = var1_1 - this._size;
    }

    protected final void postInsertHook(boolean usedFreeSlot) {
        if (usedFreeSlot) {
            --this._free;
        }
        if (++this._size > this._maxSize || this._free == 0) {
            THash tHash = this;
            tHash.rehash(PrimeFinder.nextPrime(tHash.calculateGrownCapacity()));
            THash tHash2 = this;
            tHash2.computeMaxSize(tHash2.capacity());
        }
    }

    protected int calculateGrownCapacity() {
        return this.capacity() << 1;
    }
}

