/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.tree.filter;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.filter.DependencyNodeFilter;

public class AncestorOrSelfDependencyNodeFilter
implements DependencyNodeFilter {
    private final List descendantNodes;

    public AncestorOrSelfDependencyNodeFilter(DependencyNode descendantNode) {
        this(Collections.singletonList(descendantNode));
    }

    public AncestorOrSelfDependencyNodeFilter(List descendantNodes) {
        this.descendantNodes = descendantNodes;
    }

    public boolean accept(DependencyNode node) {
        boolean accept = false;
        Iterator iterator = this.descendantNodes.iterator();
        while (!accept && iterator.hasNext()) {
            DependencyNode descendantNode = (DependencyNode)iterator.next();
            if (!this.isAncestorOrSelf(node, descendantNode)) continue;
            accept = true;
        }
        return accept;
    }

    private boolean isAncestorOrSelf(DependencyNode ancestorNode, DependencyNode descendantNode) {
        boolean ancestor = false;
        while (!ancestor && descendantNode != null) {
            ancestor = ancestorNode.equals(descendantNode);
            descendantNode = descendantNode.getParent();
        }
        return ancestor;
    }
}

