/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.ui.create.model;

import com.intellij.openapi.project.Project;
import git4idea.GitBranch;
import git4idea.GitRemoteBranch;
import git4idea.config.GitSharedSettings;
import git4idea.repo.GitBranchTrackInfo;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.plugins.gitlab.mergerequest.ui.create.model.BranchState;
import org.jetbrains.plugins.gitlab.mergerequest.ui.create.model.MergeRequestRequirementsErrorType;
import org.jetbrains.plugins.gitlab.util.GitLabProjectMapping;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a#\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006H\u0002\u00a2\u0006\u0002\u0010\t\u001a\u001a\u0010\n\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"checkDirection", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/create/model/MergeRequestRequirementsErrorType;", "branchState", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/create/model/BranchState;", "checkChanges", "loadingCommits", "Lkotlin/Result;", "", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "(Ljava/lang/Object;)Lorg/jetbrains/plugins/gitlab/mergerequest/ui/create/model/MergeRequestRequirementsErrorType;", "checkProtectedBranch", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.gitlab"})
public final class GitLabMergeRequestCreateViewModelKt {
    private static final MergeRequestRequirementsErrorType checkDirection(BranchState branchState) {
        GitBranch headBranch = branchState.getHeadBranch();
        GitRemoteBranch baseBranch = branchState.getBaseBranch();
        GitLabProjectMapping baseRepo = branchState.getBaseRepo();
        GitBranchTrackInfo gitBranchTrackInfo = baseRepo.getGitRepository().getBranchTrackInfo(baseBranch.getNameForRemoteOperations());
        if (gitBranchTrackInfo == null) {
            return null;
        }
        GitBranchTrackInfo trackInfo = gitBranchTrackInfo;
        return Intrinsics.areEqual((Object)trackInfo.getLocalBranch(), (Object)headBranch) ? MergeRequestRequirementsErrorType.WRONG_DIRECTION : null;
    }

    private static final MergeRequestRequirementsErrorType checkChanges(Object loadingCommits) {
        MergeRequestRequirementsErrorType mergeRequestRequirementsErrorType;
        Object object = loadingCommits;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable == null) {
            List commits2 = (List)object;
            boolean bl = false;
            mergeRequestRequirementsErrorType = !((Collection)commits2).isEmpty() ? null : MergeRequestRequirementsErrorType.NO_CHANGES;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            mergeRequestRequirementsErrorType = null;
        }
        return mergeRequestRequirementsErrorType;
    }

    private static final MergeRequestRequirementsErrorType checkProtectedBranch(BranchState branchState, Project project) {
        String localBranchName;
        GitSharedSettings settings = GitSharedSettings.getInstance((Project)project);
        String string = localBranchName = branchState.getHeadBranch() instanceof GitRemoteBranch ? ((GitRemoteBranch)branchState.getHeadBranch()).getNameForRemoteOperations() : branchState.getHeadBranch().getName();
        if (!settings.isBranchProtected(localBranchName)) {
            return null;
        }
        return MergeRequestRequirementsErrorType.PROTECTED_BRANCH;
    }

    public static final /* synthetic */ MergeRequestRequirementsErrorType access$checkDirection(BranchState branchState) {
        return GitLabMergeRequestCreateViewModelKt.checkDirection(branchState);
    }

    public static final /* synthetic */ MergeRequestRequirementsErrorType access$checkChanges(Object loadingCommits) {
        return GitLabMergeRequestCreateViewModelKt.checkChanges(loadingCommits);
    }

    public static final /* synthetic */ MergeRequestRequirementsErrorType access$checkProtectedBranch(BranchState branchState, Project project) {
        return GitLabMergeRequestCreateViewModelKt.checkProtectedBranch(branchState, project);
    }
}

