/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.oauth;

import jakarta.json.JsonObject;
import org.openstreetmap.josm.data.oauth.OAuthException;
import org.openstreetmap.josm.data.oauth.OAuthVersion;

public final class OAuth20Exception
extends OAuthException {
    private static final long serialVersionUID = -203910656089454886L;
    private final Type type;

    public OAuth20Exception(Exception cause) {
        super(cause);
        this.type = Type.unknown;
    }

    public OAuth20Exception(String message) {
        super(message);
        this.type = Type.unknown;
    }

    OAuth20Exception(JsonObject serverMessage) {
        super(serverMessage != null ? serverMessage.getString("error_description", serverMessage.getString("error", "Unknown error")) : "Unknown error");
        if (serverMessage != null && serverMessage.containsKey("error")) {
            switch (serverMessage.getString("error")) {
                case "invalid_request": 
                case "invalid_client": 
                case "invalid_grant": 
                case "unauthorized_client": 
                case "unsupported_grant_type": 
                case "invalid_scope": {
                    this.type = Type.valueOf(serverMessage.getString("error"));
                    break;
                }
                default: {
                    this.type = Type.unknown;
                    break;
                }
            }
        } else {
            this.type = Type.unknown;
        }
    }

    @Override
    OAuthVersion[] getOAuthVersions() {
        return new OAuthVersion[]{OAuthVersion.OAuth20};
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (message == null) {
            return "OAuth error " + String.valueOf((Object)this.type);
        }
        return "OAuth error " + String.valueOf((Object)this.type) + ": " + message;
    }

    public static enum Type {
        invalid_request,
        invalid_client,
        invalid_grant,
        unauthorized_client,
        unsupported_grant_type,
        invalid_scope,
        unknown;

    }
}

