/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.util.Objects;
import org.openstreetmap.josm.data.oauth.IOAuthParameters;
import org.openstreetmap.josm.data.oauth.IOAuthToken;
import org.openstreetmap.josm.data.oauth.OAuthVersion;
import org.openstreetmap.josm.gui.oauth.AdvancedOAuthPropertiesPanel;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public abstract class AbstractAuthorizationUI
extends VerticallyScrollablePanel {
    public static final String ACCESS_TOKEN_PROP = AbstractAuthorizationUI.class.getName() + ".accessToken";
    private String apiUrl;
    private final AdvancedOAuthPropertiesPanel pnlAdvancedProperties;
    private transient IOAuthToken accessToken;

    protected AbstractAuthorizationUI(String apiUrl, OAuthVersion oAuthVersion) {
        this.pnlAdvancedProperties = new AdvancedOAuthPropertiesPanel(oAuthVersion);
        if (apiUrl != null) {
            this.setApiUrl(apiUrl);
        }
    }

    protected void fireAccessTokenChanged(IOAuthToken oldValue, IOAuthToken newValue) {
        this.firePropertyChange(ACCESS_TOKEN_PROP, oldValue, newValue);
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
        this.pnlAdvancedProperties.setApiUrl(apiUrl);
    }

    protected AdvancedOAuthPropertiesPanel getAdvancedPropertiesPanel() {
        return this.pnlAdvancedProperties;
    }

    public IOAuthParameters getOAuthParameters() {
        return this.pnlAdvancedProperties.getAdvancedParameters();
    }

    public IOAuthToken getAccessToken() {
        return this.accessToken;
    }

    protected void setAccessToken(IOAuthToken accessToken) {
        IOAuthToken oldValue = this.accessToken;
        this.accessToken = accessToken;
        if (oldValue == null ^ this.accessToken == null) {
            this.fireAccessTokenChanged(oldValue, this.accessToken);
        } else if (!(oldValue == null && this.accessToken == null || Objects.equals(oldValue, this.accessToken))) {
            this.fireAccessTokenChanged(oldValue, this.accessToken);
        }
    }

    public OAuthVersion getOAuthVersion() {
        return this.pnlAdvancedProperties.getAdvancedParameters().getOAuthVersion();
    }

    public boolean hasAccessToken() {
        return this.accessToken != null;
    }

    public abstract boolean isSaveAccessTokenToPreferences();

    public void initialize(String paramApiUrl) {
        CheckParameterUtil.ensureParameterNotNull(paramApiUrl, "paramApiUrl");
        this.pnlAdvancedProperties.initialize(paramApiUrl);
    }
}

