/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparators;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

@FunctionalInterface
public interface Comparator<T> {
    public int compare(T var1, T var2);

    public boolean equals(Object var1);

    default public Comparator<T> reversed() {
        return Collections.reverseOrder(this);
    }

    default public Comparator<T> thenComparing(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return (Comparator & Serializable)(object, object2) -> {
            int n = this.compare(object, object2);
            return n != 0 ? n : comparator.compare(object, object2);
        };
    }

    default public <U> Comparator<T> thenComparing(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return this.thenComparing(Comparator.comparing(function, comparator));
    }

    default public <U extends Comparable<? super U>> Comparator<T> thenComparing(Function<? super T, ? extends U> function) {
        return this.thenComparing(Comparator.comparing(function));
    }

    default public Comparator<T> thenComparingInt(ToIntFunction<? super T> toIntFunction) {
        return this.thenComparing(Comparator.comparingInt(toIntFunction));
    }

    default public Comparator<T> thenComparingLong(ToLongFunction<? super T> toLongFunction) {
        return this.thenComparing(Comparator.comparingLong(toLongFunction));
    }

    default public Comparator<T> thenComparingDouble(ToDoubleFunction<? super T> toDoubleFunction) {
        return this.thenComparing(Comparator.comparingDouble(toDoubleFunction));
    }

    public static <T extends Comparable<? super T>> Comparator<T> reverseOrder() {
        return Collections.reverseOrder();
    }

    public static <T extends Comparable<? super T>> Comparator<T> naturalOrder() {
        return Comparators.NaturalOrderComparator.INSTANCE;
    }

    public static <T> Comparator<T> nullsFirst(Comparator<? super T> comparator) {
        return new Comparators.NullComparator<T>(true, comparator);
    }

    public static <T> Comparator<T> nullsLast(Comparator<? super T> comparator) {
        return new Comparators.NullComparator<T>(false, comparator);
    }

    public static <T, U> Comparator<T> comparing(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        Objects.requireNonNull(function);
        Objects.requireNonNull(comparator);
        return (Comparator & Serializable)(object, object2) -> comparator.compare((Object)function.apply(object), (Object)function.apply(object2));
    }

    public static <T, U extends Comparable<? super U>> Comparator<T> comparing(Function<? super T, ? extends U> function) {
        Objects.requireNonNull(function);
        return (Comparator & Serializable)(object, object2) -> ((Comparable)function.apply(object)).compareTo(function.apply(object2));
    }

    public static <T> Comparator<T> comparingInt(ToIntFunction<? super T> toIntFunction) {
        Objects.requireNonNull(toIntFunction);
        return (Comparator & Serializable)(object, object2) -> Integer.compare(toIntFunction.applyAsInt(object), toIntFunction.applyAsInt(object2));
    }

    public static <T> Comparator<T> comparingLong(ToLongFunction<? super T> toLongFunction) {
        Objects.requireNonNull(toLongFunction);
        return (Comparator & Serializable)(object, object2) -> Long.compare(toLongFunction.applyAsLong(object), toLongFunction.applyAsLong(object2));
    }

    public static <T> Comparator<T> comparingDouble(ToDoubleFunction<? super T> toDoubleFunction) {
        Objects.requireNonNull(toDoubleFunction);
        return (Comparator & Serializable)(object, object2) -> Double.compare(toDoubleFunction.applyAsDouble(object), toDoubleFunction.applyAsDouble(object2));
    }
}

