/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.spec;

import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Objects;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.password.spec.PasswordSpec;

public final class DigestPasswordSpec
implements PasswordSpec {
    private final String username;
    private final String realm;
    private final byte[] digest;

    public DigestPasswordSpec(String username, String realm, byte[] digest) {
        this.username = username;
        this.realm = realm;
        this.digest = digest;
    }

    public String getUsername() {
        return this.username;
    }

    public String getRealm() {
        return this.realm;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public boolean equals(Object other) {
        if (!(other instanceof DigestPasswordSpec)) {
            return false;
        }
        DigestPasswordSpec o = (DigestPasswordSpec)other;
        return Objects.equals(this.username, o.username) && Objects.equals(this.realm, o.realm) && MessageDigest.isEqual(this.digest, o.digest);
    }

    public int hashCode() {
        return HashMath.multiHashOrdered((int)HashMath.multiHashOrdered((int)Objects.hashCode(this.username), (int)Objects.hashCode(this.realm)), (int)Arrays.hashCode(this.digest));
    }
}

