/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Access;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Embedded;
import java.util.Locale;
import org.hibernate.MappingException;
import org.hibernate.annotations.TargetEmbeddable;
import org.hibernate.boot.internal.Target;
import org.hibernate.boot.models.internal.ModelsHelper;
import org.hibernate.boot.spi.AccessType;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.models.internal.ClassTypeDetailsImpl;
import org.hibernate.models.internal.dynamic.DynamicClassDetails;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeVariableScope;

public class PropertyInferredData
implements PropertyData {
    private final AccessType defaultAccess;
    private final ClassDetails declaringClass;
    private final TypeVariableScope ownerType;
    private final MemberDetails propertyMember;
    private final MetadataBuildingContext buildingContext;

    public PropertyInferredData(ClassDetails declaringClass, TypeVariableScope ownerType, MemberDetails propertyMember, String propertyAccessor, MetadataBuildingContext buildingContext) {
        this.declaringClass = declaringClass;
        this.ownerType = ownerType;
        this.propertyMember = propertyMember;
        this.defaultAccess = AccessType.getAccessStrategy(propertyAccessor);
        this.buildingContext = buildingContext;
    }

    public String toString() {
        return String.format("PropertyInferredData{property=%s, declaringClass=%s}", this.propertyMember, this.declaringClass);
    }

    @Override
    public AccessType getDefaultAccess() throws MappingException {
        AccessType accessType = this.defaultAccess;
        AccessType jpaAccessType = AccessType.DEFAULT;
        Access access = (Access)this.propertyMember.getDirectAnnotationUsage(Access.class);
        if (access != null) {
            jpaAccessType = AccessType.getAccessStrategy(access.value());
        }
        if (jpaAccessType != AccessType.DEFAULT) {
            accessType = jpaAccessType;
        }
        return accessType;
    }

    @Override
    public String getPropertyName() throws MappingException {
        return this.propertyMember.resolveAttributeName();
    }

    @Override
    public TypeDetails getPropertyType() throws MappingException {
        Target targetAnnotation = (Target)this.propertyMember.getDirectAnnotationUsage(Target.class);
        ModelsContext sourceModelContext = this.buildingContext.getBootstrapContext().getModelsContext();
        if (targetAnnotation != null) {
            String targetName = targetAnnotation.value();
            ClassDetails classDetails = ModelsHelper.resolveClassDetails(targetName, sourceModelContext.getClassDetailsRegistry(), () -> new DynamicClassDetails(targetName, sourceModelContext));
            return new ClassTypeDetailsImpl(classDetails, TypeDetails.Kind.CLASS);
        }
        TargetEmbeddable targetEmbeddable = PropertyInferredData.getTargetEmbeddableAnnotation(this.propertyMember);
        if (targetEmbeddable != null) {
            return PropertyInferredData.resolveTargetEmbeddableAnnotation(targetEmbeddable, sourceModelContext);
        }
        return this.propertyMember.resolveRelativeType(this.ownerType);
    }

    private static TargetEmbeddable getTargetEmbeddableAnnotation(MemberDetails memberDetails) {
        TargetEmbeddable memberAnnotation = (TargetEmbeddable)memberDetails.getDirectAnnotationUsage(TargetEmbeddable.class);
        if (memberAnnotation != null) {
            boolean allowed;
            boolean bl = allowed = memberDetails.hasDirectAnnotationUsage(Embedded.class) || memberDetails.hasDirectAnnotationUsage(ElementCollection.class);
            if (!allowed) {
                throw new MappingException(String.format(Locale.ROOT, "@TargetEmbeddable can only be specified on properties marked with @Embedded or @ElementCollection [%s$%s]", memberDetails.getDeclaringType().getName(), memberDetails.getName()));
            }
            return memberAnnotation;
        }
        return (TargetEmbeddable)memberDetails.getAssociatedType().determineRawClass().getDirectAnnotationUsage(TargetEmbeddable.class);
    }

    private static ClassTypeDetailsImpl resolveTargetEmbeddableAnnotation(TargetEmbeddable targetEmbeddable, ModelsContext sourceModelContext) {
        ClassDetailsRegistry classDetailsRegistry = sourceModelContext.getClassDetailsRegistry();
        ClassDetails targetClassDetails = classDetailsRegistry.resolveClassDetails(targetEmbeddable.value().getName());
        return new ClassTypeDetailsImpl(targetClassDetails, TypeDetails.Kind.CLASS);
    }

    @Override
    public TypeDetails getClassOrElementType() throws MappingException {
        ModelsContext modelsContext = this.buildingContext.getBootstrapContext().getModelsContext();
        Target annotationUsage = (Target)this.propertyMember.getDirectAnnotationUsage(Target.class);
        if (annotationUsage != null) {
            String targetName = annotationUsage.value();
            ClassDetails classDetails = ModelsHelper.resolveClassDetails(targetName, modelsContext.getClassDetailsRegistry(), () -> new DynamicClassDetails(targetName, modelsContext));
            return new ClassTypeDetailsImpl(classDetails, TypeDetails.Kind.CLASS);
        }
        TargetEmbeddable targetEmbeddable = PropertyInferredData.getTargetEmbeddableAnnotation(this.propertyMember);
        if (targetEmbeddable != null) {
            return PropertyInferredData.resolveTargetEmbeddableAnnotation(targetEmbeddable, modelsContext);
        }
        return this.propertyMember.resolveRelativeAssociatedType(this.ownerType);
    }

    @Override
    public ClassDetails getClassOrPluralElement() throws MappingException {
        Target xmlTarget = (Target)this.propertyMember.getDirectAnnotationUsage(Target.class);
        if (xmlTarget != null) {
            return this.buildingContext.getMetadataCollector().getClassDetailsRegistry().getClassDetails(xmlTarget.value());
        }
        TargetEmbeddable targetEmbeddable = PropertyInferredData.getTargetEmbeddableAnnotation(this.propertyMember);
        if (targetEmbeddable != null) {
            String targetName = targetEmbeddable.value().getName();
            return this.buildingContext.getMetadataCollector().getClassDetailsRegistry().getClassDetails(targetName);
        }
        if (this.propertyMember.isPlural()) {
            return this.propertyMember.getElementType().determineRawClass();
        }
        return this.propertyMember.getAssociatedType().determineRawClass();
    }

    @Override
    public String getClassOrElementName() throws MappingException {
        return this.getClassOrElementType().getName();
    }

    @Override
    public String getTypeName() throws MappingException {
        return this.getPropertyType().getName();
    }

    @Override
    public MemberDetails getAttributeMember() {
        return this.propertyMember;
    }

    @Override
    public ClassDetails getDeclaringClass() {
        return this.declaringClass;
    }
}

