/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.spi;

import jakarta.persistence.LockModeType;
import jakarta.persistence.NamedQuery;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.internal.util.collections.CollectionHelper;

public record NamedQueryRegistration(String name, NamedQuery configuration) {
    public String getQueryString() {
        return this.configuration.query();
    }

    public LockModeType getLockModeType() {
        return this.configuration.lockMode();
    }

    public Map<String, String> getQueryHints() {
        Object[] hints = this.configuration.hints();
        if (CollectionHelper.isEmpty(hints)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = CollectionHelper.linkedMapOfSize(hints.length);
        for (Object hint : hints) {
            result.put(hint.name(), hint.value());
        }
        return result;
    }
}

