/*
 * serv.h
 *
 * MontaVista IPMI server include file
 *
 * Author: MontaVista Software, Inc.
 *         Corey Minyard <minyard@mvista.com>
 *         source@mvista.com
 *
 * Copyright 2003,2004,2005,2012 MontaVista Software Inc.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * Lesser General Public License (GPL) Version 2 or the modified BSD
 * license below.  The following disclamer applies to both licenses:
 *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 *  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 *  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 *  TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 *  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * GNU Lesser General Public Licence
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this program; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Modified BSD Licence
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above
 *      copyright notice, this list of conditions and the following
 *      disclaimer in the documentation and/or other materials provided
 *      with the distribution.
 *   3. The name of the author may not be used to endorse or promote
 *      products derived from this software without specific prior
 *      written permission.
 */

#ifndef __MSG_H_
#define __MSG_H_

#include <stdint.h>

typedef struct channel_s channel_t;

typedef struct msg_s
{
    void *src_addr;
    unsigned int src_len;
    int src_allocated;

    long oem_data; /* For use by OEM handlers.  This will be set to
                      zero by the calling code. */

    unsigned char channel;

    /* The channel the message originally came in on. */
    channel_t *orig_channel;

    unsigned char authtype;
    uint32_t      seq;
    uint32_t      sid;

    union {
	struct {
	    /* RMCP parms */
	    unsigned char *authcode;
	    unsigned char authcode_data[16];
	} rmcp;
	struct {
	    /* RMCP+ parms */
	    unsigned char payload;
	    unsigned char encrypted;
	    unsigned char authenticated;
	    unsigned char iana[3];
	    uint16_t      payload_id;
	    unsigned char *authdata;
	    unsigned int  authdata_len;
	} rmcpp;
    };

    unsigned char netfn;

    /*
     * Note that we don't keep this by rs and rq, we keep it by
     * destination (the first addr and lun in a message) and source
     * (the second destination and LIN in a message.  This makes a
     * little more sense for routing.
     */
    unsigned char daddr; /* rsSA on requests, rqSA on responses. */
    unsigned char dlun;  /* rsLUN on requests, rqLUN on responses. */
    unsigned char saddr; /* rqSA on requests, rqSA on responses. */
    unsigned char slun;  /* rqLUN on requests, rsLUN on responses. */
    unsigned char rq_seq;
    unsigned char cmd;

    int track; /* Do message tracking on this message? */

    unsigned char *data;
    unsigned int  len;

    uint32_t iana; /* Set for IANA commands */

    unsigned int time_to_live;

    struct msg_s *next;
} msg_t;

#define IPMI_SIM_MAX_MSG_LENGTH 255

typedef struct rsp_msg
{
    uint8_t        netfn;
    uint8_t        cmd;
    unsigned short data_len;
    uint8_t        *data;
} rsp_msg_t;

typedef struct sys_data_s sys_data_t;
typedef struct startcmd_s startcmd_t;
typedef struct user_s user_t;
typedef struct pef_data_s pef_data_t;

msg_t *ipmi_msg_alloc(sys_data_t *sys, unsigned int datalen);
void ipmi_msg_free(sys_data_t *sys, msg_t *msg);
msg_t *ipmi_msg_dup(sys_data_t *sys, msg_t *omsg,
		    unsigned int extra_size, unsigned int data_offset);

struct msg_q;

struct msg_q_link {
    msg_t *next;
    msg_t *prev;
};

typedef void (*msg_q_op)(struct msg_q *q);

struct msg_q {
    msg_t *head;
    msg_t *tail;
    msg_q_op add_to_empty;
    msg_q_op now_empty;
    void *cb_data;
};

int init_msg_q(struct msg_q *q, msg_q_op add_to_empty, msg_q_op now_empty,
	       void *cb_data);
void add_to_msg_q(struct msg_q *q, msg_t *msg);
msg_t *get_next_msg_q(struct msg_q *q);
#define msg_q_empty(q) ((q)->head == NULL)
#define msg_q_first(q) ((q)->head)

#endif /* __MSG_H_ */
