/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opensearch.protobufs.ObjectMap;

public class ObjectMapProtoUtils {
    private ObjectMapProtoUtils() {
    }

    public static Map<String, Object> fromProto(ObjectMap objectMap) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry entry : objectMap.getFieldsMap().entrySet()) {
            map.put((String)entry.getKey(), ObjectMapProtoUtils.fromProto((ObjectMap.Value)entry.getValue()));
        }
        return map;
    }

    public static Object fromProto(ObjectMap.Value value) {
        if (value.hasNullValue()) {
            throw new UnsupportedOperationException("Cannot add null value in ObjectMap.value " + value.toString() + " to a Java map.");
        }
        if (value.hasDouble()) {
            return value.getDouble();
        }
        if (value.hasFloat()) {
            return Float.valueOf(value.getFloat());
        }
        if (value.hasInt32()) {
            return value.getInt32();
        }
        if (value.hasInt64()) {
            return value.getInt64();
        }
        if (value.hasString()) {
            return value.getString();
        }
        if (value.hasBool()) {
            return value.getBool();
        }
        if (value.hasListValue()) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (ObjectMap.Value listEntry : value.getListValue().getValueList()) {
                list.add(ObjectMapProtoUtils.fromProto(listEntry));
            }
            return list;
        }
        if (value.hasObjectMap()) {
            return ObjectMapProtoUtils.fromProto(value.getObjectMap());
        }
        throw new IllegalArgumentException("Cannot convert " + value.toString() + " to protobuf Object.Value");
    }
}

