/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.coordination;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.opensearch.cluster.coordination.Join;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.transport.TransportRequest;

public class JoinRequest
extends TransportRequest {
    private final DiscoveryNode sourceNode;
    private final long minimumTerm;
    private final Optional<Join> optionalJoin;

    public JoinRequest(DiscoveryNode sourceNode, long minimumTerm, Optional<Join> optionalJoin) {
        assert (!optionalJoin.isPresent() || optionalJoin.get().getSourceNode().equals(sourceNode));
        this.sourceNode = sourceNode;
        this.minimumTerm = minimumTerm;
        this.optionalJoin = optionalJoin;
    }

    public JoinRequest(StreamInput in) throws IOException {
        super(in);
        this.sourceNode = new DiscoveryNode(in);
        this.minimumTerm = in.readLong();
        this.optionalJoin = Optional.ofNullable((Join)in.readOptionalWriteable(Join::new));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.sourceNode.writeToWithAttribute(out);
        out.writeLong(this.minimumTerm);
        out.writeOptionalWriteable((Writeable)this.optionalJoin.orElse(null));
    }

    public DiscoveryNode getSourceNode() {
        return this.sourceNode;
    }

    public long getMinimumTerm() {
        return this.minimumTerm;
    }

    public long getTerm() {
        return Math.max(this.minimumTerm, this.optionalJoin.map(Join::getTerm).orElse(0L));
    }

    public Optional<Join> getOptionalJoin() {
        return this.optionalJoin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JoinRequest)) {
            return false;
        }
        JoinRequest that = (JoinRequest)o;
        if (this.minimumTerm != that.minimumTerm) {
            return false;
        }
        if (!this.sourceNode.equals(that.sourceNode)) {
            return false;
        }
        return this.optionalJoin.equals(that.optionalJoin);
    }

    public int hashCode() {
        return Objects.hash(this.sourceNode, this.minimumTerm, this.optionalJoin);
    }

    public String toString() {
        return "JoinRequest{sourceNode=" + String.valueOf(this.sourceNode) + ", minimumTerm=" + this.minimumTerm + ", optionalJoin=" + String.valueOf(this.optionalJoin) + "}";
    }
}

