/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.model;

import com.google.common.base.Objects;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.opensearch.ad.constant.ADCommonMessages;
import org.opensearch.ad.model.Action;
import org.opensearch.ad.model.AnomalyDetectorType;
import org.opensearch.ad.model.Condition;
import org.opensearch.ad.model.Operator;
import org.opensearch.ad.model.Rule;
import org.opensearch.ad.model.ThresholdType;
import org.opensearch.ad.settings.ADNumericSetting;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParseException;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.timeseries.annotation.Generated;
import org.opensearch.timeseries.common.exception.ValidationException;
import org.opensearch.timeseries.constant.CommonMessages;
import org.opensearch.timeseries.constant.CommonValue;
import org.opensearch.timeseries.dataprocessor.ImputationOption;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.DateRange;
import org.opensearch.timeseries.model.Feature;
import org.opensearch.timeseries.model.IntervalTimeConfiguration;
import org.opensearch.timeseries.model.ShingleGetter;
import org.opensearch.timeseries.model.TimeConfiguration;
import org.opensearch.timeseries.model.ValidationAspect;
import org.opensearch.timeseries.model.ValidationIssueType;
import org.opensearch.timeseries.util.ParseUtils;

public class AnomalyDetector
extends Config {
    public static final String PARSE_FIELD_NAME = "AnomalyDetector";
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(AnomalyDetector.class, new ParseField("AnomalyDetector", new String[0]), it -> AnomalyDetector.parse(it));
    public static final String TYPE = "_doc";
    public static final String DETECTION_INTERVAL_FIELD = "detection_interval";
    public static final String DETECTOR_TYPE_FIELD = "detector_type";
    @Deprecated
    public static final String DETECTION_DATE_RANGE_FIELD = "detection_date_range";
    public static final String RULES_FIELD = "rules";
    private static final String SUPPRESSION_RULE_ISSUE_PREFIX = "Suppression Rule Error: ";
    protected String detectorType;
    @Deprecated
    private DateRange detectionDateRange;
    public static String INVALID_RESULT_INDEX_NAME_SIZE = "Result index name size must contains less than 255 characters";
    private List<Rule> rules;

    public AnomalyDetector(String detectorId, Long version, String name, String description, String timeField, List<String> indices, List<Feature> features, QueryBuilder filterQuery, TimeConfiguration detectionInterval, TimeConfiguration windowDelay, Integer shingleSize, Map<String, Object> uiMetadata, Integer schemaVersion, Instant lastUpdateTime, List<String> categoryFields, User user, String resultIndex, ImputationOption imputationOption, Integer recencyEmphasis, Integer seasonIntervals, Integer historyIntervals, List<Rule> rules, Integer customResultIndexMinSize, Integer customResultIndexMinAge, Integer customResultIndexTTL, Boolean flattenResultIndexMapping, Instant lastBreakingUIChangeTime) {
        super(detectorId, version, name, description, timeField, indices, features, filterQuery, windowDelay, shingleSize, uiMetadata, schemaVersion, lastUpdateTime, categoryFields, user, resultIndex, detectionInterval, imputationOption, recencyEmphasis, seasonIntervals, new ADShingleGetter(seasonIntervals), historyIntervals, customResultIndexMinSize, customResultIndexMinAge, customResultIndexTTL, flattenResultIndexMapping, lastBreakingUIChangeTime);
        this.checkAndThrowValidationErrors(ValidationAspect.DETECTOR);
        if (detectionInterval == null) {
            this.errorMessage = ADCommonMessages.NULL_DETECTION_INTERVAL;
            this.issueType = ValidationIssueType.DETECTION_INTERVAL;
        } else if (((IntervalTimeConfiguration)detectionInterval).getInterval() <= 0L) {
            this.errorMessage = ADCommonMessages.INVALID_DETECTION_INTERVAL;
            this.issueType = ValidationIssueType.DETECTION_INTERVAL;
        }
        int maxCategoryFields = ADNumericSetting.maxCategoricalFields();
        if (categoryFields != null && categoryFields.size() > maxCategoryFields) {
            this.errorMessage = CommonMessages.getTooManyCategoricalFieldErr(maxCategoryFields);
            this.issueType = ValidationIssueType.CATEGORY;
        }
        this.validateRules(features, rules);
        this.checkAndThrowValidationErrors(ValidationAspect.DETECTOR);
        this.detectorType = AnomalyDetector.isHC(categoryFields) ? AnomalyDetectorType.MULTI_ENTITY.name() : AnomalyDetectorType.SINGLE_ENTITY.name();
        this.rules = rules == null || rules.isEmpty() ? this.getDefaultRule() : rules;
    }

    public AnomalyDetector(StreamInput input) throws IOException {
        this.id = input.readOptionalString();
        this.version = input.readOptionalLong();
        this.name = input.readString();
        this.description = input.readOptionalString();
        this.timeField = input.readString();
        this.indices = input.readStringList();
        this.featureAttributes = input.readList(Feature::new);
        this.filterQuery = (QueryBuilder)input.readNamedWriteable(QueryBuilder.class);
        this.interval = IntervalTimeConfiguration.readFrom(input);
        this.windowDelay = IntervalTimeConfiguration.readFrom(input);
        this.shingleSize = input.readInt();
        this.schemaVersion = input.readInt();
        this.categoryFields = input.readOptionalStringList();
        this.lastUpdateTime = input.readInstant();
        this.user = input.readBoolean() ? new User(input) : null;
        this.detectionDateRange = input.readBoolean() ? new DateRange(input) : null;
        this.detectorType = input.readOptionalString();
        this.uiMetadata = input.readBoolean() ? input.readMap() : null;
        this.customResultIndexOrAlias = input.readOptionalString();
        this.imputationOption = input.readBoolean() ? new ImputationOption(input) : null;
        this.recencyEmphasis = input.readOptionalInt();
        this.seasonIntervals = input.readOptionalInt();
        this.historyIntervals = input.readOptionalInt();
        if (input.readBoolean()) {
            this.rules = input.readList(Rule::new);
        }
        this.customResultIndexMinSize = input.readOptionalInt();
        this.customResultIndexMinAge = input.readOptionalInt();
        this.customResultIndexTTL = input.readOptionalInt();
        this.flattenResultIndexMapping = input.readOptionalBoolean();
        this.lastUIBreakingChangeTime = input.readOptionalInstant();
    }

    public XContentBuilder toXContent(XContentBuilder builder) throws IOException {
        return this.toXContent(builder, ToXContent.EMPTY_PARAMS);
    }

    @Override
    public void writeTo(StreamOutput output) throws IOException {
        output.writeOptionalString(this.id);
        output.writeOptionalLong(this.version);
        output.writeString(this.name);
        output.writeOptionalString(this.description);
        output.writeString(this.timeField);
        output.writeStringCollection((Collection)this.indices);
        output.writeList(this.featureAttributes);
        output.writeNamedWriteable((NamedWriteable)this.filterQuery);
        this.interval.writeTo(output);
        this.windowDelay.writeTo(output);
        output.writeInt(this.shingleSize.intValue());
        output.writeInt(this.schemaVersion.intValue());
        output.writeOptionalStringCollection((Collection)this.categoryFields);
        output.writeInstant(this.lastUpdateTime);
        if (this.user != null) {
            output.writeBoolean(true);
            this.user.writeTo(output);
        } else {
            output.writeBoolean(false);
        }
        if (this.detectionDateRange != null) {
            output.writeBoolean(true);
            this.detectionDateRange.writeTo(output);
        } else {
            output.writeBoolean(false);
        }
        output.writeOptionalString(this.detectorType);
        if (this.uiMetadata != null) {
            output.writeBoolean(true);
            output.writeMap(this.uiMetadata);
        } else {
            output.writeBoolean(false);
        }
        output.writeOptionalString(this.customResultIndexOrAlias);
        if (this.imputationOption != null) {
            output.writeBoolean(true);
            this.imputationOption.writeTo(output);
        } else {
            output.writeBoolean(false);
        }
        output.writeOptionalInt(this.recencyEmphasis);
        output.writeOptionalInt(this.seasonIntervals);
        output.writeOptionalInt(this.historyIntervals);
        if (this.rules != null) {
            output.writeBoolean(true);
            output.writeList(this.rules);
        } else {
            output.writeBoolean(false);
        }
        output.writeOptionalInt(this.customResultIndexMinSize);
        output.writeOptionalInt(this.customResultIndexMinAge);
        output.writeOptionalInt(this.customResultIndexTTL);
        output.writeOptionalBoolean(this.flattenResultIndexMapping);
        output.writeOptionalInstant(this.lastUIBreakingChangeTime);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        xContentBuilder = super.toXContent(xContentBuilder, params);
        xContentBuilder.field(DETECTION_INTERVAL_FIELD, (ToXContent)this.interval);
        if (this.detectorType != null) {
            xContentBuilder.field(DETECTOR_TYPE_FIELD, this.detectorType);
        }
        if (this.detectionDateRange != null) {
            xContentBuilder.field(DETECTION_DATE_RANGE_FIELD, (ToXContent)this.detectionDateRange);
        }
        if (this.rules != null) {
            xContentBuilder.field(RULES_FIELD, (Object)this.rules.toArray());
        }
        return xContentBuilder.endObject();
    }

    public static AnomalyDetector parse(XContentParser parser) throws IOException {
        return AnomalyDetector.parse(parser, null);
    }

    public static AnomalyDetector parse(XContentParser parser, String detectorId) throws IOException {
        return AnomalyDetector.parse(parser, detectorId, null);
    }

    public static AnomalyDetector parse(XContentParser parser, String detectorId, Long version) throws IOException {
        return AnomalyDetector.parse(parser, detectorId, version, null, null);
    }

    public static AnomalyDetector parse(XContentParser parser, String detectorId, Long version, TimeValue defaultDetectionInterval, TimeValue defaultDetectionWindowDelay) throws IOException {
        String name = null;
        String description = "";
        String timeField = null;
        ArrayList<String> indices = new ArrayList<String>();
        MatchAllQueryBuilder filterQuery = QueryBuilders.matchAllQuery();
        TimeConfiguration detectionInterval = defaultDetectionInterval == null ? null : new IntervalTimeConfiguration(defaultDetectionInterval.getMinutes(), ChronoUnit.MINUTES);
        TimeConfiguration windowDelay = defaultDetectionWindowDelay == null ? null : new IntervalTimeConfiguration(defaultDetectionWindowDelay.getSeconds(), ChronoUnit.SECONDS);
        Integer shingleSize = null;
        ArrayList<Feature> features = new ArrayList<Feature>();
        Integer schemaVersion = CommonValue.NO_SCHEMA_VERSION;
        Map uiMetadata = null;
        Instant lastUpdateTime = null;
        User user = null;
        DateRange detectionDateRange = null;
        String resultIndex = null;
        List categoryField = null;
        ImputationOption imputationOption = null;
        Integer recencyEmphasis = null;
        Integer seasonality = null;
        Integer historyIntervals = null;
        ArrayList<Rule> rules = new ArrayList<Rule>();
        Integer customResultIndexMinSize = null;
        Integer customResultIndexMinAge = null;
        Integer customResultIndexTTL = null;
        Boolean flattenResultIndexMapping = null;
        Instant lastBreakingUIChangeTime = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block65: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    break;
                }
                case "description": {
                    description = parser.text();
                    break;
                }
                case "time_field": {
                    timeField = parser.text();
                    break;
                }
                case "indices": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        indices.add(parser.text());
                    }
                    continue block65;
                }
                case "ui_metadata": {
                    uiMetadata = parser.map();
                    break;
                }
                case "schema_version": {
                    schemaVersion = parser.intValue();
                    break;
                }
                case "filter_query": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    try {
                        filterQuery = AbstractQueryBuilder.parseInnerQueryBuilder((XContentParser)parser);
                        break;
                    }
                    catch (ParsingException | XContentParseException e) {
                        throw new ValidationException("Custom query error in data filter: " + e.getMessage(), ValidationIssueType.FILTER_QUERY, ValidationAspect.DETECTOR);
                    }
                    catch (IllegalArgumentException e) {
                        if (e.getMessage().contains("empty clause")) continue block65;
                        throw e;
                    }
                }
                case "detection_interval": {
                    try {
                        detectionInterval = TimeConfiguration.parse(parser);
                        break;
                    }
                    catch (Exception e) {
                        if (e instanceof IllegalArgumentException && e.getMessage().contains(CommonMessages.NEGATIVE_TIME_CONFIGURATION)) {
                            throw new ValidationException("Detection interval must be a positive integer", ValidationIssueType.DETECTION_INTERVAL, ValidationAspect.DETECTOR);
                        }
                        throw e;
                    }
                }
                case "feature_attributes": {
                    try {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            features.add(Feature.parse(parser));
                        }
                        continue block65;
                    }
                    catch (Exception e) {
                        if (e instanceof ParsingException || e instanceof XContentParseException) {
                            throw new ValidationException("Custom query error: " + e.getMessage(), ValidationIssueType.FEATURE_ATTRIBUTES, ValidationAspect.DETECTOR);
                        }
                        throw e;
                    }
                }
                case "window_delay": {
                    try {
                        windowDelay = TimeConfiguration.parse(parser);
                        break;
                    }
                    catch (Exception e) {
                        if (e instanceof IllegalArgumentException && e.getMessage().contains(CommonMessages.NEGATIVE_TIME_CONFIGURATION)) {
                            throw new ValidationException("Window delay interval must be a positive integer", ValidationIssueType.WINDOW_DELAY, ValidationAspect.DETECTOR);
                        }
                        throw e;
                    }
                }
                case "shingle_size": {
                    shingleSize = parser.intValue();
                    break;
                }
                case "last_update_time": {
                    lastUpdateTime = ParseUtils.toInstant(parser);
                    break;
                }
                case "category_field": {
                    categoryField = parser.list();
                    break;
                }
                case "user": {
                    user = User.parse((XContentParser)parser);
                    break;
                }
                case "detection_date_range": {
                    detectionDateRange = DateRange.parse(parser);
                    break;
                }
                case "result_index": {
                    resultIndex = parser.text();
                    break;
                }
                case "imputation_option": {
                    imputationOption = ImputationOption.parse(parser);
                    break;
                }
                case "recency_emphasis": {
                    recencyEmphasis = parser.intValue();
                    break;
                }
                case "suggested_seasonality": {
                    seasonality = parser.currentToken() == XContentParser.Token.VALUE_NULL ? null : Integer.valueOf(parser.intValue());
                    break;
                }
                case "history": {
                    historyIntervals = parser.intValue();
                    break;
                }
                case "rules": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        rules.add(Rule.parse(parser));
                    }
                    continue block65;
                }
                case "result_index_min_size": {
                    customResultIndexMinSize = AnomalyDetector.onlyParseNumberValue(parser);
                    break;
                }
                case "result_index_min_age": {
                    customResultIndexMinAge = AnomalyDetector.onlyParseNumberValue(parser);
                    break;
                }
                case "result_index_ttl": {
                    customResultIndexTTL = AnomalyDetector.onlyParseNumberValue(parser);
                    break;
                }
                case "flatten_custom_result_index": {
                    flattenResultIndexMapping = AnomalyDetector.onlyParseBooleanValue(parser);
                    break;
                }
                case "last_ui_breaking_change_time": {
                    lastBreakingUIChangeTime = ParseUtils.toInstant(parser);
                    break;
                }
                default: {
                    parser.skipChildren();
                }
            }
        }
        AnomalyDetector detector = new AnomalyDetector(detectorId, version, name, description, timeField, indices, features, (QueryBuilder)filterQuery, detectionInterval, windowDelay, shingleSize, uiMetadata, schemaVersion, lastUpdateTime, categoryField, user, resultIndex, imputationOption, recencyEmphasis, seasonality, historyIntervals, rules, customResultIndexMinSize, customResultIndexMinAge, customResultIndexTTL, flattenResultIndexMapping, lastBreakingUIChangeTime);
        detector.setDetectionDateRange(detectionDateRange);
        return detector;
    }

    public String getDetectorType() {
        return this.detectorType;
    }

    public void setDetectionDateRange(DateRange detectionDateRange) {
        this.detectionDateRange = detectionDateRange;
    }

    public DateRange getDetectionDateRange() {
        return this.detectionDateRange;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    @Override
    protected ValidationAspect getConfigValidationAspect() {
        return ValidationAspect.DETECTOR;
    }

    @Override
    public String validateCustomResultIndex(String resultIndex) {
        if (resultIndex != null && !resultIndex.startsWith("opensearch-ad-plugin-result-")) {
            return ADCommonMessages.INVALID_RESULT_INDEX_PREFIX;
        }
        return super.validateCustomResultIndex(resultIndex);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnomalyDetector detector = (AnomalyDetector)o;
        return super.equals(o) && Objects.equal(this.rules, detector.rules);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode((Object[])new Object[]{this.rules});
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return super.toString() + ", " + new ToStringBuilder((Object)this).append(RULES_FIELD, this.rules).toString();
    }

    private List<Rule> getDefaultRule() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (Feature feature : this.featureAttributes) {
            if (!feature.getEnabled().booleanValue()) continue;
            rules.add(new Rule(Action.IGNORE_ANOMALY, Arrays.asList(new Condition(feature.getName(), ThresholdType.ACTUAL_OVER_EXPECTED_RATIO, Operator.LTE, 0.2), new Condition(feature.getName(), ThresholdType.EXPECTED_OVER_ACTUAL_RATIO, Operator.LTE, 0.2))));
        }
        return rules;
    }

    private void validateRules(List<Feature> features, List<Rule> rules) {
        if (rules == null || rules.isEmpty()) {
            return;
        }
        if (features == null || features.isEmpty()) {
            this.errorMessage = "Suppression Rule Error: Features are not defined while suppression rules are provided.";
            this.issueType = ValidationIssueType.RULE;
            return;
        }
        HashMap<String, Boolean> featureEnabledMap = new HashMap<String, Boolean>();
        for (Feature feature : features) {
            if (feature == null || feature.getName() == null) continue;
            featureEnabledMap.put(feature.getName(), feature.getEnabled());
        }
        for (Rule rule : rules) {
            if (rule == null || rule.getConditions() == null) {
                this.errorMessage = "Suppression Rule Error: A suppression rule or its conditions are not properly defined.";
                this.issueType = ValidationIssueType.RULE;
                return;
            }
            for (Condition condition : rule.getConditions()) {
                if (condition == null) {
                    this.errorMessage = "Suppression Rule Error: A condition within a suppression rule is not properly defined.";
                    this.issueType = ValidationIssueType.RULE;
                    return;
                }
                String featureName = condition.getFeatureName();
                if (featureName == null) {
                    this.errorMessage = "Suppression Rule Error: A condition is missing the feature name.";
                    this.issueType = ValidationIssueType.RULE;
                    return;
                }
                if (!featureEnabledMap.containsKey(featureName)) {
                    this.errorMessage = "Suppression Rule Error: Feature \"" + featureName + "\" specified in a suppression rule does not exist.";
                    this.issueType = ValidationIssueType.RULE;
                    return;
                }
                if (!((Boolean)featureEnabledMap.get(featureName)).booleanValue()) {
                    this.errorMessage = "Suppression Rule Error: Feature \"" + featureName + "\" specified in a suppression rule is not enabled.";
                    this.issueType = ValidationIssueType.RULE;
                    return;
                }
                ThresholdType thresholdType = condition.getThresholdType();
                if (thresholdType == ThresholdType.ACTUAL_OVER_EXPECTED_MARGIN || thresholdType == ThresholdType.EXPECTED_OVER_ACTUAL_MARGIN || thresholdType == ThresholdType.ACTUAL_OVER_EXPECTED_RATIO || thresholdType == ThresholdType.EXPECTED_OVER_ACTUAL_RATIO) {
                    double value = condition.getValue();
                    if (Double.isNaN(value)) {
                        this.errorMessage = "Suppression Rule Error: The threshold value for feature \"" + featureName + "\" is not a valid number.";
                        this.issueType = ValidationIssueType.RULE;
                        return;
                    }
                    if (!(value <= 0.0)) continue;
                    this.errorMessage = "Suppression Rule Error: The threshold value for feature \"" + featureName + "\" must be a positive number.";
                    this.issueType = ValidationIssueType.RULE;
                    return;
                }
                if (thresholdType != ThresholdType.ACTUAL_IS_BELOW_EXPECTED && thresholdType != ThresholdType.ACTUAL_IS_OVER_EXPECTED || condition.getOperator() == null && condition.getValue() == null) continue;
                this.errorMessage = "Suppression Rule Error: For threshold type \"" + String.valueOf((Object)thresholdType) + "\", both operator and value must be empty or null, as this rule compares actual to expected values directly";
                this.issueType = ValidationIssueType.RULE;
                return;
            }
        }
    }

    static class ADShingleGetter
    implements ShingleGetter {
        private Integer seasonIntervals;

        public ADShingleGetter(Integer seasonIntervals) {
            this.seasonIntervals = seasonIntervals;
        }

        @Override
        public Integer getShingleSize(Integer customShingleSize) {
            if (customShingleSize != null) {
                return customShingleSize;
            }
            if (this.seasonIntervals != null) {
                return this.seasonIntervals / 2;
            }
            return 8;
        }
    }
}

