"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiStepsHorizontal = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _classnames = _interopRequireDefault(require("classnames"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _step_horizontal = require("./step_horizontal");
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

var EuiStepsHorizontal = function EuiStepsHorizontal(_ref) {
  var className = _ref.className,
    steps = _ref.steps,
    rest = (0, _objectWithoutProperties2.default)(_ref, ["className", "steps"]);
  var classes = (0, _classnames.default)('euiStepsHorizontal', className);
  return /*#__PURE__*/_react.default.createElement("ol", (0, _extends2.default)({
    className: classes
  }, rest), steps.map(function (stepProps, index) {
    var isCurrent = stepProps.isSelected ? {
      'aria-current': 'step'
    } : {};
    return /*#__PURE__*/_react.default.createElement("li", (0, _extends2.default)({
      key: index,
      className: "euiStepHorizontal__item"
    }, isCurrent), /*#__PURE__*/_react.default.createElement(_step_horizontal.EuiStepHorizontal, (0, _extends2.default)({
      step: index + 1
    }, stepProps)));
  }));
};
exports.EuiStepsHorizontal = EuiStepsHorizontal;
EuiStepsHorizontal.propTypes = {
  /**
     * An array of `EuiStepHorizontal` objects excluding the `step` prop
     */
  steps: _propTypes.default.arrayOf(_propTypes.default.any.isRequired).isRequired,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};