/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.sequence.example;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import org.tribuo.Feature;
import org.tribuo.Output;
import org.tribuo.OutputFactory;
import org.tribuo.classification.Label;
import org.tribuo.classification.LabelFactory;
import org.tribuo.impl.ListExample;
import org.tribuo.provenance.DataProvenance;
import org.tribuo.provenance.SimpleDataSourceProvenance;
import org.tribuo.sequence.MutableSequenceDataset;
import org.tribuo.sequence.SequenceExample;

public final class SequenceDataGenerator {
    private static final LabelFactory labelFactory = new LabelFactory();

    private SequenceDataGenerator() {
    }

    public static MutableSequenceDataset<Label> generateGorillaDataset(int numCopies) {
        ArrayList<SequenceExample<Label>> examples = new ArrayList<SequenceExample<Label>>();
        for (int i = 0; i < numCopies; ++i) {
            examples.add(SequenceDataGenerator.generateGorillaA());
            examples.add(SequenceDataGenerator.generateGorillaB());
        }
        return new MutableSequenceDataset(examples, (DataProvenance)new SimpleDataSourceProvenance("ExampleSequenceDataset", OffsetDateTime.now(), (OutputFactory)labelFactory), (OutputFactory)labelFactory);
    }

    public static SequenceExample<Label> generateGorillaA() {
        ArrayList<ListExample> examples = new ArrayList<ListExample>();
        ListExample the = new ListExample((Output)new Label("O"));
        the.add(new Feature("A", 1.0));
        the.add(new Feature("B", 1.0));
        the.add(new Feature("W=the", 1.0));
        examples.add(the);
        ListExample silverback = new ListExample((Output)new Label("Monkey"));
        silverback.add(new Feature("C", 1.0));
        silverback.add(new Feature("D", 1.0));
        silverback.add(new Feature("W=silverback", 1.0));
        examples.add(silverback);
        ListExample gorilla = new ListExample((Output)new Label("Monkey"));
        gorilla.add(new Feature("D", 1.0));
        gorilla.add(new Feature("E", 1.0));
        gorilla.add(new Feature("W=gorilla", 1.0));
        examples.add(gorilla);
        ListExample is = new ListExample((Output)new Label("O"));
        is.add(new Feature("B", 1.0));
        is.add(new Feature("W=is", 1.0));
        examples.add(is);
        ListExample angry = new ListExample((Output)new Label("Status"));
        angry.add(new Feature("F", 1.0));
        angry.add(new Feature("G", 1.0));
        angry.add(new Feature("W=angry", 1.0));
        examples.add(angry);
        return new SequenceExample(examples);
    }

    public static SequenceExample<Label> generateGorillaB() {
        ArrayList<ListExample> examples = new ArrayList<ListExample>();
        ListExample that = new ListExample((Output)new Label("O"));
        that.add(new Feature("A", 1.0));
        that.add(new Feature("B", 1.0));
        that.add(new Feature("W=that", 1.0));
        examples.add(that);
        ListExample is = new ListExample((Output)new Label("O"));
        is.add(new Feature("B", 1.0));
        is.add(new Feature("W=is", 1.0));
        examples.add(is);
        ListExample one = new ListExample((Output)new Label("O"));
        one.add(new Feature("B", 1.0));
        one.add(new Feature("H", 1.0));
        one.add(new Feature("W=one", 1.0));
        examples.add(one);
        ListExample angry = new ListExample((Output)new Label("Status"));
        angry.add(new Feature("F", 1.0));
        angry.add(new Feature("G", 1.0));
        angry.add(new Feature("W=angry", 1.0));
        examples.add(angry);
        ListExample looking = new ListExample((Output)new Label("O"));
        looking.add(new Feature("I", 1.0));
        looking.add(new Feature("J", 1.0));
        looking.add(new Feature("W=looking", 1.0));
        examples.add(looking);
        ListExample gorilla = new ListExample((Output)new Label("Monkey"));
        gorilla.add(new Feature("D", 1.0));
        gorilla.add(new Feature("E", 1.0));
        gorilla.add(new Feature("W=gorilla", 1.0));
        examples.add(gorilla);
        return new SequenceExample(examples);
    }

    public static SequenceExample<Label> generateInvalidExample() {
        ArrayList<ListExample> examples = new ArrayList<ListExample>();
        ListExample invalid = new ListExample((Output)new Label("O"));
        invalid.add(new Feature("1", 1.0));
        invalid.add(new Feature("2", 1.0));
        invalid.add(new Feature("W=invalid", 1.0));
        examples.add(invalid);
        ListExample example = new ListExample((Output)new Label("O"));
        example.add(new Feature("3", 1.0));
        example.add(new Feature("2", 1.0));
        example.add(new Feature("W=example", 1.0));
        examples.add(example);
        return new SequenceExample(examples);
    }

    public static SequenceExample<Label> generateOtherInvalidExample() {
        ArrayList<ListExample> examples = new ArrayList<ListExample>();
        ListExample invalid = new ListExample((Output)new Label("O"));
        examples.add(invalid);
        ListExample example = new ListExample((Output)new Label("O"));
        example.add(new Feature("3", 1.0));
        example.add(new Feature("2", 1.0));
        example.add(new Feature("W=example", 1.0));
        examples.add(example);
        return new SequenceExample(examples);
    }

    public static SequenceExample<Label> generateEmptyExample() {
        ArrayList examples = new ArrayList();
        return new SequenceExample(examples);
    }
}

