/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.columnar.extractors;

import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.util.Optional;
import java.util.logging.Logger;
import org.tribuo.data.columnar.extractors.SimpleFieldExtractor;

public class IntExtractor
extends SimpleFieldExtractor<Integer> {
    private static final Logger logger = Logger.getLogger(IntExtractor.class.getName());

    public IntExtractor(String fieldName) {
        super(fieldName);
    }

    public IntExtractor(String fieldName, String metadataName) {
        super(fieldName, metadataName);
    }

    private IntExtractor() {
    }

    @Override
    public Class<Integer> getValueType() {
        return Integer.class;
    }

    @Override
    protected Optional<Integer> extractField(String value) {
        try {
            int f = Integer.parseInt(value);
            return Optional.of(f);
        }
        catch (NumberFormatException e) {
            logger.warning("Failed to parse value for field " + this.fieldName + ", expected a int, got " + value);
            return Optional.empty();
        }
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "FieldExtractor");
    }
}

