/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.agent.MLAgentGetAction;
import org.opensearch.ml.common.transport.agent.MLAgentGetRequest;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestMLGetAgentAction
extends BaseRestHandler {
    private static final String ML_GET_Agent_ACTION = "ml_get_agent_action";
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLGetAgentAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_GET_Agent_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/agents/{%s}", "/_plugins/_ml", "agent_id")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLAgentGetRequest mlAgentGetRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLAgentGetAction.INSTANCE, (ActionRequest)mlAgentGetRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    MLAgentGetRequest getRequest(RestRequest request) throws IOException {
        if (!this.mlFeatureEnabledSetting.isAgentFrameworkEnabled()) {
            throw new IllegalStateException("Agent Framework is currently disabled. To enable it, update the setting \"plugins.ml_commons.agent_framework_enabled\" to true.");
        }
        String agentId = RestActionUtils.getParameterId(request, "agent_id");
        String tenantId = TenantAwareHelper.getTenantID(this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), request);
        return new MLAgentGetRequest(agentId, true, tenantId);
    }
}

