/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGridAppearance;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridFilterAndSortingComponent;
import com.intellij.database.datagrid.GridPanel;
import com.intellij.database.datagrid.GridPresentationMode;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.HierarchicalColumnsCollapseManager;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.ResultView;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.datagrid.color.GridColorModel;
import com.intellij.database.extractors.BinaryDisplayType;
import com.intellij.database.extractors.DatabaseObjectFormatterConfig;
import com.intellij.database.extractors.DisplayType;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.run.ui.HiddenColumnsSelectionHolder;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.run.ui.grid.GridColorsScheme;
import com.intellij.database.run.ui.grid.GridMarkupModel;
import com.intellij.database.run.ui.grid.GridRowHeader;
import com.intellij.database.run.ui.table.LocalFilterState;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.find.SearchSession;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.JBAutoScroller;
import com.intellij.util.messages.Topic;
import java.awt.Color;
import java.awt.event.MouseListener;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DataGrid
extends CoreGrid<GridRow, GridColumn> {
    @Topic.AppLevel
    public static final Topic<ActiveGridListener> ACTIVE_GRID_CHANGED_TOPIC = new Topic(ActiveGridListener.class, Topic.BroadcastDirection.NONE);

    @Nullable
    default public String getUniqueId() {
        return null;
    }

    public boolean isEmpty();

    public void runWithIgnoreSelectionChanges(Runnable var1);

    public boolean isSafeToReload();

    public ActionCallback submit();

    public boolean isFilteringSupported();

    public boolean isFilteringComponentShown();

    public void toggleFilteringComponent();

    public boolean isSafeToUpdate(@NotNull ModelIndexSet<GridRow> var1, @NotNull ModelIndexSet<GridColumn> var2, @Nullable Object var3);

    @NotNull
    public GridFilterAndSortingComponent getFilterComponent();

    public void resetFilters();

    public boolean isSortViaOrderBySupported();

    public boolean isSortViaOrderBy();

    public void setSortViaOrderBy(boolean var1);

    @NotNull
    public RowSortOrder.Type getSortOrder(@NotNull ModelIndex<GridColumn> var1);

    public int getThenBySortOrder(@NotNull ModelIndex<GridColumn> var1);

    public int getVisibleColumnCount();

    public void toggleSortColumns(@NotNull List<ModelIndex<GridColumn>> var1, boolean var2);

    public void sortColumns(@NotNull List<ModelIndex<GridColumn>> var1, @NotNull RowSortOrder.Type var2, boolean var3);

    public TableResultPanel.ColumnAttributes getColumnAttributes();

    @NotNull
    public Language getContentLanguage(@NotNull ModelIndex<GridColumn> var1);

    public boolean isRowFilteredOut(@NotNull ModelIndex<?> var1);

    public void setContentLanguage(@NotNull ModelIndex<GridColumn> var1, @NotNull Language var2);

    public void setDisplayType(@NotNull ModelIndex<GridColumn> var1, @NotNull DisplayType var2);

    @NotNull
    public DisplayType getDisplayType(@NotNull ModelIndex<GridColumn> var1);

    @NotNull
    public DisplayType getPureDisplayType(@NotNull ModelIndex<GridColumn> var1);

    @NotNull
    public BinaryDisplayType getOptimalBinaryDisplayTypeForDetect(@NotNull ModelIndex<GridColumn> var1);

    public boolean isDisplayTypeApplicable(@NotNull BinaryDisplayType var1, @NotNull ModelIndex<GridColumn> var2);

    @NotNull
    public ModelIndex<GridColumn> getContextColumn();

    public ObjectFormatter getObjectFormatter();

    public TreeMap<Integer, GridColumn> getSortOrderMap();

    public int countSortedColumns();

    public void setObjectFormatterProvider(@NotNull Function<DataGrid, ObjectFormatter> var1);

    public int getSortOrder(@Nullable GridColumn var1);

    public void addDataGridListener(DataGridListener var1, Disposable var2);

    public void resetLayout();

    public void loadingDelayDisabled();

    @NotNull
    public GridColorModel getColorModel();

    @NotNull
    public JBAutoScroller.AutoscrollLocker getAutoscrollLocker();

    public void loadingDelayed();

    public HiddenColumnsSelectionHolder getHiddenColumnSelectionHolder();

    @NotNull
    public GridRowHeader createRowHeader(@NotNull TableResultView var1);

    public void fireValueEdited(@Nullable Object var1);

    @NotNull
    public ResultView getResultView();

    public void fireContentChanged(@Nullable GridRequestSource.RequestPlace var1);

    public void setValueAt(@NotNull ModelIndexSet<GridRow> var1, @NotNull ModelIndexSet<GridColumn> var2, @Nullable Object var3, boolean var4, @Nullable Runnable var5, @NotNull GridRequestSource var6);

    public boolean isHeaderSelecting();

    public void updateSortKeysFromColumnAttributes();

    public void setPresentationMode(@NotNull GridPresentationMode var1);

    @NotNull
    public GridPresentationMode getPresentationMode();

    @NotNull
    public GridPanel getPanel();

    @NotNull
    public GridMarkupModel<GridRow, GridColumn> getMarkupModel();

    @NotNull
    public GridColorsScheme getColorsScheme();

    @Nullable
    public Color getHoveredRowBackground();

    @Nullable
    public Color getStripeRowBackground();

    @NotNull
    public GridColorsScheme getEditorColorsScheme();

    public void searchSessionStarted(@NotNull SearchSession var1);

    public void searchSessionStopped(@NotNull SearchSession var1);

    @Nullable
    public SearchSession getSearchSession();

    public void trueLayout();

    @Nullable
    public Comparator<?> getComparator(@NotNull ModelIndex<GridColumn> var1);

    @NlsSafe
    @NotNull
    public String getName(@NotNull GridColumn var1);

    @Nullable
    default public HierarchicalColumnsCollapseManager getHierarchicalColumnsCollapseManager() {
        return null;
    }

    public void addResultViewMouseListener(@NotNull MouseListener var1);

    @NotNull
    public DataGridAppearance getAppearance();

    @NotNull
    public LocalFilterState getLocalFilterState();

    public void adaptForNewQuery();

    public ModificationTracker getModificationTracker();

    @Nullable
    public DatabaseObjectFormatterConfig.DatabaseDisplayObjectFormatterConfig getFormatterConfig(@NotNull ModelIndex<GridColumn> var1);

    public static interface ActiveGridListener {
        default public void onFilterApplied(@NotNull DataGrid grid) {
            if (grid == null) {
                ActiveGridListener.$$$reportNull$$$0(0);
            }
        }

        default public void onSortingApplied(@NotNull DataGrid grid) {
            if (grid == null) {
                ActiveGridListener.$$$reportNull$$$0(1);
            }
        }

        default public void onColumnSortingToggled(@NotNull DataGrid grid) {
            if (grid == null) {
                ActiveGridListener.$$$reportNull$$$0(2);
            }
        }

        default public void onValueEditorOpened(@NotNull DataGrid grid) {
            if (grid == null) {
                ActiveGridListener.$$$reportNull$$$0(3);
            }
        }

        default public void onAggregateViewOpened(@NotNull DataGrid grid) {
            if (grid == null) {
                ActiveGridListener.$$$reportNull$$$0(4);
            }
        }

        default public void onRecordViewOpened(@NotNull DataGrid grid) {
            if (grid == null) {
                ActiveGridListener.$$$reportNull$$$0(5);
            }
        }

        default public void onExtractToClipboardAction(@NotNull DataGrid grid) {
            if (grid == null) {
                ActiveGridListener.$$$reportNull$$$0(6);
            }
        }

        default public void onExtractToFileAction(@NotNull DataGrid grid) {
            if (grid == null) {
                ActiveGridListener.$$$reportNull$$$0(7);
            }
        }

        default public void changed(@NotNull DataGrid grid) {
            if (grid == null) {
                ActiveGridListener.$$$reportNull$$$0(8);
            }
        }

        default public void closed() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "grid";
            objectArray2[1] = "com/intellij/database/datagrid/DataGrid$ActiveGridListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onFilterApplied";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onSortingApplied";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onColumnSortingToggled";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onValueEditorOpened";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onAggregateViewOpened";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onRecordViewOpened";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onExtractToClipboardAction";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onExtractToFileAction";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "changed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

