/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;
import org.languagetool.tools.StringTools;

public abstract class AbstractWordCoherencyRule
extends TextLevelRule {
    protected abstract Map<String, Set<String>> getWordMap();

    protected abstract String getMessage(String var1, String var2);

    protected String getShortMessage() {
        return null;
    }

    public AbstractWordCoherencyRule(ResourceBundle messages) throws IOException {
        super.setCategory(Categories.MISC.getCategory(messages));
    }

    @Override
    public RuleMatch[] match(List<AnalyzedSentence> sentences) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        HashMap<String, String> shouldNotAppearWord = new HashMap<String, String>();
        int pos = 0;
        for (AnalyzedSentence sentence : sentences) {
            AnalyzedTokenReadings[] tokens;
            block1: for (AnalyzedTokenReadings tmpToken : tokens = sentence.getTokensWithoutWhitespace()) {
                String token = tmpToken.getToken();
                List<AnalyzedToken> readings = tmpToken.getReadings();
                if (readings.isEmpty()) continue;
                Set baseforms = readings.stream().map(AnalyzedToken::getLemma).collect(Collectors.toSet());
                for (String baseform : baseforms) {
                    if (baseform != null) {
                        token = baseform;
                    }
                    int fromPos = pos + tmpToken.getStartPos();
                    int toPos = pos + tmpToken.getEndPos();
                    if (shouldNotAppearWord.containsKey(token)) {
                        String otherSpelling = (String)shouldNotAppearWord.get(token);
                        String msg = this.getMessage(token, otherSpelling);
                        RuleMatch ruleMatch = new RuleMatch(this, sentence, fromPos, toPos, msg);
                        String marked = sentence.getText().substring(tmpToken.getStartPos(), tmpToken.getEndPos());
                        String replacement = this.createReplacement(marked, token, otherSpelling, tmpToken);
                        if (StringTools.startsWithUppercase(tmpToken.getToken())) {
                            replacement = StringTools.uppercaseFirstChar(replacement);
                        }
                        if (!marked.equalsIgnoreCase(replacement)) {
                            ruleMatch.setSuggestedReplacement(replacement);
                            ruleMatches.add(ruleMatch);
                        }
                        ruleMatch.setShortMessage(this.getShortMessage());
                        continue block1;
                    }
                    if (!this.getWordMap().containsKey(token)) continue;
                    Set<String> shouldNotAppearSet = this.getWordMap().get(token);
                    for (String shouldNotAppear : shouldNotAppearSet) {
                        shouldNotAppearWord.put(shouldNotAppear, token);
                    }
                }
            }
            pos += sentence.getCorrectedTextLength();
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Override
    public int minToCheckParagraph() {
        return -1;
    }

    protected String createReplacement(String marked, String token, String otherSpelling, AnalyzedTokenReadings tmpToken) {
        return marked.replaceFirst("(?i)" + token, otherSpelling);
    }
}

