/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CsvRecordFormat {
    public final String prefix;
    public final String suffix;
    public final String nullText;
    public final List<Quotes> quotes;
    public final QuotationPolicy quotationPolicy;
    public final String valueSeparator;
    public final String recordSeparator;
    public final boolean trimWhitespace;

    public CsvRecordFormat(@NotNull String prefix, @NotNull String suffix, @Nullable String nullText, @NotNull List<Quotes> quotes, @NotNull QuotationPolicy quotationPolicy, @NotNull String valueSeparator, @NotNull String recordSeparator, boolean trimWhitespace) {
        if (prefix == null) {
            CsvRecordFormat.$$$reportNull$$$0(0);
        }
        if (suffix == null) {
            CsvRecordFormat.$$$reportNull$$$0(1);
        }
        if (quotes == null) {
            CsvRecordFormat.$$$reportNull$$$0(2);
        }
        if (quotationPolicy == null) {
            CsvRecordFormat.$$$reportNull$$$0(3);
        }
        if (valueSeparator == null) {
            CsvRecordFormat.$$$reportNull$$$0(4);
        }
        if (recordSeparator == null) {
            CsvRecordFormat.$$$reportNull$$$0(5);
        }
        this.prefix = prefix;
        this.suffix = suffix;
        this.nullText = nullText;
        this.quotes = Collections.unmodifiableList(quotes);
        this.quotationPolicy = quotationPolicy;
        this.valueSeparator = valueSeparator;
        this.recordSeparator = recordSeparator;
        this.trimWhitespace = trimWhitespace;
    }

    public CsvRecordFormat withTrimWhitespaces(boolean trimWhitespaces) {
        if (this.trimWhitespace == trimWhitespaces) {
            return this;
        }
        return new CsvRecordFormat(this.prefix, this.suffix, this.nullText, this.quotes, this.quotationPolicy, this.valueSeparator, this.recordSeparator, trimWhitespaces);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CsvRecordFormat)) {
            return false;
        }
        CsvRecordFormat format = (CsvRecordFormat)o;
        if (this.trimWhitespace != format.trimWhitespace) {
            return false;
        }
        if (!this.prefix.equals(format.prefix)) {
            return false;
        }
        if (!this.suffix.equals(format.suffix)) {
            return false;
        }
        if (!Objects.equals(this.nullText, format.nullText)) {
            return false;
        }
        if (!this.quotes.equals(format.quotes)) {
            return false;
        }
        if (this.quotationPolicy != format.quotationPolicy) {
            return false;
        }
        if (!this.valueSeparator.equals(format.valueSeparator)) {
            return false;
        }
        return this.recordSeparator.equals(format.recordSeparator);
    }

    public int hashCode() {
        int result = this.prefix.hashCode();
        result = 31 * result + this.suffix.hashCode();
        result = 31 * result + Objects.hashCode(this.nullText);
        result = 31 * result + this.quotes.hashCode();
        result = 31 * result + this.quotationPolicy.hashCode();
        result = 31 * result + this.valueSeparator.hashCode();
        result = 31 * result + this.recordSeparator.hashCode();
        result = 31 * result + (this.trimWhitespace ? 1 : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "prefix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "suffix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "quotes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "quotationPolicy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "valueSeparator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "recordSeparator";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/csv/CsvRecordFormat";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum QuotationPolicy {
        ALWAYS,
        AS_NEEDED,
        NEVER;

    }

    public static final class Quotes {
        public final String leftQuote;
        public final String rightQuote;
        public final String leftQuoteEscaped;
        public final String rightQuoteEscaped;

        public Quotes(@NotNull String leftQuote, @NotNull String rightQuote, @NotNull String leftQuoteEscaped, @NotNull String rightQuoteEscaped) {
            if (leftQuote == null) {
                Quotes.$$$reportNull$$$0(0);
            }
            if (rightQuote == null) {
                Quotes.$$$reportNull$$$0(1);
            }
            if (leftQuoteEscaped == null) {
                Quotes.$$$reportNull$$$0(2);
            }
            if (rightQuoteEscaped == null) {
                Quotes.$$$reportNull$$$0(3);
            }
            this.leftQuote = leftQuote;
            this.rightQuote = rightQuote;
            this.leftQuoteEscaped = leftQuoteEscaped;
            this.rightQuoteEscaped = rightQuoteEscaped;
        }

        public boolean isQuoted(@NotNull String s) {
            if (s == null) {
                Quotes.$$$reportNull$$$0(4);
            }
            if (this.leftQuote.isEmpty() || this.rightQuote.isEmpty()) {
                return false;
            }
            return s.length() >= this.leftQuote.length() + this.rightQuote.length() && s.startsWith(this.leftQuote) && s.endsWith(this.rightQuote);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Quotes)) {
                return false;
            }
            Quotes quotes = (Quotes)o;
            if (!this.leftQuote.equals(quotes.leftQuote)) {
                return false;
            }
            if (!this.rightQuote.equals(quotes.rightQuote)) {
                return false;
            }
            if (!this.leftQuoteEscaped.equals(quotes.leftQuoteEscaped)) {
                return false;
            }
            return this.rightQuoteEscaped.equals(quotes.rightQuoteEscaped);
        }

        public int hashCode() {
            int result = this.leftQuote.hashCode();
            result = 31 * result + this.rightQuote.hashCode();
            result = 31 * result + this.leftQuoteEscaped.hashCode();
            result = 31 * result + this.rightQuoteEscaped.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leftQuote";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightQuote";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leftQuoteEscaped";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightQuoteEscaped";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/csv/CsvRecordFormat$Quotes";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isQuoted";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

