/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Graphics2D;
import java.util.concurrent.CancellationException;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.Version;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingLayerPropertiesKt;
import org.jetbrains.skiko.swing.SwingRedrawer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H$J\b\u0010\u001a\u001a\u00020\u0012H\u0016J\u000e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0012\u0010\u001c\u001a\u00020\u00122\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0004J\b\u0010\u001f\u001a\u00020\u001eH\u0014J\u0012\u0010 \u001a\u00020\u00122\b\u0010!\u001a\u0004\u0018\u00010\"H\u0004J\u0016\u0010#\u001a\u00020\"*\u00020\"2\b\b\u0002\u0010$\u001a\u00020\u0019H\u0004J\u0017\u0010%\u001a\u00020\u00122\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00120'H\u0082\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/skiko/swing/SwingRedrawerBase;", "Lorg/jetbrains/skiko/swing/SwingRedrawer;", "swingLayerProperties", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "graphicsApi", "Lorg/jetbrains/skiko/GraphicsApi;", "<init>", "(Lorg/jetbrains/skiko/swing/SwingLayerProperties;Lorg/jetbrains/skiko/SkiaLayerAnalytics;Lorg/jetbrains/skiko/GraphicsApi;)V", "isFirstFrameRendered", "", "rendererAnalytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics$RendererAnalytics;", "deviceAnalytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics$DeviceAnalytics;", "isDisposed", "onRender", "", "g", "Ljava/awt/Graphics2D;", "width", "", "height", "nanoTime", "", "dispose", "redraw", "onDeviceChosen", "deviceName", "", "rendererInfo", "onContextInit", "context", "Lorg/jetbrains/skia/DirectContext;", "configureContext", "gpuResourceCacheLimit", "inDrawScope", "body", "Lkotlin/Function0;", "skiko"})
@SourceDebugExtension(value={"SMAP\nSwingRedrawerBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwingRedrawerBase.kt\norg/jetbrains/skiko/swing/SwingRedrawerBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Logging.kt\norg/jetbrains/skiko/Logger\n*L\n1#1,106:1\n90#1:108\n91#1,15:110\n1#2:107\n1#2:109\n133#3,4:125\n*S KotlinDebug\n*F\n+ 1 SwingRedrawerBase.kt\norg/jetbrains/skiko/swing/SwingRedrawerBase\n*L\n47#1:108\n47#1:110,15\n47#1:109\n75#1:125,4\n*E\n"})
public abstract class SwingRedrawerBase
implements SwingRedrawer {
    @NotNull
    private final SwingLayerProperties swingLayerProperties;
    @NotNull
    private final SkiaLayerAnalytics analytics;
    @NotNull
    private final GraphicsApi graphicsApi;
    private boolean isFirstFrameRendered;
    @NotNull
    private final SkiaLayerAnalytics.RendererAnalytics rendererAnalytics;
    @Nullable
    private SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics;
    private boolean isDisposed;

    public SwingRedrawerBase(@NotNull SwingLayerProperties swingLayerProperties2, @NotNull SkiaLayerAnalytics analytics, @NotNull GraphicsApi graphicsApi) {
        Intrinsics.checkNotNullParameter((Object)swingLayerProperties2, (String)"swingLayerProperties");
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        Intrinsics.checkNotNullParameter((Object)((Object)graphicsApi), (String)"graphicsApi");
        this.swingLayerProperties = swingLayerProperties2;
        this.analytics = analytics;
        this.graphicsApi = graphicsApi;
        this.rendererAnalytics = this.analytics.renderer(Version.INSTANCE.getSkiko(), OsArch_jvmKt.getHostOs(), this.graphicsApi);
        this.rendererAnalytics.init();
    }

    protected abstract void onRender(@NotNull Graphics2D var1, int var2, int var3, long var4);

    @Override
    public void dispose() {
        if (!(!this.isDisposed)) {
            boolean bl = false;
            String string = this.getClass() + " is disposed";
            throw new IllegalArgumentException(string.toString());
        }
        this.isDisposed = true;
    }

    @Override
    public final void redraw(@NotNull Graphics2D g) {
        block9: {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            if (!(!this.isDisposed)) {
                boolean $i$a$-require-SwingRedrawerBase$redraw$22 = false;
                String $i$a$-require-SwingRedrawerBase$redraw$22 = this.getClass() + " is disposed";
                throw new IllegalArgumentException($i$a$-require-SwingRedrawerBase$redraw$22.toString());
            }
            SwingRedrawerBase this_$iv = this;
            boolean $i$f$inDrawScope = false;
            if (!SwingUtilities.isEventDispatchThread()) {
                boolean $i$a$-check-SwingRedrawerBase$inDrawScope$1$iv22 = false;
                String $i$a$-check-SwingRedrawerBase$inDrawScope$1$iv22 = "Method should be called from AWT event dispatch thread";
                throw new IllegalStateException($i$a$-check-SwingRedrawerBase$inDrawScope$1$iv22.toString());
            }
            if (this_$iv.deviceAnalytics == null) {
                boolean bl = false;
                String string = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
                throw new IllegalArgumentException(string.toString());
            }
            if (this_$iv.isDisposed) break block9;
            boolean isFirstFrame$iv = !this_$iv.isFirstFrameRendered;
            this_$iv.isFirstFrameRendered = true;
            if (isFirstFrame$iv) {
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics;
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics2 = deviceAnalytics = this_$iv.deviceAnalytics;
                if (deviceAnalytics2 != null) {
                    deviceAnalytics2.beforeFirstFrameRender();
                }
            }
            try {
                boolean bl = false;
                float scale = SwingLayerPropertiesKt.getScale(this.swingLayerProperties);
                int width = RangesKt.coerceAtLeast((int)((int)((float)this.swingLayerProperties.getWidth() * scale)), (int)0);
                int height = RangesKt.coerceAtLeast((int)((int)((float)this.swingLayerProperties.getHeight() * scale)), (int)0);
                this.onRender(g, width, height, System.nanoTime());
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
            if (isFirstFrame$iv && !this_$iv.isDisposed) {
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this_$iv.deviceAnalytics;
                if (deviceAnalytics != null) {
                    deviceAnalytics.afterFirstFrameRender();
                }
            }
        }
    }

    protected final void onDeviceChosen(@Nullable String deviceName) {
        block2: {
            if (!(!this.isDisposed)) {
                boolean $i$a$-require-SwingRedrawerBase$onDeviceChosen$32 = false;
                String $i$a$-require-SwingRedrawerBase$onDeviceChosen$32 = this.getClass() + " is disposed";
                throw new IllegalArgumentException($i$a$-require-SwingRedrawerBase$onDeviceChosen$32.toString());
            }
            if (!(this.deviceAnalytics == null)) {
                boolean bl = false;
                String string = "deviceAnalytics is not null";
                throw new IllegalArgumentException(string.toString());
            }
            this.rendererAnalytics.deviceChosen();
            SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics = this.analytics.device(Version.INSTANCE.getSkiko(), OsArch_jvmKt.getHostOs(), this.graphicsApi, deviceName);
            if (deviceAnalytics == null) break block2;
            deviceAnalytics.init();
        }
    }

    @NotNull
    protected String rendererInfo() {
        return "GraphicsApi: " + (Object)((Object)this.graphicsApi) + "\nOS: " + OsArch_jvmKt.getHostOs().getId() + ' ' + OsArch_jvmKt.getHostArch().getId() + '\n';
    }

    protected final void onContextInit(@Nullable DirectContext context) {
        block5: {
            if (!(!this.isDisposed)) {
                boolean $i$a$-require-SwingRedrawerBase$onContextInit$22 = false;
                String $i$a$-require-SwingRedrawerBase$onContextInit$22 = this.getClass() + " is disposed";
                throw new IllegalArgumentException($i$a$-require-SwingRedrawerBase$onContextInit$22.toString());
            }
            if (this.deviceAnalytics == null) {
                boolean $i$a$-requireNotNull-SwingRedrawerBase$onContextInit$32 = false;
                String $i$a$-requireNotNull-SwingRedrawerBase$onContextInit$32 = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
                throw new IllegalArgumentException($i$a$-requireNotNull-SwingRedrawerBase$onContextInit$32.toString());
            }
            if (Intrinsics.areEqual((Object)System.getProperty("skiko.hardwareInfo.enabled"), (Object)"true")) {
                Logger this_$iv = Logger.INSTANCE;
                boolean $i$f$info = false;
                if (this_$iv.getLoggerImpl().isInfoEnabled()) {
                    SkikoLoggerInterface skikoLoggerInterface = this_$iv.getLoggerImpl();
                    boolean bl = false;
                    skikoLoggerInterface.info("Renderer info:\n " + this.rendererInfo());
                }
            }
            DirectContext directContext = context;
            if (directContext != null) {
                SwingRedrawerBase.configureContext$default(this, directContext, 0L, 1, null);
            }
            SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
            if (deviceAnalytics == null) break block5;
            deviceAnalytics.contextInit();
        }
    }

    @NotNull
    protected final DirectContext configureContext(@NotNull DirectContext $this$configureContext, long gpuResourceCacheLimit) {
        DirectContext directContext;
        Intrinsics.checkNotNullParameter((Object)$this$configureContext, (String)"<this>");
        DirectContext $this$configureContext_u24lambda_u248 = directContext = $this$configureContext;
        boolean bl = false;
        if (gpuResourceCacheLimit >= 0L) {
            $this$configureContext_u24lambda_u248.setResourceCacheLimit(gpuResourceCacheLimit);
        }
        return directContext;
    }

    public static /* synthetic */ DirectContext configureContext$default(SwingRedrawerBase swingRedrawerBase, DirectContext directContext, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: configureContext");
        }
        if ((n & 1) != 0) {
            l = swingRedrawerBase.swingLayerProperties.getGpuResourceCacheLimit();
        }
        return swingRedrawerBase.configureContext(directContext, l);
    }

    private final void inDrawScope(Function0<Unit> body) {
        block8: {
            boolean $i$f$inDrawScope = false;
            if (!SwingUtilities.isEventDispatchThread()) {
                boolean $i$a$-check-SwingRedrawerBase$inDrawScope$22 = false;
                String $i$a$-check-SwingRedrawerBase$inDrawScope$22 = "Method should be called from AWT event dispatch thread";
                throw new IllegalStateException($i$a$-check-SwingRedrawerBase$inDrawScope$22.toString());
            }
            if (this.deviceAnalytics == null) {
                boolean bl = false;
                String string = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.isDisposed) break block8;
            boolean isFirstFrame = !this.isFirstFrameRendered;
            this.isFirstFrameRendered = true;
            if (isFirstFrame) {
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics;
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics2 = deviceAnalytics = this.deviceAnalytics;
                if (deviceAnalytics2 != null) {
                    deviceAnalytics2.beforeFirstFrameRender();
                }
            }
            try {
                body.invoke();
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
            if (isFirstFrame && !this.isDisposed) {
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
                if (deviceAnalytics != null) {
                    deviceAnalytics.afterFirstFrameRender();
                }
            }
        }
    }
}

