/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.lzma;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.lzma.LZMADecompressorBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.lzma.LZMADecompressorBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.lzma.LZMADecompressorBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.modules.lzma.LZMAModuleBuiltins;
import com.oracle.graal.python.builtins.modules.lzma.LZMANodes;
import com.oracle.graal.python.builtins.modules.lzma.LZMAObject;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PLZMADecompressor})
public final class LZMADecompressorBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = LZMADecompressorBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return LZMADecompressorBuiltinsFactory.getFactories();
    }

    @Builtin(name="unused_data", minNumOfPositionalArgs=1, parameterNames={"self"}, isGetter=true)
    @GenerateNodeFactory
    static abstract class UnusedDataNode
    extends PythonUnaryBuiltinNode {
        UnusedDataNode() {
        }

        @Specialization
        static PBytes doUnusedData(LZMAObject.LZMADecompressor self, @Bind PythonLanguage language) {
            return PFactory.createBytes(language, self.getUnusedData());
        }
    }

    @Builtin(name="check", minNumOfPositionalArgs=1, parameterNames={"self"}, isGetter=true)
    @GenerateNodeFactory
    static abstract class CheckNode
    extends PythonUnaryBuiltinNode {
        CheckNode() {
        }

        @Specialization
        int doCheck(LZMAObject.LZMADecompressor.Native self) {
            return self.getCheck();
        }

        @Specialization
        static int doCheck(LZMAObject.LZMADecompressor.Java self, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.SystemError, LZMAModuleBuiltins.T_LZMA_JAVA_ERROR);
        }
    }

    @Builtin(name="needs_input", minNumOfPositionalArgs=1, parameterNames={"self"}, isGetter=true)
    @GenerateNodeFactory
    static abstract class NeedsInputNode
    extends PythonUnaryBuiltinNode {
        NeedsInputNode() {
        }

        @Specialization
        boolean doNeedsInput(LZMAObject.LZMADecompressor self) {
            return self.needsInput();
        }
    }

    @Builtin(name="eof", minNumOfPositionalArgs=1, parameterNames={"self"}, isGetter=true)
    @GenerateNodeFactory
    static abstract class EofNode
    extends PythonUnaryBuiltinNode {
        EofNode() {
        }

        @Specialization
        boolean doEof(LZMAObject.LZMADecompressor self) {
            return self.isEOF();
        }
    }

    @Builtin(name="decompress", minNumOfPositionalArgs=2, parameterNames={"$self", "$data", "max_length"}, needsFrame=true)
    @ArgumentClinic(name="max_length", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class DecompressNode
    extends PythonTernaryClinicBuiltinNode {
        DecompressNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return LZMADecompressorBuiltinsClinicProviders.DecompressNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"!self.isEOF()"})
        static PBytes doBytes(LZMAObject.LZMADecompressor self, PBytesLike data, int maxLength, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached SequenceStorageNodes.GetInternalByteArrayNode toBytes, @Cached.Exclusive @Cached LZMANodes.DecompressNode decompress) {
            byte[] bytes = toBytes.execute(inliningTarget, data.getSequenceStorage());
            int len = data.getSequenceStorage().length();
            return PFactory.createBytes(language, decompress.execute(inliningTarget, self, bytes, len, maxLength));
        }

        @Specialization(guards={"!self.isEOF()"})
        static PBytes doObject(VirtualFrame frame, LZMAObject.LZMADecompressor self, Object data, int maxLength, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached BytesNodes.ToBytesNode toBytes, @Cached.Exclusive @Cached LZMANodes.DecompressNode decompress) {
            byte[] bytes = toBytes.execute(frame, data);
            int len = bytes.length;
            return PFactory.createBytes(language, decompress.execute(inliningTarget, self, bytes, len, maxLength));
        }

        @Specialization(guards={"self.isEOF()"})
        static Object err(LZMAObject.LZMADecompressor self, Object data, int maxLength, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.EOFError, ErrorMessages.ALREADY_AT_END_OF_STREAM);
        }
    }

    @Slot(value=Slot.SlotKind.tp_init, isComplex=true)
    @Slot.SlotSignature(name="LZMADecompressor", minNumOfPositionalArgs=1, parameterNames={"$self", "format", "memlimit", "filters"})
    @ImportStatic(value={PGuards.class})
    @ArgumentClinic(name="format", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="LZMAModuleBuiltins.FORMAT_AUTO", useDefaultForNone=true)
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonQuaternaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return LZMADecompressorBuiltinsClinicProviders.InitNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"!isRaw(format)", "validFormat(format)", "!isPNone(memlimitObj)"})
        static PNone notRaw(VirtualFrame frame, LZMAObject.LZMADecompressor self, int format, Object memlimitObj, PNone filters, @Bind Node inliningTarget, @Cached CastToJavaIntExactNode cast, @Cached.Shared(value="d") @Cached LZMANodes.LZMADecompressInit decompressInit, @Cached PRaiseNode raiseNode) {
            int memlimit;
            try {
                memlimit = cast.execute(inliningTarget, memlimitObj);
            }
            catch (CannotCastException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.INTEGER_REQUIRED);
            }
            return InitNode.doNotRaw(frame, self, format, memlimit, decompressInit);
        }

        @Specialization(guards={"!isRaw(format)", "validFormat(format)"})
        static PNone notRaw(VirtualFrame frame, LZMAObject.LZMADecompressor self, int format, PNone memlimit, PNone filters, @Cached.Shared(value="d") @Cached LZMANodes.LZMADecompressInit decompressInit) {
            return InitNode.doNotRaw(frame, self, format, Integer.MAX_VALUE, decompressInit);
        }

        private static PNone doNotRaw(VirtualFrame frame, LZMAObject.LZMADecompressor self, int format, int memlimit, LZMANodes.LZMADecompressInit decompressInit) {
            self.setCheck(format == LZMAModuleBuiltins.FORMAT_ALONE ? LZMAModuleBuiltins.CHECK_NONE : LZMAModuleBuiltins.CHECK_UNKNOWN);
            self.setFormat(format);
            self.setMemlimit(memlimit);
            decompressInit.execute(frame, self, format, memlimit);
            return PNone.NONE;
        }

        @Specialization(guards={"isRaw(format)", "!isPNone(filters)"})
        static PNone raw(VirtualFrame frame, LZMAObject.LZMADecompressor self, int format, PNone memlimit, Object filters, @Bind Node inliningTarget, @Cached LZMANodes.LZMARawDecompressInit decompressInit) {
            self.setCheck(LZMAModuleBuiltins.CHECK_NONE);
            decompressInit.execute(frame, inliningTarget, self, filters);
            return PNone.NONE;
        }

        @Specialization(guards={"isRaw(format)", "!isPNone(memlimit)"})
        static PNone rawError(LZMAObject.LZMADecompressor self, int format, Object memlimit, Object filters, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.CANNOT_SPECIFY_MEM_LIMIT);
        }

        @Specialization(guards={"isRaw(format)"})
        static PNone rawFilterError(LZMAObject.LZMADecompressor self, int format, Object memlimit, PNone filters, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.MUST_SPECIFY_FILTERS);
        }

        @Specialization(guards={"!isRaw(format)", "!isPNone(filters)"})
        static PNone rawFilterError(LZMAObject.LZMADecompressor self, int format, Object memlimit, Object filters, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.CANNOT_SPECIFY_FILTERS);
        }

        @Specialization(guards={"!validFormat(format)"})
        static PNone invalidFormat(LZMAObject.LZMADecompressor self, int format, Object memlimit, Object filters, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_CONTAINER_FORMAT, format);
        }

        protected static boolean validFormat(int format) {
            return format == LZMAModuleBuiltins.FORMAT_AUTO || format == LZMAModuleBuiltins.FORMAT_XZ || format == LZMAModuleBuiltins.FORMAT_ALONE || format == LZMAModuleBuiltins.FORMAT_RAW;
        }

        protected static boolean isRaw(int format) {
            return format == LZMAModuleBuiltins.FORMAT_RAW;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="LZMADecompressor", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    static abstract class LZMADecompressorNode
    extends PythonBuiltinNode {
        LZMADecompressorNode() {
        }

        @Specialization
        LZMAObject doNew(Object cls, Object arg, @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            PythonContext context = this.getContext();
            return PFactory.createLZMADecompressor(context.getLanguage(this), cls, getInstanceShape.execute(cls), context.getNFILZMASupport().isAvailable());
        }
    }
}

