/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.call.special;

import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.nodes.builtins.FunctionNodes;
import com.oracle.graal.python.nodes.call.BoundDescriptor;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.AbstractCallMethodNode;
import com.oracle.graal.python.nodes.call.special.CallTernaryMethodNodeGen;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

@GenerateUncached
public abstract class CallTernaryMethodNode
extends AbstractCallMethodNode {
    @NeverDefault
    public static CallTernaryMethodNode create() {
        return CallTernaryMethodNodeGen.create();
    }

    public static CallTernaryMethodNode getUncached() {
        return CallTernaryMethodNodeGen.getUncached();
    }

    public abstract Object execute(Frame var1, Object var2, Object var3, Object var4, Object var5);

    @Specialization(guards={"isSingleContext()", "func == cachedFunc", "builtinNode != null"}, limit="getCallSiteInlineCacheMaxDepth()")
    static Object doBuiltinFunctionCached(VirtualFrame frame, PBuiltinFunction func, Object arg1, Object arg2, Object arg3, @Cached(value="func") PBuiltinFunction cachedFunc, @Cached(value="getBuiltin(frame, func, 3)") PythonBuiltinBaseNode builtinNode) {
        return CallTernaryMethodNode.callTernaryBuiltin(frame, builtinNode, arg1, arg2, arg3);
    }

    @Specialization(guards={"func.getCallTarget() == ct", "builtinNode != null"}, limit="getCallSiteInlineCacheMaxDepth()")
    static Object doBuiltinFunctionCtCached(VirtualFrame frame, PBuiltinFunction func, Object arg1, Object arg2, Object arg3, @Cached(value="func.getCallTarget()") RootCallTarget ct, @Cached(value="getBuiltin(frame, func, 3)") PythonBuiltinBaseNode builtinNode) {
        return CallTernaryMethodNode.callTernaryBuiltin(frame, builtinNode, arg1, arg2, arg3);
    }

    @Specialization(guards={"isSingleContext()", "func == cachedFunc", "builtinNode != null", "!takesSelfArg"}, limit="getCallSiteInlineCacheMaxDepth()")
    static Object doBuiltinMethodCached(VirtualFrame frame, PBuiltinMethod func, Object arg1, Object arg2, Object arg3, @Cached(value="func") PBuiltinMethod cachedFunc, @Cached(value="takesSelfArg(func)") boolean takesSelfArg, @Cached(value="getBuiltin(frame, func.getBuiltinFunction(), 3)") PythonBuiltinBaseNode builtinNode) {
        return CallTernaryMethodNode.callTernaryBuiltin(frame, builtinNode, arg1, arg2, arg3);
    }

    @Specialization(guards={"builtinNode != null", "getCallTarget(func, getCt) == ct", "!takesSelfArg"}, limit="getCallSiteInlineCacheMaxDepth()")
    static Object doBuiltinMethodCtCached(VirtualFrame frame, PBuiltinMethod func, Object arg1, Object arg2, Object arg3, @Cached.Shared @Cached FunctionNodes.GetCallTargetNode getCt, @Cached(value="getCallTarget(func, getCt)") RootCallTarget ct, @Cached(value="takesSelfArg(func)") boolean takesSelfArg, @Cached(value="getBuiltin(frame, func.getBuiltinFunction(), 3)") PythonBuiltinBaseNode builtinNode) {
        return CallTernaryMethodNode.callTernaryBuiltin(frame, builtinNode, arg1, arg2, arg3);
    }

    @Specialization(guards={"isSingleContext()", "func == cachedFunc", "builtinNode != null", "takesSelfArg"}, limit="getCallSiteInlineCacheMaxDepth()")
    static Object callSelfMethodSingleContext(VirtualFrame frame, PBuiltinMethod func, Object arg1, Object arg2, Object arg3, @Cached(value="func", weak=true) PBuiltinMethod cachedFunc, @Cached(value="takesSelfArg(func)") boolean takesSelfArg, @Cached(value="getBuiltin(frame, func.getBuiltinFunction(), 4)") PythonBuiltinBaseNode builtinNode) {
        return CallTernaryMethodNode.callQuaternaryBuiltin(frame, builtinNode, func.getSelf(), arg1, arg2, arg3);
    }

    @Specialization(guards={"builtinNode != null", "getCallTarget(func, getCt) == ct", "takesSelfArg"}, limit="getCallSiteInlineCacheMaxDepth()")
    static Object callSelfMethod(VirtualFrame frame, PBuiltinMethod func, Object arg1, Object arg2, Object arg3, @Cached.Shared @Cached FunctionNodes.GetCallTargetNode getCt, @Cached(value="getCallTarget(func, getCt)") RootCallTarget ct, @Cached(value="takesSelfArg(func)") boolean takesSelfArg, @Cached(value="getBuiltin(frame, func.getBuiltinFunction(), 4)") PythonBuiltinBaseNode builtinNode) {
        return CallTernaryMethodNode.callQuaternaryBuiltin(frame, builtinNode, func.getSelf(), arg1, arg2, arg3);
    }

    @Specialization(replaces={"doBuiltinFunctionCached", "doBuiltinFunctionCtCached", "doBuiltinMethodCached", "doBuiltinMethodCtCached", "callSelfMethodSingleContext", "callSelfMethod"})
    @HostCompilerDirectives.InliningCutoff
    @ReportPolymorphism.Megamorphic
    static Object call(VirtualFrame frame, Object func, Object arg1, Object arg2, Object arg3, @Bind Node inliningTarget, @Cached CallNode callNode, @Cached InlinedConditionProfile isBoundProfile) {
        if (isBoundProfile.profile(inliningTarget, func instanceof BoundDescriptor)) {
            return callNode.execute((Frame)frame, ((BoundDescriptor)func).descriptor, new Object[]{arg2, arg3}, PKeyword.EMPTY_KEYWORDS);
        }
        return callNode.execute((Frame)frame, func, new Object[]{arg1, arg2, arg3}, PKeyword.EMPTY_KEYWORDS);
    }
}

