/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version11;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.StatementState;
import org.firebirdsql.gds.ng.TransactionHelper;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.wire.DeferredAction;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.Response;
import org.firebirdsql.gds.ng.wire.version10.V10Statement;

public class V11Statement
extends V10Statement {
    public V11Statement(FbWireDatabase database) {
        super(database);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(String statementText) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            TransactionHelper.checkTransactionActive(this.getTransaction());
            StatementState initialState = this.getState();
            if (!this.isPrepareAllowed(initialState)) {
                throw new SQLNonTransientException(String.format("Current statement state (%s) does not allow call to prepare", new Object[]{initialState}));
            }
            this.resetAll();
            int expectedResponseCount = 0;
            try {
                if (initialState == StatementState.NEW) {
                    this.sendAllocate();
                    this.switchState(StatementState.ALLOCATED);
                    ++expectedResponseCount;
                } else {
                    this.checkStatementValid();
                }
                this.sendPrepare(statementText);
                ++expectedResponseCount;
                this.getXdrOut().flush();
            }
            catch (IOException ex) {
                this.switchState(StatementState.ERROR);
                throw new FbExceptionBuilder().exception(335544727).cause(ex).toSQLException();
            }
            try {
                FbWireDatabase db = this.getDatabase();
                try {
                    if (initialState == StatementState.NEW) {
                        try {
                            --expectedResponseCount;
                            this.processAllocateResponse(db.readGenericResponse(this.getStatementWarningCallback()));
                        }
                        catch (SQLException e) {
                            this.forceState(StatementState.NEW);
                            throw e;
                        }
                    }
                    try {
                        --expectedResponseCount;
                        this.processPrepareResponse(db.readGenericResponse(this.getStatementWarningCallback()));
                    }
                    catch (SQLException e) {
                        this.switchState(StatementState.ALLOCATED);
                        throw e;
                    }
                }
                finally {
                    db.consumePackets(expectedResponseCount, this.getStatementWarningCallback());
                }
            }
            catch (IOException ex) {
                this.switchState(StatementState.ERROR);
                throw new FbExceptionBuilder().exception(335544726).cause(ex).toSQLException();
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    @Override
    protected void free(int option) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            try {
                this.doFreePacket(option);
                if (option != 1) {
                    this.getXdrOut().flush();
                }
                this.getDatabase().enqueueDeferredAction(new DeferredAction(){

                    @Override
                    public void processResponse(Response response) {
                        V11Statement.this.processFreeResponse(response);
                    }

                    @Override
                    public WarningMessageCallback getWarningMessageCallback() {
                        return V11Statement.this.getStatementWarningCallback();
                    }
                });
            }
            catch (IOException ex) {
                this.switchState(StatementState.ERROR);
                throw new FbExceptionBuilder().exception(335544727).cause(ex).toSQLException();
            }
        }
    }
}

