/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.ssl;

import java.io.IOException;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.x500.X500Principal;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public abstract class BaseX509KeyManager
implements X509KeyManager {
    protected @Nullable PSQLException error;

    public void throwKeyManagerException() throws PSQLException {
        if (this.error != null) {
            throw this.error;
        }
    }

    @Override
    public String @Nullable [] getClientAliases(String keyType, Principal @Nullable [] principals) {
        String[] stringArray;
        String alias = this.chooseClientAlias(new String[]{keyType}, principals, null);
        if (alias == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = alias;
        }
        return stringArray;
    }

    @Override
    public @Nullable String chooseClientAlias(String[] keyType, Principal @Nullable [] principals, @Nullable Socket socket) {
        if (principals == null || principals.length == 0) {
            return "user";
        }
        X509Certificate[] certchain = this.getCertificateChain("user");
        if (certchain == null) {
            return null;
        }
        X509Certificate cert = certchain[certchain.length - 1];
        X500Principal ourissuer = cert.getIssuerX500Principal();
        String certKeyType = cert.getPublicKey().getAlgorithm();
        boolean keyTypeFound = false;
        boolean found = false;
        if (keyType != null && keyType.length > 0) {
            for (String kt : keyType) {
                if (!kt.equalsIgnoreCase(certKeyType)) continue;
                keyTypeFound = true;
            }
        } else {
            keyTypeFound = true;
        }
        if (keyTypeFound) {
            for (Principal issuer : principals) {
                if (!ourissuer.equals(issuer)) continue;
                found = keyTypeFound;
            }
        }
        return found ? "user" : null;
    }

    @Override
    public String @Nullable [] getServerAliases(String s, Principal @Nullable [] principals) {
        return new String[0];
    }

    @Override
    public @Nullable String chooseServerAlias(String s, Principal @Nullable [] principals, @Nullable Socket socket) {
        return null;
    }

    public static void validateKeyFilePermissions(Path keyPath) throws PSQLException {
        if (BaseX509KeyManager.validatePosixPermissions(keyPath)) {
            return;
        }
        if (BaseX509KeyManager.validateWindowsAclPermissions(keyPath)) {
            return;
        }
        throw new PSQLException(GT.tr("Unable to retrieve the permissions of the private key file \"{0}\"", keyPath.toString()), PSQLState.CONNECTION_FAILURE);
    }

    private static boolean validatePosixPermissions(Path keyPath) throws PSQLException {
        try {
            boolean hasOtherPerms;
            Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(keyPath, new LinkOption[0]);
            boolean hasGroupPerms = permissions.contains((Object)PosixFilePermission.GROUP_READ) || permissions.contains((Object)PosixFilePermission.GROUP_WRITE) || permissions.contains((Object)PosixFilePermission.GROUP_EXECUTE);
            boolean bl = hasOtherPerms = permissions.contains((Object)PosixFilePermission.OTHERS_READ) || permissions.contains((Object)PosixFilePermission.OTHERS_WRITE) || permissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE);
            if (hasGroupPerms || hasOtherPerms) {
                throw new PSQLException(GT.tr("Private key file \"{0}\" has insecure permissions. Permissions for group and other must be revoked. Current permissions: {1}", keyPath.toString(), PosixFilePermissions.toString(permissions)), PSQLState.CONNECTION_FAILURE);
            }
            return true;
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
        catch (IOException e) {
            throw new PSQLException(GT.tr("Could not read permissions for private key file \"{0}\"", keyPath.toString()), PSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
    }

    private static boolean validateWindowsAclPermissions(Path keyPath) throws PSQLException {
        try {
            AclFileAttributeView aclView = Files.getFileAttributeView(keyPath, AclFileAttributeView.class, new LinkOption[0]);
            if (aclView == null) {
                return false;
            }
            UserPrincipal owner = aclView.getOwner();
            List<AclEntry> aclEntries = aclView.getAcl();
            for (AclEntry entry : aclEntries) {
                Set<AclEntryPermission> permissions;
                UserPrincipal principal = entry.principal();
                String principalName = principal.getName();
                boolean isTrustedPrincipal = principal.equals(owner) || principalName.equals("NT AUTHORITY\\SYSTEM") || principalName.equals("BUILTIN\\Administrators") || principalName.endsWith("\\Administrators");
                if (isTrustedPrincipal || !(permissions = entry.permissions()).contains((Object)AclEntryPermission.READ_DATA) && !permissions.contains((Object)AclEntryPermission.READ_ATTRIBUTES) && !permissions.contains((Object)AclEntryPermission.READ_NAMED_ATTRS)) continue;
                throw new PSQLException(GT.tr("Private key file \"{0}\" has insecure permissions. Non-owner principal \"{1}\" has read access.", keyPath.toString(), principalName), PSQLState.CONNECTION_FAILURE);
            }
            return true;
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
        catch (IOException e) {
            throw new PSQLException(GT.tr("Could not read ACL permissions for private key file \"{0}\"", keyPath.toString()), PSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
    }
}

