/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.util;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Locale;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.util.Attributes;

public class SolrBasicAuthentication
implements Authentication {
    private final String value;

    public SolrBasicAuthentication(String user, String password) {
        this.value = "Basic " + Base64.getEncoder().encodeToString((user + ":" + password).getBytes(StandardCharsets.ISO_8859_1));
    }

    public boolean matches(String type, URI uri, String realm) {
        return true;
    }

    public Authentication.Result authenticate(final Request request, ContentResponse response, final Authentication.HeaderInfo headerInfo, Attributes context) {
        return new Authentication.Result(){

            public URI getURI() {
                return URI.create(String.format(Locale.ROOT, "%s://%s:%d", request.getScheme(), request.getHost(), request.getPort()));
            }

            public void apply(Request request2) {
                request2.header(headerInfo.getHeader(), SolrBasicAuthentication.this.value);
            }
        };
    }
}

