/*
 * Decompiled with CFR 0.152.
 */
package vtk;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import vtk.vtkJavaGarbageCollector;
import vtk.vtkJavaMemoryManager;
import vtk.vtkObjectBase;
import vtk.vtkReferenceInformation;

public class vtkJavaMemoryManagerImpl
implements vtkJavaMemoryManager {
    private vtkJavaGarbageCollector garbageCollector;
    private ReentrantLock lock = new ReentrantLock();
    private vtkReferenceInformation lastGcResult;
    private HashMap<Long, WeakReference<vtkObjectBase>> objectMap = new HashMap();
    private HashMap<Long, String> objectMapClassName = new HashMap();

    public vtkJavaMemoryManagerImpl() {
        this.garbageCollector = new vtkJavaGarbageCollector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public vtkObjectBase getJavaObject(Long l) {
        vtkObjectBase vtkObjectBase2;
        if (l == null || l == 0L) {
            throw new RuntimeException("Invalid ID, can not be null or equal to 0.");
        }
        WeakReference<vtkObjectBase> weakReference = this.objectMap.get(l);
        vtkObjectBase vtkObjectBase3 = vtkObjectBase2 = weakReference == null ? null : (vtkObjectBase)weakReference.get();
        if (weakReference == null || vtkObjectBase2 == null) {
            try {
                this.lock.lock();
                weakReference = this.objectMap.get(l);
                vtkObjectBase vtkObjectBase4 = vtkObjectBase2 = weakReference == null ? null : (vtkObjectBase)weakReference.get();
                if (vtkObjectBase2 != null) {
                    vtkObjectBase vtkObjectBase5 = vtkObjectBase2;
                    return vtkObjectBase5;
                }
                if (weakReference != null && vtkObjectBase2 == null) {
                    this.unRegisterJavaObject(l);
                }
                if (vtkObjectBase2 == null) {
                    try {
                        String string = vtkObjectBase.VTKGetClassNameFromReference(l);
                        Class<?> clazz = Class.forName("vtk." + string);
                        Constructor<?> constructor = clazz.getConstructor(Long.TYPE);
                        vtkObjectBase2 = (vtkObjectBase)constructor.newInstance(l);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return vtkObjectBase2;
    }

    @Override
    public void registerJavaObject(Long l, vtkObjectBase vtkObjectBase2) {
        try {
            this.lock.lock();
            this.objectMap.put(l, new WeakReference<vtkObjectBase>(vtkObjectBase2));
            this.objectMapClassName.put(l, vtkObjectBase2.GetClassName());
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void unRegisterJavaObject(Long l) {
        block4: {
            try {
                this.lock.lock();
                this.objectMapClassName.remove(l);
                WeakReference<vtkObjectBase> weakReference = this.objectMap.remove(l);
                if (weakReference != null) {
                    vtkObjectBase.VTKDeleteReference(l);
                    break block4;
                }
                throw new RuntimeException("You try to delete a vtkObject that is not referenced in the Java object Map. You may have call Delete() twice.");
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public vtkReferenceInformation gc(boolean bl) {
        System.gc();
        try {
            this.lock.lock();
            vtkReferenceInformation vtkReferenceInformation2 = new vtkReferenceInformation(bl);
            for (Long l : new TreeSet<Long>(this.objectMap.keySet())) {
                vtkObjectBase vtkObjectBase2 = (vtkObjectBase)this.objectMap.get(l).get();
                if (vtkObjectBase2 == null) {
                    vtkReferenceInformation2.addFreeObject(this.objectMapClassName.get(l));
                    this.unRegisterJavaObject(l);
                    continue;
                }
                vtkReferenceInformation2.addKeptObject(this.objectMapClassName.get(l));
            }
            this.lastGcResult = vtkReferenceInformation2;
            vtkReferenceInformation vtkReferenceInformation3 = vtkReferenceInformation2;
            return vtkReferenceInformation3;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public vtkJavaGarbageCollector getAutoGarbageCollector() {
        return this.garbageCollector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteAll() {
        int n = this.objectMap.size();
        try {
            this.lock.lock();
            for (Long l : new TreeSet<Long>(this.objectMap.keySet())) {
                this.unRegisterJavaObject(l);
            }
        }
        finally {
            this.lock.unlock();
        }
        return n;
    }

    @Override
    public int getSize() {
        return this.objectMap.size();
    }

    @Override
    public vtkReferenceInformation getLastReferenceInformation() {
        return this.lastGcResult;
    }
}

