<?php

declare(strict_types=1);

namespace RulerZ\Model;

class Executor
{
    /**
     * List of the traits to use in the executor's code.
     *
     * @var array
     */
    private $traits;

    /**
     * Compiled code of the rule.
     *
     * @var string
     */
    private $compiledRule;

    /**
     * Data generated by the compiler and stored to be used by the executors.
     *
     * @var array
     */
    private $compiledData;

    public function __construct(array $traits, string $compiledRule, array $compilationData = [])
    {
        $this->traits = $traits;
        $this->compiledRule = $compiledRule;
        $this->compiledData = $compilationData;
    }

    public function getTraits(): array
    {
        return $this->traits;
    }

    public function getCompiledRule(): string
    {
        return $this->compiledRule;
    }

    public function getCompiledData(): array
    {
        return $this->compiledData;
    }
}
