# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "billing invoice section initiate-transfer",
)
class InitiateTransfer(AAZCommand):
    """Sends a request to a user in another billing account to transfer billing ownership of their subscriptions. The operation is supported only for billing accounts with agreement type Microsoft Customer Agreement.
    """

    _aaz_info = {
        "version": "2019-10-01-preview",
        "resources": [
            ["mgmt-plane", "/providers/microsoft.billing/billingaccounts/{}/billingprofiles/{}/invoicesections/{}/initiatetransfer", "2019-10-01-preview"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.billing_account_name = AAZStrArg(
            options=["--billing-account-name"],
            help="The ID that uniquely identifies a billing account.",
            required=True,
        )
        _args_schema.billing_profile_name = AAZStrArg(
            options=["--billing-profile-name"],
            help="The ID that uniquely identifies a billing profile.",
            required=True,
        )
        _args_schema.invoice_section_name = AAZStrArg(
            options=["--invoice-section-name"],
            help="The ID that uniquely identifies an invoice section.",
            required=True,
        )

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.recipient_email_id = AAZStrArg(
            options=["--recipient-email-id"],
            arg_group="Properties",
            help="The email ID of the recipient to whom the transfer request is sent.",
        )
        _args_schema.reseller_id = AAZStrArg(
            options=["--reseller-id"],
            arg_group="Properties",
            help="Optional MPN ID of the reseller for transfer requests that are sent from a Microsoft Partner Agreement billing account.",
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.TransfersInitiate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class TransfersInitiate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}/initiateTransfer",
                **self.url_parameters
            )

        @property
        def method(self):
            return "POST"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "billingAccountName", self.ctx.args.billing_account_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "billingProfileName", self.ctx.args.billing_profile_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "invoiceSectionName", self.ctx.args.invoice_section_name,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2019-10-01-preview",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("recipientEmailId", AAZStrType, ".recipient_email_id")
                properties.set_prop("resellerId", AAZStrType, ".reseller_id")

            return self.serialize_content(_content_value)

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.properties = AAZObjectType(
                flags={"client_flatten": True},
            )

            properties = cls._schema_on_200.properties
            properties.billing_account_id = AAZStrType(
                serialized_name="billingAccountId",
                flags={"read_only": True},
            )
            properties.billing_profile_id = AAZStrType(
                serialized_name="billingProfileId",
                flags={"read_only": True},
            )
            properties.canceled_by = AAZStrType(
                serialized_name="canceledBy",
                flags={"read_only": True},
            )
            properties.creation_time = AAZStrType(
                serialized_name="creationTime",
                flags={"read_only": True},
            )
            properties.detailed_transfer_status = AAZListType(
                serialized_name="detailedTransferStatus",
                flags={"read_only": True},
            )
            properties.expiration_time = AAZStrType(
                serialized_name="expirationTime",
                flags={"read_only": True},
            )
            properties.initiator_customer_type = AAZStrType(
                serialized_name="initiatorCustomerType",
                flags={"read_only": True},
            )
            properties.initiator_email_id = AAZStrType(
                serialized_name="initiatorEmailId",
                flags={"read_only": True},
            )
            properties.invoice_section_id = AAZStrType(
                serialized_name="invoiceSectionId",
                flags={"read_only": True},
            )
            properties.last_modified_time = AAZStrType(
                serialized_name="lastModifiedTime",
                flags={"read_only": True},
            )
            properties.recipient_email_id = AAZStrType(
                serialized_name="recipientEmailId",
                flags={"read_only": True},
            )
            properties.reseller_id = AAZStrType(
                serialized_name="resellerId",
                flags={"read_only": True},
            )
            properties.reseller_name = AAZStrType(
                serialized_name="resellerName",
                flags={"read_only": True},
            )
            properties.transfer_status = AAZStrType(
                serialized_name="transferStatus",
            )

            detailed_transfer_status = cls._schema_on_200.properties.detailed_transfer_status
            detailed_transfer_status.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.detailed_transfer_status.Element
            _element.error_details = AAZObjectType(
                serialized_name="errorDetails",
            )
            _element.product_id = AAZStrType(
                serialized_name="productId",
                flags={"read_only": True},
            )
            _element.product_type = AAZStrType(
                serialized_name="productType",
            )
            _element.transfer_status = AAZStrType(
                serialized_name="transferStatus",
            )

            error_details = cls._schema_on_200.properties.detailed_transfer_status.Element.error_details
            error_details.error_code = AAZStrType(
                serialized_name="errorCode",
                flags={"read_only": True},
            )
            error_details.error_message = AAZStrType(
                serialized_name="errorMessage",
                flags={"read_only": True},
            )

            return cls._schema_on_200


class _InitiateTransferHelper:
    """Helper class for InitiateTransfer"""


__all__ = ["InitiateTransfer"]
