# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, Callable, Dict, Optional, TypeVar, Union

from msrest import Serializer

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.mgmt.core.exceptions import ARMErrorFormat

from .. import models as _models
from .._vendor import _convert_request, _format_url_section
T = TypeVar('T')
JSONType = Any
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False

def build_create_or_update_request(
    subscription_id: str,
    resource_group_name: str,
    workspace_name: str,
    sql_pool_name: str,
    vulnerability_assessment_name: Union[str, "_models.VulnerabilityAssessmentName"],
    rule_id: str,
    baseline_name: Union[str, "_models.VulnerabilityAssessmentPolicyBaselineName"],
    *,
    json: JSONType = None,
    content: Any = None,
    **kwargs: Any
) -> HttpRequest:
    api_version = kwargs.pop('api_version', "2021-06-01")  # type: str
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    _url = kwargs.pop("template_url", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}")  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, 'str', min_length=1),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, 'str', max_length=90, min_length=1),
        "workspaceName": _SERIALIZER.url("workspace_name", workspace_name, 'str'),
        "sqlPoolName": _SERIALIZER.url("sql_pool_name", sql_pool_name, 'str'),
        "vulnerabilityAssessmentName": _SERIALIZER.url("vulnerability_assessment_name", vulnerability_assessment_name, 'str'),
        "ruleId": _SERIALIZER.url("rule_id", rule_id, 'str'),
        "baselineName": _SERIALIZER.url("baseline_name", baseline_name, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        _header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        json=json,
        content=content,
        **kwargs
    )


def build_delete_request(
    subscription_id: str,
    resource_group_name: str,
    workspace_name: str,
    sql_pool_name: str,
    vulnerability_assessment_name: Union[str, "_models.VulnerabilityAssessmentName"],
    rule_id: str,
    baseline_name: Union[str, "_models.VulnerabilityAssessmentPolicyBaselineName"],
    **kwargs: Any
) -> HttpRequest:
    api_version = kwargs.pop('api_version', "2021-06-01")  # type: str

    # Construct URL
    _url = kwargs.pop("template_url", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}")  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, 'str', min_length=1),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, 'str', max_length=90, min_length=1),
        "workspaceName": _SERIALIZER.url("workspace_name", workspace_name, 'str'),
        "sqlPoolName": _SERIALIZER.url("sql_pool_name", sql_pool_name, 'str'),
        "vulnerabilityAssessmentName": _SERIALIZER.url("vulnerability_assessment_name", vulnerability_assessment_name, 'str'),
        "ruleId": _SERIALIZER.url("rule_id", rule_id, 'str'),
        "baselineName": _SERIALIZER.url("baseline_name", baseline_name, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    return HttpRequest(
        method="DELETE",
        url=_url,
        params=_query_parameters,
        **kwargs
    )


def build_get_request(
    subscription_id: str,
    resource_group_name: str,
    workspace_name: str,
    sql_pool_name: str,
    vulnerability_assessment_name: Union[str, "_models.VulnerabilityAssessmentName"],
    rule_id: str,
    baseline_name: Union[str, "_models.VulnerabilityAssessmentPolicyBaselineName"],
    **kwargs: Any
) -> HttpRequest:
    api_version = kwargs.pop('api_version', "2021-06-01")  # type: str

    accept = "application/json"
    # Construct URL
    _url = kwargs.pop("template_url", "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}")  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, 'str', min_length=1),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, 'str', max_length=90, min_length=1),
        "workspaceName": _SERIALIZER.url("workspace_name", workspace_name, 'str'),
        "sqlPoolName": _SERIALIZER.url("sql_pool_name", sql_pool_name, 'str'),
        "vulnerabilityAssessmentName": _SERIALIZER.url("vulnerability_assessment_name", vulnerability_assessment_name, 'str'),
        "ruleId": _SERIALIZER.url("rule_id", rule_id, 'str'),
        "baselineName": _SERIALIZER.url("baseline_name", baseline_name, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )

class SqlPoolVulnerabilityAssessmentRuleBaselinesOperations(object):
    """SqlPoolVulnerabilityAssessmentRuleBaselinesOperations operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.synapse.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer):
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace
    def create_or_update(
        self,
        resource_group_name: str,
        workspace_name: str,
        sql_pool_name: str,
        vulnerability_assessment_name: Union[str, "_models.VulnerabilityAssessmentName"],
        rule_id: str,
        baseline_name: Union[str, "_models.VulnerabilityAssessmentPolicyBaselineName"],
        parameters: "_models.SqlPoolVulnerabilityAssessmentRuleBaseline",
        **kwargs: Any
    ) -> "_models.SqlPoolVulnerabilityAssessmentRuleBaseline":
        """Creates or updates a Sql pool's vulnerability assessment rule baseline.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace.
        :type workspace_name: str
        :param sql_pool_name: SQL pool name.
        :type sql_pool_name: str
        :param vulnerability_assessment_name: The name of the vulnerability assessment.
        :type vulnerability_assessment_name: str or
         ~azure.mgmt.synapse.models.VulnerabilityAssessmentName
        :param rule_id: The vulnerability assessment rule ID.
        :type rule_id: str
        :param baseline_name: The name of the vulnerability assessment rule baseline (default implies a
         baseline on a Sql pool level rule and master for workspace level rule).
        :type baseline_name: str or
         ~azure.mgmt.synapse.models.VulnerabilityAssessmentPolicyBaselineName
        :param parameters: The requested rule baseline resource.
        :type parameters: ~azure.mgmt.synapse.models.SqlPoolVulnerabilityAssessmentRuleBaseline
        :keyword api_version: Api Version. Default value is "2021-06-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SqlPoolVulnerabilityAssessmentRuleBaseline, or the result of cls(response)
        :rtype: ~azure.mgmt.synapse.models.SqlPoolVulnerabilityAssessmentRuleBaseline
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.SqlPoolVulnerabilityAssessmentRuleBaseline"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-06-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(parameters, 'SqlPoolVulnerabilityAssessmentRuleBaseline')

        request = build_create_or_update_request(
            subscription_id=self._config.subscription_id,
            resource_group_name=resource_group_name,
            workspace_name=workspace_name,
            sql_pool_name=sql_pool_name,
            vulnerability_assessment_name=vulnerability_assessment_name,
            rule_id=rule_id,
            baseline_name=baseline_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self.create_or_update.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('SqlPoolVulnerabilityAssessmentRuleBaseline', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_or_update.metadata = {'url': "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}"}  # type: ignore


    @distributed_trace
    def delete(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        workspace_name: str,
        sql_pool_name: str,
        vulnerability_assessment_name: Union[str, "_models.VulnerabilityAssessmentName"],
        rule_id: str,
        baseline_name: Union[str, "_models.VulnerabilityAssessmentPolicyBaselineName"],
        **kwargs: Any
    ) -> None:
        """Removes the database's vulnerability assessment rule baseline.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace.
        :type workspace_name: str
        :param sql_pool_name: SQL pool name.
        :type sql_pool_name: str
        :param vulnerability_assessment_name: The name of the vulnerability assessment.
        :type vulnerability_assessment_name: str or
         ~azure.mgmt.synapse.models.VulnerabilityAssessmentName
        :param rule_id: The vulnerability assessment rule ID.
        :type rule_id: str
        :param baseline_name: The name of the vulnerability assessment rule baseline (default implies a
         baseline on a Sql pool level rule and master for workspace level rule).
        :type baseline_name: str or
         ~azure.mgmt.synapse.models.VulnerabilityAssessmentPolicyBaselineName
        :keyword api_version: Api Version. Default value is "2021-06-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-06-01")  # type: str

        
        request = build_delete_request(
            subscription_id=self._config.subscription_id,
            resource_group_name=resource_group_name,
            workspace_name=workspace_name,
            sql_pool_name=sql_pool_name,
            vulnerability_assessment_name=vulnerability_assessment_name,
            rule_id=rule_id,
            baseline_name=baseline_name,
            api_version=api_version,
            template_url=self.delete.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete.metadata = {'url': "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}"}  # type: ignore


    @distributed_trace
    def get(
        self,
        resource_group_name: str,
        workspace_name: str,
        sql_pool_name: str,
        vulnerability_assessment_name: Union[str, "_models.VulnerabilityAssessmentName"],
        rule_id: str,
        baseline_name: Union[str, "_models.VulnerabilityAssessmentPolicyBaselineName"],
        **kwargs: Any
    ) -> "_models.SqlPoolVulnerabilityAssessmentRuleBaseline":
        """Gets a SqlPool's vulnerability assessment rule baseline.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace.
        :type workspace_name: str
        :param sql_pool_name: SQL pool name.
        :type sql_pool_name: str
        :param vulnerability_assessment_name: The name of the vulnerability assessment.
        :type vulnerability_assessment_name: str or
         ~azure.mgmt.synapse.models.VulnerabilityAssessmentName
        :param rule_id: The vulnerability assessment rule ID.
        :type rule_id: str
        :param baseline_name: The name of the vulnerability assessment rule baseline (default implies a
         baseline on a Sql pool level rule and master for server level rule).
        :type baseline_name: str or
         ~azure.mgmt.synapse.models.VulnerabilityAssessmentPolicyBaselineName
        :keyword api_version: Api Version. Default value is "2021-06-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SqlPoolVulnerabilityAssessmentRuleBaseline, or the result of cls(response)
        :rtype: ~azure.mgmt.synapse.models.SqlPoolVulnerabilityAssessmentRuleBaseline
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.SqlPoolVulnerabilityAssessmentRuleBaseline"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-06-01")  # type: str

        
        request = build_get_request(
            subscription_id=self._config.subscription_id,
            resource_group_name=resource_group_name,
            workspace_name=workspace_name,
            sql_pool_name=sql_pool_name,
            vulnerability_assessment_name=vulnerability_assessment_name,
            rule_id=rule_id,
            baseline_name=baseline_name,
            api_version=api_version,
            template_url=self.get.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('SqlPoolVulnerabilityAssessmentRuleBaseline', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {'url': "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}"}  # type: ignore

