# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
from typing import Any, AsyncIterator, Callable, Dict, IO, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core import AsyncPipelineClient
from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.async_arm_polling import AsyncARMPolling

from ... import models as _models
from ..._utils.serialization import Deserializer, Serializer
from ...operations._static_sites_operations import (
    build_approve_or_reject_private_endpoint_connection_request,
    build_create_or_update_basic_auth_request,
    build_create_or_update_build_database_connection_request,
    build_create_or_update_database_connection_request,
    build_create_or_update_static_site_app_settings_request,
    build_create_or_update_static_site_build_app_settings_request,
    build_create_or_update_static_site_build_function_app_settings_request,
    build_create_or_update_static_site_custom_domain_request,
    build_create_or_update_static_site_function_app_settings_request,
    build_create_or_update_static_site_request,
    build_create_user_roles_invitation_link_request,
    build_create_zip_deployment_for_static_site_build_request,
    build_create_zip_deployment_for_static_site_request,
    build_delete_build_database_connection_request,
    build_delete_database_connection_request,
    build_delete_private_endpoint_connection_request,
    build_delete_static_site_build_request,
    build_delete_static_site_custom_domain_request,
    build_delete_static_site_request,
    build_delete_static_site_user_request,
    build_detach_static_site_request,
    build_detach_user_provided_function_app_from_static_site_build_request,
    build_detach_user_provided_function_app_from_static_site_request,
    build_get_basic_auth_request,
    build_get_build_database_connection_request,
    build_get_build_database_connection_with_details_request,
    build_get_build_database_connections_request,
    build_get_build_database_connections_with_details_request,
    build_get_database_connection_request,
    build_get_database_connection_with_details_request,
    build_get_database_connections_request,
    build_get_database_connections_with_details_request,
    build_get_linked_backend_for_build_request,
    build_get_linked_backend_request,
    build_get_linked_backends_for_build_request,
    build_get_linked_backends_request,
    build_get_private_endpoint_connection_list_request,
    build_get_private_endpoint_connection_request,
    build_get_private_link_resources_request,
    build_get_static_site_build_request,
    build_get_static_site_builds_request,
    build_get_static_site_custom_domain_request,
    build_get_static_site_request,
    build_get_static_sites_by_resource_group_request,
    build_get_user_provided_function_app_for_static_site_build_request,
    build_get_user_provided_function_app_for_static_site_request,
    build_get_user_provided_function_apps_for_static_site_build_request,
    build_get_user_provided_function_apps_for_static_site_request,
    build_link_backend_request,
    build_link_backend_to_build_request,
    build_list_basic_auth_request,
    build_list_request,
    build_list_static_site_app_settings_request,
    build_list_static_site_build_app_settings_request,
    build_list_static_site_build_function_app_settings_request,
    build_list_static_site_build_functions_request,
    build_list_static_site_configured_roles_request,
    build_list_static_site_custom_domains_request,
    build_list_static_site_function_app_settings_request,
    build_list_static_site_functions_request,
    build_list_static_site_secrets_request,
    build_list_static_site_users_request,
    build_preview_workflow_request,
    build_register_user_provided_function_app_with_static_site_build_request,
    build_register_user_provided_function_app_with_static_site_request,
    build_reset_static_site_api_key_request,
    build_unlink_backend_from_build_request,
    build_unlink_backend_request,
    build_update_build_database_connection_request,
    build_update_database_connection_request,
    build_update_static_site_request,
    build_update_static_site_user_request,
    build_validate_backend_for_build_request,
    build_validate_backend_request,
    build_validate_custom_domain_can_be_added_to_static_site_request,
)
from .._configuration import WebSiteManagementClientConfiguration

JSON = MutableMapping[str, Any]
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class StaticSitesOperations:  # pylint: disable=too-many-public-methods
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.web.v2022_09_01.aio.WebSiteManagementClient`'s
        :attr:`static_sites` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: WebSiteManagementClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    @overload
    async def preview_workflow(
        self,
        location: str,
        static_sites_workflow_preview_request: _models.StaticSitesWorkflowPreviewRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StaticSitesWorkflowPreview:
        """Generates a preview workflow file for the static site.

        Description for Generates a preview workflow file for the static site.

        :param location: Location where you plan to create the static site. Required.
        :type location: str
        :param static_sites_workflow_preview_request: A JSON representation of the
         StaticSitesWorkflowPreviewRequest properties. See example. Required.
        :type static_sites_workflow_preview_request:
         ~azure.mgmt.web.v2022_09_01.models.StaticSitesWorkflowPreviewRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StaticSitesWorkflowPreview or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StaticSitesWorkflowPreview
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def preview_workflow(
        self,
        location: str,
        static_sites_workflow_preview_request: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StaticSitesWorkflowPreview:
        """Generates a preview workflow file for the static site.

        Description for Generates a preview workflow file for the static site.

        :param location: Location where you plan to create the static site. Required.
        :type location: str
        :param static_sites_workflow_preview_request: A JSON representation of the
         StaticSitesWorkflowPreviewRequest properties. See example. Required.
        :type static_sites_workflow_preview_request: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StaticSitesWorkflowPreview or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StaticSitesWorkflowPreview
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def preview_workflow(
        self,
        location: str,
        static_sites_workflow_preview_request: Union[_models.StaticSitesWorkflowPreviewRequest, IO[bytes]],
        **kwargs: Any
    ) -> _models.StaticSitesWorkflowPreview:
        """Generates a preview workflow file for the static site.

        Description for Generates a preview workflow file for the static site.

        :param location: Location where you plan to create the static site. Required.
        :type location: str
        :param static_sites_workflow_preview_request: A JSON representation of the
         StaticSitesWorkflowPreviewRequest properties. See example. Is either a
         StaticSitesWorkflowPreviewRequest type or a IO[bytes] type. Required.
        :type static_sites_workflow_preview_request:
         ~azure.mgmt.web.v2022_09_01.models.StaticSitesWorkflowPreviewRequest or IO[bytes]
        :return: StaticSitesWorkflowPreview or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StaticSitesWorkflowPreview
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StaticSitesWorkflowPreview] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(static_sites_workflow_preview_request, (IOBase, bytes)):
            _content = static_sites_workflow_preview_request
        else:
            _json = self._serialize.body(static_sites_workflow_preview_request, "StaticSitesWorkflowPreviewRequest")

        _request = build_preview_workflow_request(
            location=location,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StaticSitesWorkflowPreview", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list(self, **kwargs: Any) -> AsyncItemPaged["_models.StaticSiteARMResource"]:
        """Get all Static Sites for a subscription.

        Description for Get all Static Sites for a subscription.

        :return: An iterator like instance of either StaticSiteARMResource or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2022_09_01.models.StaticSiteARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.StaticSiteCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("StaticSiteCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def get_static_sites_by_resource_group(
        self, resource_group_name: str, **kwargs: Any
    ) -> AsyncItemPaged["_models.StaticSiteARMResource"]:
        """Gets all static sites in the specified resource group.

        Description for Gets all static sites in the specified resource group.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :return: An iterator like instance of either StaticSiteARMResource or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2022_09_01.models.StaticSiteARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.StaticSiteCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_get_static_sites_by_resource_group_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("StaticSiteCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_static_site(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.StaticSiteARMResource:
        """Gets the details of a static site.

        Description for Gets the details of a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :return: StaticSiteARMResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StaticSiteARMResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.StaticSiteARMResource] = kwargs.pop("cls", None)

        _request = build_get_static_site_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StaticSiteARMResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_or_update_static_site_initial(
        self,
        resource_group_name: str,
        name: str,
        static_site_envelope: Union[_models.StaticSiteARMResource, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(static_site_envelope, (IOBase, bytes)):
            _content = static_site_envelope
        else:
            _json = self._serialize.body(static_site_envelope, "StaticSiteARMResource")

        _request = build_create_or_update_static_site_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update_static_site(
        self,
        resource_group_name: str,
        name: str,
        static_site_envelope: _models.StaticSiteARMResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.StaticSiteARMResource]:
        """Creates a new static site in an existing resource group, or updates an existing static site.

        Description for Creates a new static site in an existing resource group, or updates an existing
        static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site to create or update. Required.
        :type name: str
        :param static_site_envelope: A JSON representation of the staticsite properties. See example.
         Required.
        :type static_site_envelope: ~azure.mgmt.web.v2022_09_01.models.StaticSiteARMResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either StaticSiteARMResource or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2022_09_01.models.StaticSiteARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update_static_site(
        self,
        resource_group_name: str,
        name: str,
        static_site_envelope: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.StaticSiteARMResource]:
        """Creates a new static site in an existing resource group, or updates an existing static site.

        Description for Creates a new static site in an existing resource group, or updates an existing
        static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site to create or update. Required.
        :type name: str
        :param static_site_envelope: A JSON representation of the staticsite properties. See example.
         Required.
        :type static_site_envelope: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either StaticSiteARMResource or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2022_09_01.models.StaticSiteARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update_static_site(
        self,
        resource_group_name: str,
        name: str,
        static_site_envelope: Union[_models.StaticSiteARMResource, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.StaticSiteARMResource]:
        """Creates a new static site in an existing resource group, or updates an existing static site.

        Description for Creates a new static site in an existing resource group, or updates an existing
        static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site to create or update. Required.
        :type name: str
        :param static_site_envelope: A JSON representation of the staticsite properties. See example.
         Is either a StaticSiteARMResource type or a IO[bytes] type. Required.
        :type static_site_envelope: ~azure.mgmt.web.v2022_09_01.models.StaticSiteARMResource or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns either StaticSiteARMResource or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2022_09_01.models.StaticSiteARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StaticSiteARMResource] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_static_site_initial(
                resource_group_name=resource_group_name,
                name=name,
                static_site_envelope=static_site_envelope,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("StaticSiteARMResource", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.StaticSiteARMResource].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.StaticSiteARMResource](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _delete_static_site_initial(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_delete_static_site_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_delete_static_site(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes a static site.

        Description for Deletes a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site to delete. Required.
        :type name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_static_site_initial(
                resource_group_name=resource_group_name,
                name=name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @overload
    async def update_static_site(
        self,
        resource_group_name: str,
        name: str,
        static_site_envelope: _models.StaticSitePatchResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StaticSiteARMResource:
        """Creates a new static site in an existing resource group, or updates an existing static site.

        Description for Creates a new static site in an existing resource group, or updates an existing
        static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site to create or update. Required.
        :type name: str
        :param static_site_envelope: A JSON representation of the staticsite properties. See example.
         Required.
        :type static_site_envelope: ~azure.mgmt.web.v2022_09_01.models.StaticSitePatchResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StaticSiteARMResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StaticSiteARMResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_static_site(
        self,
        resource_group_name: str,
        name: str,
        static_site_envelope: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StaticSiteARMResource:
        """Creates a new static site in an existing resource group, or updates an existing static site.

        Description for Creates a new static site in an existing resource group, or updates an existing
        static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site to create or update. Required.
        :type name: str
        :param static_site_envelope: A JSON representation of the staticsite properties. See example.
         Required.
        :type static_site_envelope: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StaticSiteARMResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StaticSiteARMResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_static_site(
        self,
        resource_group_name: str,
        name: str,
        static_site_envelope: Union[_models.StaticSitePatchResource, IO[bytes]],
        **kwargs: Any
    ) -> _models.StaticSiteARMResource:
        """Creates a new static site in an existing resource group, or updates an existing static site.

        Description for Creates a new static site in an existing resource group, or updates an existing
        static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site to create or update. Required.
        :type name: str
        :param static_site_envelope: A JSON representation of the staticsite properties. See example.
         Is either a StaticSitePatchResource type or a IO[bytes] type. Required.
        :type static_site_envelope: ~azure.mgmt.web.v2022_09_01.models.StaticSitePatchResource or
         IO[bytes]
        :return: StaticSiteARMResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StaticSiteARMResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StaticSiteARMResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(static_site_envelope, (IOBase, bytes)):
            _content = static_site_envelope
        else:
            _json = self._serialize.body(static_site_envelope, "StaticSitePatchResource")

        _request = build_update_static_site_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StaticSiteARMResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_static_site_users(
        self, resource_group_name: str, name: str, authprovider: str, **kwargs: Any
    ) -> AsyncItemPaged["_models.StaticSiteUserARMResource"]:
        """Gets the list of users of a static site.

        Description for Gets the list of users of a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param authprovider: The auth provider for the users. Required.
        :type authprovider: str
        :return: An iterator like instance of either StaticSiteUserARMResource or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2022_09_01.models.StaticSiteUserARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.StaticSiteUserCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_static_site_users_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    authprovider=authprovider,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("StaticSiteUserCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def delete_static_site_user(
        self, resource_group_name: str, name: str, authprovider: str, userid: str, **kwargs: Any
    ) -> None:
        """Deletes the user entry from the static site.

        Description for Deletes the user entry from the static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the staticsite. Required.
        :type name: str
        :param authprovider: The auth provider for this user. Required.
        :type authprovider: str
        :param userid: The user id of the user. Required.
        :type userid: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_static_site_user_request(
            resource_group_name=resource_group_name,
            name=name,
            authprovider=authprovider,
            userid=userid,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def update_static_site_user(
        self,
        resource_group_name: str,
        name: str,
        authprovider: str,
        userid: str,
        static_site_user_envelope: _models.StaticSiteUserARMResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StaticSiteUserARMResource:
        """Updates a user entry with the listed roles.

        Description for Updates a user entry with the listed roles.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param authprovider: The auth provider for this user. Required.
        :type authprovider: str
        :param userid: The user id of the user. Required.
        :type userid: str
        :param static_site_user_envelope: A JSON representation of the StaticSiteUser properties. See
         example. Required.
        :type static_site_user_envelope: ~azure.mgmt.web.v2022_09_01.models.StaticSiteUserARMResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StaticSiteUserARMResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StaticSiteUserARMResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_static_site_user(
        self,
        resource_group_name: str,
        name: str,
        authprovider: str,
        userid: str,
        static_site_user_envelope: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StaticSiteUserARMResource:
        """Updates a user entry with the listed roles.

        Description for Updates a user entry with the listed roles.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param authprovider: The auth provider for this user. Required.
        :type authprovider: str
        :param userid: The user id of the user. Required.
        :type userid: str
        :param static_site_user_envelope: A JSON representation of the StaticSiteUser properties. See
         example. Required.
        :type static_site_user_envelope: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StaticSiteUserARMResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StaticSiteUserARMResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_static_site_user(
        self,
        resource_group_name: str,
        name: str,
        authprovider: str,
        userid: str,
        static_site_user_envelope: Union[_models.StaticSiteUserARMResource, IO[bytes]],
        **kwargs: Any
    ) -> _models.StaticSiteUserARMResource:
        """Updates a user entry with the listed roles.

        Description for Updates a user entry with the listed roles.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param authprovider: The auth provider for this user. Required.
        :type authprovider: str
        :param userid: The user id of the user. Required.
        :type userid: str
        :param static_site_user_envelope: A JSON representation of the StaticSiteUser properties. See
         example. Is either a StaticSiteUserARMResource type or a IO[bytes] type. Required.
        :type static_site_user_envelope: ~azure.mgmt.web.v2022_09_01.models.StaticSiteUserARMResource
         or IO[bytes]
        :return: StaticSiteUserARMResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StaticSiteUserARMResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StaticSiteUserARMResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(static_site_user_envelope, (IOBase, bytes)):
            _content = static_site_user_envelope
        else:
            _json = self._serialize.body(static_site_user_envelope, "StaticSiteUserARMResource")

        _request = build_update_static_site_user_request(
            resource_group_name=resource_group_name,
            name=name,
            authprovider=authprovider,
            userid=userid,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StaticSiteUserARMResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_static_site_builds(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncItemPaged["_models.StaticSiteBuildARMResource"]:
        """Gets all static site builds for a particular static site.

        Description for Gets all static site builds for a particular static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :return: An iterator like instance of either StaticSiteBuildARMResource or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2022_09_01.models.StaticSiteBuildARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.StaticSiteBuildCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_get_static_site_builds_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("StaticSiteBuildCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_static_site_build(
        self, resource_group_name: str, name: str, environment_name: str, **kwargs: Any
    ) -> _models.StaticSiteBuildARMResource:
        """Gets the details of a static site build.

        Description for Gets the details of a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :return: StaticSiteBuildARMResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StaticSiteBuildARMResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.StaticSiteBuildARMResource] = kwargs.pop("cls", None)

        _request = build_get_static_site_build_request(
            resource_group_name=resource_group_name,
            name=name,
            environment_name=environment_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StaticSiteBuildARMResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _delete_static_site_build_initial(
        self, resource_group_name: str, name: str, environment_name: str, **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_delete_static_site_build_request(
            resource_group_name=resource_group_name,
            name=name,
            environment_name=environment_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_delete_static_site_build(
        self, resource_group_name: str, name: str, environment_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes a static site build.

        Description for Deletes a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_static_site_build_initial(
                resource_group_name=resource_group_name,
                name=name,
                environment_name=environment_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @overload
    async def create_or_update_static_site_build_app_settings(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        environment_name: str,
        app_settings: _models.StringDictionary,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Creates or updates the app settings of a static site build.

        Description for Creates or updates the app settings of a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :param app_settings: The dictionary containing the static site app settings to update.
         Required.
        :type app_settings: ~azure.mgmt.web.v2022_09_01.models.StringDictionary
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_static_site_build_app_settings(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        environment_name: str,
        app_settings: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Creates or updates the app settings of a static site build.

        Description for Creates or updates the app settings of a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :param app_settings: The dictionary containing the static site app settings to update.
         Required.
        :type app_settings: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_static_site_build_app_settings(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        environment_name: str,
        app_settings: Union[_models.StringDictionary, IO[bytes]],
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Creates or updates the app settings of a static site build.

        Description for Creates or updates the app settings of a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :param app_settings: The dictionary containing the static site app settings to update. Is
         either a StringDictionary type or a IO[bytes] type. Required.
        :type app_settings: ~azure.mgmt.web.v2022_09_01.models.StringDictionary or IO[bytes]
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StringDictionary] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(app_settings, (IOBase, bytes)):
            _content = app_settings
        else:
            _json = self._serialize.body(app_settings, "StringDictionary")

        _request = build_create_or_update_static_site_build_app_settings_request(
            resource_group_name=resource_group_name,
            name=name,
            environment_name=environment_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StringDictionary", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_or_update_static_site_build_function_app_settings(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        environment_name: str,
        app_settings: _models.StringDictionary,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Creates or updates the function app settings of a static site build.

        Description for Creates or updates the function app settings of a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :param app_settings: The dictionary containing the static site function app settings to update.
         Required.
        :type app_settings: ~azure.mgmt.web.v2022_09_01.models.StringDictionary
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_static_site_build_function_app_settings(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        environment_name: str,
        app_settings: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Creates or updates the function app settings of a static site build.

        Description for Creates or updates the function app settings of a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :param app_settings: The dictionary containing the static site function app settings to update.
         Required.
        :type app_settings: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_static_site_build_function_app_settings(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        environment_name: str,
        app_settings: Union[_models.StringDictionary, IO[bytes]],
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Creates or updates the function app settings of a static site build.

        Description for Creates or updates the function app settings of a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :param app_settings: The dictionary containing the static site function app settings to update.
         Is either a StringDictionary type or a IO[bytes] type. Required.
        :type app_settings: ~azure.mgmt.web.v2022_09_01.models.StringDictionary or IO[bytes]
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StringDictionary] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(app_settings, (IOBase, bytes)):
            _content = app_settings
        else:
            _json = self._serialize.body(app_settings, "StringDictionary")

        _request = build_create_or_update_static_site_build_function_app_settings_request(
            resource_group_name=resource_group_name,
            name=name,
            environment_name=environment_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StringDictionary", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_build_database_connections(
        self, resource_group_name: str, name: str, environment_name: str, **kwargs: Any
    ) -> AsyncItemPaged["_models.DatabaseConnection"]:
        """Returns overviews of database connections for a static site build.

        Returns overviews of database connections for a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :return: An iterator like instance of either DatabaseConnection or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2022_09_01.models.DatabaseConnection]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.DatabaseConnectionCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_get_build_database_connections_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    environment_name=environment_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DatabaseConnectionCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_build_database_connection(
        self, resource_group_name: str, name: str, environment_name: str, database_connection_name: str, **kwargs: Any
    ) -> _models.DatabaseConnection:
        """Returns overview of a database connection for a static site build by name.

        Returns overview of a database connection for a static site build by name.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :param database_connection_name: Name of the database connection. Required.
        :type database_connection_name: str
        :return: DatabaseConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.DatabaseConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.DatabaseConnection] = kwargs.pop("cls", None)

        _request = build_get_build_database_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            environment_name=environment_name,
            database_connection_name=database_connection_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DatabaseConnection", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_or_update_build_database_connection(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        environment_name: str,
        database_connection_name: str,
        database_connection_request_envelope: _models.DatabaseConnection,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DatabaseConnection:
        """Create or update a database connection for a static site build.

        Description for Create or update a database connection for a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :param database_connection_name: Name of the database connection. Required.
        :type database_connection_name: str
        :param database_connection_request_envelope: A JSON representation of the database connection
         request properties. Required.
        :type database_connection_request_envelope:
         ~azure.mgmt.web.v2022_09_01.models.DatabaseConnection
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DatabaseConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.DatabaseConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_build_database_connection(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        environment_name: str,
        database_connection_name: str,
        database_connection_request_envelope: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DatabaseConnection:
        """Create or update a database connection for a static site build.

        Description for Create or update a database connection for a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :param database_connection_name: Name of the database connection. Required.
        :type database_connection_name: str
        :param database_connection_request_envelope: A JSON representation of the database connection
         request properties. Required.
        :type database_connection_request_envelope: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DatabaseConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.DatabaseConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_build_database_connection(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        environment_name: str,
        database_connection_name: str,
        database_connection_request_envelope: Union[_models.DatabaseConnection, IO[bytes]],
        **kwargs: Any
    ) -> _models.DatabaseConnection:
        """Create or update a database connection for a static site build.

        Description for Create or update a database connection for a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :param database_connection_name: Name of the database connection. Required.
        :type database_connection_name: str
        :param database_connection_request_envelope: A JSON representation of the database connection
         request properties. Is either a DatabaseConnection type or a IO[bytes] type. Required.
        :type database_connection_request_envelope:
         ~azure.mgmt.web.v2022_09_01.models.DatabaseConnection or IO[bytes]
        :return: DatabaseConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.DatabaseConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DatabaseConnection] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(database_connection_request_envelope, (IOBase, bytes)):
            _content = database_connection_request_envelope
        else:
            _json = self._serialize.body(database_connection_request_envelope, "DatabaseConnection")

        _request = build_create_or_update_build_database_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            environment_name=environment_name,
            database_connection_name=database_connection_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DatabaseConnection", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_build_database_connection(
        self, resource_group_name: str, name: str, environment_name: str, database_connection_name: str, **kwargs: Any
    ) -> None:
        """Delete a database connection for a static site build.

        Delete a database connection for a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :param database_connection_name: Name of the database connection. Required.
        :type database_connection_name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_build_database_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            environment_name=environment_name,
            database_connection_name=database_connection_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def update_build_database_connection(
        self,
        resource_group_name: str,
        name: str,
        environment_name: str,
        database_connection_name: str,
        database_connection_request_envelope: _models.DatabaseConnectionPatchRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DatabaseConnection:
        """Create or update a database connection for a static site build.

        Description for Create or update a database connection for a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :param database_connection_name: Name of the database connection. Required.
        :type database_connection_name: str
        :param database_connection_request_envelope: A JSON representation of the database connection
         request properties. Required.
        :type database_connection_request_envelope:
         ~azure.mgmt.web.v2022_09_01.models.DatabaseConnectionPatchRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DatabaseConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.DatabaseConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_build_database_connection(
        self,
        resource_group_name: str,
        name: str,
        environment_name: str,
        database_connection_name: str,
        database_connection_request_envelope: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DatabaseConnection:
        """Create or update a database connection for a static site build.

        Description for Create or update a database connection for a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :param database_connection_name: Name of the database connection. Required.
        :type database_connection_name: str
        :param database_connection_request_envelope: A JSON representation of the database connection
         request properties. Required.
        :type database_connection_request_envelope: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DatabaseConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.DatabaseConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_build_database_connection(
        self,
        resource_group_name: str,
        name: str,
        environment_name: str,
        database_connection_name: str,
        database_connection_request_envelope: Union[_models.DatabaseConnectionPatchRequest, IO[bytes]],
        **kwargs: Any
    ) -> _models.DatabaseConnection:
        """Create or update a database connection for a static site build.

        Description for Create or update a database connection for a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :param database_connection_name: Name of the database connection. Required.
        :type database_connection_name: str
        :param database_connection_request_envelope: A JSON representation of the database connection
         request properties. Is either a DatabaseConnectionPatchRequest type or a IO[bytes] type.
         Required.
        :type database_connection_request_envelope:
         ~azure.mgmt.web.v2022_09_01.models.DatabaseConnectionPatchRequest or IO[bytes]
        :return: DatabaseConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.DatabaseConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DatabaseConnection] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(database_connection_request_envelope, (IOBase, bytes)):
            _content = database_connection_request_envelope
        else:
            _json = self._serialize.body(database_connection_request_envelope, "DatabaseConnectionPatchRequest")

        _request = build_update_build_database_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            environment_name=environment_name,
            database_connection_name=database_connection_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DatabaseConnection", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_build_database_connection_with_details(  # pylint: disable=name-too-long
        self, resource_group_name: str, name: str, environment_name: str, database_connection_name: str, **kwargs: Any
    ) -> _models.DatabaseConnection:
        """Returns details of a database connection for a static site build by name.

        Returns details of a database connection for a static site build by name.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :param database_connection_name: Name of the database connection. Required.
        :type database_connection_name: str
        :return: DatabaseConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.DatabaseConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.DatabaseConnection] = kwargs.pop("cls", None)

        _request = build_get_build_database_connection_with_details_request(
            resource_group_name=resource_group_name,
            name=name,
            environment_name=environment_name,
            database_connection_name=database_connection_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DatabaseConnection", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_static_site_build_functions(
        self, resource_group_name: str, name: str, environment_name: str, **kwargs: Any
    ) -> AsyncItemPaged["_models.StaticSiteFunctionOverviewARMResource"]:
        """Gets the functions of a particular static site build.

        Description for Gets the functions of a particular static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :return: An iterator like instance of either StaticSiteFunctionOverviewARMResource or the
         result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2022_09_01.models.StaticSiteFunctionOverviewARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.StaticSiteFunctionOverviewCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_static_site_build_functions_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    environment_name=environment_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("StaticSiteFunctionOverviewCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def list_static_site_build_app_settings(
        self, resource_group_name: str, name: str, environment_name: str, **kwargs: Any
    ) -> _models.StringDictionary:
        """Gets the application settings of a static site build.

        Description for Gets the application settings of a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.StringDictionary] = kwargs.pop("cls", None)

        _request = build_list_static_site_build_app_settings_request(
            resource_group_name=resource_group_name,
            name=name,
            environment_name=environment_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StringDictionary", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_static_site_build_function_app_settings(  # pylint: disable=name-too-long
        self, resource_group_name: str, name: str, environment_name: str, **kwargs: Any
    ) -> _models.StringDictionary:
        """Gets the application settings of a static site build.

        Description for Gets the application settings of a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.StringDictionary] = kwargs.pop("cls", None)

        _request = build_list_static_site_build_function_app_settings_request(
            resource_group_name=resource_group_name,
            name=name,
            environment_name=environment_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StringDictionary", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_build_database_connections_with_details(  # pylint: disable=name-too-long
        self, resource_group_name: str, name: str, environment_name: str, **kwargs: Any
    ) -> AsyncItemPaged["_models.DatabaseConnection"]:
        """Returns details of database connections for a static site build.

        Returns details of database connections for a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :return: An iterator like instance of either DatabaseConnection or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2022_09_01.models.DatabaseConnection]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.DatabaseConnectionCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_get_build_database_connections_with_details_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    environment_name=environment_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DatabaseConnectionCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def get_user_provided_function_apps_for_static_site_build(  # pylint: disable=name-too-long
        self, resource_group_name: str, name: str, environment_name: str, **kwargs: Any
    ) -> AsyncItemPaged["_models.StaticSiteUserProvidedFunctionAppARMResource"]:
        """Gets the details of the user provided function apps registered with a static site build.

        Description for Gets the details of the user provided function apps registered with a static
        site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :return: An iterator like instance of either StaticSiteUserProvidedFunctionAppARMResource or
         the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2022_09_01.models.StaticSiteUserProvidedFunctionAppARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.StaticSiteUserProvidedFunctionAppsCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_get_user_provided_function_apps_for_static_site_build_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    environment_name=environment_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("StaticSiteUserProvidedFunctionAppsCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_user_provided_function_app_for_static_site_build(  # pylint: disable=name-too-long
        self, resource_group_name: str, name: str, environment_name: str, function_app_name: str, **kwargs: Any
    ) -> _models.StaticSiteUserProvidedFunctionAppARMResource:
        """Gets the details of the user provided function app registered with a static site build.

        Description for Gets the details of the user provided function app registered with a static
        site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :param function_app_name: Name of the function app registered with the static site build.
         Required.
        :type function_app_name: str
        :return: StaticSiteUserProvidedFunctionAppARMResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StaticSiteUserProvidedFunctionAppARMResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.StaticSiteUserProvidedFunctionAppARMResource] = kwargs.pop("cls", None)

        _request = build_get_user_provided_function_app_for_static_site_build_request(
            resource_group_name=resource_group_name,
            name=name,
            environment_name=environment_name,
            function_app_name=function_app_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize(
            "StaticSiteUserProvidedFunctionAppARMResource", pipeline_response.http_response
        )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _register_user_provided_function_app_with_static_site_build_initial(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        environment_name: str,
        function_app_name: str,
        static_site_user_provided_function_envelope: Union[
            _models.StaticSiteUserProvidedFunctionAppARMResource, IO[bytes]
        ],
        is_forced: Optional[bool] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(static_site_user_provided_function_envelope, (IOBase, bytes)):
            _content = static_site_user_provided_function_envelope
        else:
            _json = self._serialize.body(
                static_site_user_provided_function_envelope, "StaticSiteUserProvidedFunctionAppARMResource"
            )

        _request = build_register_user_provided_function_app_with_static_site_build_request(
            resource_group_name=resource_group_name,
            name=name,
            environment_name=environment_name,
            function_app_name=function_app_name,
            subscription_id=self._config.subscription_id,
            is_forced=is_forced,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_register_user_provided_function_app_with_static_site_build(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        environment_name: str,
        function_app_name: str,
        static_site_user_provided_function_envelope: _models.StaticSiteUserProvidedFunctionAppARMResource,
        is_forced: Optional[bool] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.StaticSiteUserProvidedFunctionAppARMResource]:
        """Register a user provided function app with a static site build.

        Description for Register a user provided function app with a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :param function_app_name: Name of the function app to register with the static site build.
         Required.
        :type function_app_name: str
        :param static_site_user_provided_function_envelope: A JSON representation of the user provided
         function app properties. See example. Required.
        :type static_site_user_provided_function_envelope:
         ~azure.mgmt.web.v2022_09_01.models.StaticSiteUserProvidedFunctionAppARMResource
        :param is_forced: Specify :code:`<code>true</code>` to force the update of the auth
         configuration on the function app even if an AzureStaticWebApps provider is already configured
         on the function app. The default is :code:`<code>false</code>`. Default value is None.
        :type is_forced: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either
         StaticSiteUserProvidedFunctionAppARMResource or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2022_09_01.models.StaticSiteUserProvidedFunctionAppARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_register_user_provided_function_app_with_static_site_build(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        environment_name: str,
        function_app_name: str,
        static_site_user_provided_function_envelope: IO[bytes],
        is_forced: Optional[bool] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.StaticSiteUserProvidedFunctionAppARMResource]:
        """Register a user provided function app with a static site build.

        Description for Register a user provided function app with a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :param function_app_name: Name of the function app to register with the static site build.
         Required.
        :type function_app_name: str
        :param static_site_user_provided_function_envelope: A JSON representation of the user provided
         function app properties. See example. Required.
        :type static_site_user_provided_function_envelope: IO[bytes]
        :param is_forced: Specify :code:`<code>true</code>` to force the update of the auth
         configuration on the function app even if an AzureStaticWebApps provider is already configured
         on the function app. The default is :code:`<code>false</code>`. Default value is None.
        :type is_forced: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either
         StaticSiteUserProvidedFunctionAppARMResource or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2022_09_01.models.StaticSiteUserProvidedFunctionAppARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_register_user_provided_function_app_with_static_site_build(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        environment_name: str,
        function_app_name: str,
        static_site_user_provided_function_envelope: Union[
            _models.StaticSiteUserProvidedFunctionAppARMResource, IO[bytes]
        ],
        is_forced: Optional[bool] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[_models.StaticSiteUserProvidedFunctionAppARMResource]:
        """Register a user provided function app with a static site build.

        Description for Register a user provided function app with a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :param function_app_name: Name of the function app to register with the static site build.
         Required.
        :type function_app_name: str
        :param static_site_user_provided_function_envelope: A JSON representation of the user provided
         function app properties. See example. Is either a StaticSiteUserProvidedFunctionAppARMResource
         type or a IO[bytes] type. Required.
        :type static_site_user_provided_function_envelope:
         ~azure.mgmt.web.v2022_09_01.models.StaticSiteUserProvidedFunctionAppARMResource or IO[bytes]
        :param is_forced: Specify :code:`<code>true</code>` to force the update of the auth
         configuration on the function app even if an AzureStaticWebApps provider is already configured
         on the function app. The default is :code:`<code>false</code>`. Default value is None.
        :type is_forced: bool
        :return: An instance of AsyncLROPoller that returns either
         StaticSiteUserProvidedFunctionAppARMResource or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2022_09_01.models.StaticSiteUserProvidedFunctionAppARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StaticSiteUserProvidedFunctionAppARMResource] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._register_user_provided_function_app_with_static_site_build_initial(
                resource_group_name=resource_group_name,
                name=name,
                environment_name=environment_name,
                function_app_name=function_app_name,
                static_site_user_provided_function_envelope=static_site_user_provided_function_envelope,
                is_forced=is_forced,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize(
                "StaticSiteUserProvidedFunctionAppARMResource", pipeline_response.http_response
            )
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.StaticSiteUserProvidedFunctionAppARMResource].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.StaticSiteUserProvidedFunctionAppARMResource](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace_async
    async def detach_user_provided_function_app_from_static_site_build(  # pylint: disable=name-too-long
        self, resource_group_name: str, name: str, environment_name: str, function_app_name: str, **kwargs: Any
    ) -> None:
        """Detach the user provided function app from the static site build.

        Description for Detach the user provided function app from the static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :param function_app_name: Name of the function app registered with the static site build.
         Required.
        :type function_app_name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_detach_user_provided_function_app_from_static_site_build_request(
            resource_group_name=resource_group_name,
            name=name,
            environment_name=environment_name,
            function_app_name=function_app_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    async def _create_zip_deployment_for_static_site_build_initial(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        environment_name: str,
        static_site_zip_deployment_envelope: Union[_models.StaticSiteZipDeploymentARMResource, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(static_site_zip_deployment_envelope, (IOBase, bytes)):
            _content = static_site_zip_deployment_envelope
        else:
            _json = self._serialize.body(static_site_zip_deployment_envelope, "StaticSiteZipDeploymentARMResource")

        _request = build_create_zip_deployment_for_static_site_build_request(
            resource_group_name=resource_group_name,
            name=name,
            environment_name=environment_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_zip_deployment_for_static_site_build(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        environment_name: str,
        static_site_zip_deployment_envelope: _models.StaticSiteZipDeploymentARMResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deploys zipped content to a specific environment of a static site.

        Description for Deploys zipped content to a specific environment of a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: Name of the environment. Required.
        :type environment_name: str
        :param static_site_zip_deployment_envelope: A JSON representation of the
         StaticSiteZipDeployment properties. See example. Required.
        :type static_site_zip_deployment_envelope:
         ~azure.mgmt.web.v2022_09_01.models.StaticSiteZipDeploymentARMResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_zip_deployment_for_static_site_build(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        environment_name: str,
        static_site_zip_deployment_envelope: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deploys zipped content to a specific environment of a static site.

        Description for Deploys zipped content to a specific environment of a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: Name of the environment. Required.
        :type environment_name: str
        :param static_site_zip_deployment_envelope: A JSON representation of the
         StaticSiteZipDeployment properties. See example. Required.
        :type static_site_zip_deployment_envelope: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_zip_deployment_for_static_site_build(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        environment_name: str,
        static_site_zip_deployment_envelope: Union[_models.StaticSiteZipDeploymentARMResource, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deploys zipped content to a specific environment of a static site.

        Description for Deploys zipped content to a specific environment of a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: Name of the environment. Required.
        :type environment_name: str
        :param static_site_zip_deployment_envelope: A JSON representation of the
         StaticSiteZipDeployment properties. See example. Is either a StaticSiteZipDeploymentARMResource
         type or a IO[bytes] type. Required.
        :type static_site_zip_deployment_envelope:
         ~azure.mgmt.web.v2022_09_01.models.StaticSiteZipDeploymentARMResource or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_zip_deployment_for_static_site_build_initial(
                resource_group_name=resource_group_name,
                name=name,
                environment_name=environment_name,
                static_site_zip_deployment_envelope=static_site_zip_deployment_envelope,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @overload
    async def create_or_update_static_site_app_settings(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        app_settings: _models.StringDictionary,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Creates or updates the app settings of a static site.

        Description for Creates or updates the app settings of a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param app_settings: The dictionary containing the static site app settings to update.
         Required.
        :type app_settings: ~azure.mgmt.web.v2022_09_01.models.StringDictionary
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_static_site_app_settings(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        app_settings: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Creates or updates the app settings of a static site.

        Description for Creates or updates the app settings of a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param app_settings: The dictionary containing the static site app settings to update.
         Required.
        :type app_settings: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_static_site_app_settings(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        app_settings: Union[_models.StringDictionary, IO[bytes]],
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Creates or updates the app settings of a static site.

        Description for Creates or updates the app settings of a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param app_settings: The dictionary containing the static site app settings to update. Is
         either a StringDictionary type or a IO[bytes] type. Required.
        :type app_settings: ~azure.mgmt.web.v2022_09_01.models.StringDictionary or IO[bytes]
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StringDictionary] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(app_settings, (IOBase, bytes)):
            _content = app_settings
        else:
            _json = self._serialize.body(app_settings, "StringDictionary")

        _request = build_create_or_update_static_site_app_settings_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StringDictionary", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_basic_auth(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncItemPaged["_models.StaticSiteBasicAuthPropertiesARMResource"]:
        """Gets the basic auth properties for a static site as a collection.

        Description for Gets the basic auth properties for a static site as a collection.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :return: An iterator like instance of either StaticSiteBasicAuthPropertiesARMResource or the
         result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2022_09_01.models.StaticSiteBasicAuthPropertiesARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.StaticSiteBasicAuthPropertiesCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_basic_auth_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("StaticSiteBasicAuthPropertiesCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_basic_auth(
        self, resource_group_name: str, name: str, basic_auth_name: Union[str, _models.BasicAuthName], **kwargs: Any
    ) -> _models.StaticSiteBasicAuthPropertiesARMResource:
        """Gets the basic auth properties for a static site.

        Description for Gets the basic auth properties for a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param basic_auth_name: name of the basic auth entry. "default" Required.
        :type basic_auth_name: str or ~azure.mgmt.web.v2022_09_01.models.BasicAuthName
        :return: StaticSiteBasicAuthPropertiesARMResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StaticSiteBasicAuthPropertiesARMResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.StaticSiteBasicAuthPropertiesARMResource] = kwargs.pop("cls", None)

        _request = build_get_basic_auth_request(
            resource_group_name=resource_group_name,
            name=name,
            basic_auth_name=basic_auth_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StaticSiteBasicAuthPropertiesARMResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_or_update_basic_auth(
        self,
        resource_group_name: str,
        name: str,
        basic_auth_name: Union[str, _models.BasicAuthName],
        basic_auth_envelope: _models.StaticSiteBasicAuthPropertiesARMResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StaticSiteBasicAuthPropertiesARMResource:
        """Adds or updates basic auth for a static site.

        Description for Adds or updates basic auth for a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param basic_auth_name: name of the basic auth entry. "default" Required.
        :type basic_auth_name: str or ~azure.mgmt.web.v2022_09_01.models.BasicAuthName
        :param basic_auth_envelope: A JSON representation of the basic auth properties. Required.
        :type basic_auth_envelope:
         ~azure.mgmt.web.v2022_09_01.models.StaticSiteBasicAuthPropertiesARMResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StaticSiteBasicAuthPropertiesARMResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StaticSiteBasicAuthPropertiesARMResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_basic_auth(
        self,
        resource_group_name: str,
        name: str,
        basic_auth_name: Union[str, _models.BasicAuthName],
        basic_auth_envelope: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StaticSiteBasicAuthPropertiesARMResource:
        """Adds or updates basic auth for a static site.

        Description for Adds or updates basic auth for a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param basic_auth_name: name of the basic auth entry. "default" Required.
        :type basic_auth_name: str or ~azure.mgmt.web.v2022_09_01.models.BasicAuthName
        :param basic_auth_envelope: A JSON representation of the basic auth properties. Required.
        :type basic_auth_envelope: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StaticSiteBasicAuthPropertiesARMResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StaticSiteBasicAuthPropertiesARMResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_basic_auth(
        self,
        resource_group_name: str,
        name: str,
        basic_auth_name: Union[str, _models.BasicAuthName],
        basic_auth_envelope: Union[_models.StaticSiteBasicAuthPropertiesARMResource, IO[bytes]],
        **kwargs: Any
    ) -> _models.StaticSiteBasicAuthPropertiesARMResource:
        """Adds or updates basic auth for a static site.

        Description for Adds or updates basic auth for a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param basic_auth_name: name of the basic auth entry. "default" Required.
        :type basic_auth_name: str or ~azure.mgmt.web.v2022_09_01.models.BasicAuthName
        :param basic_auth_envelope: A JSON representation of the basic auth properties. Is either a
         StaticSiteBasicAuthPropertiesARMResource type or a IO[bytes] type. Required.
        :type basic_auth_envelope:
         ~azure.mgmt.web.v2022_09_01.models.StaticSiteBasicAuthPropertiesARMResource or IO[bytes]
        :return: StaticSiteBasicAuthPropertiesARMResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StaticSiteBasicAuthPropertiesARMResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StaticSiteBasicAuthPropertiesARMResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(basic_auth_envelope, (IOBase, bytes)):
            _content = basic_auth_envelope
        else:
            _json = self._serialize.body(basic_auth_envelope, "StaticSiteBasicAuthPropertiesARMResource")

        _request = build_create_or_update_basic_auth_request(
            resource_group_name=resource_group_name,
            name=name,
            basic_auth_name=basic_auth_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StaticSiteBasicAuthPropertiesARMResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_or_update_static_site_function_app_settings(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        app_settings: _models.StringDictionary,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Creates or updates the function app settings of a static site.

        Description for Creates or updates the function app settings of a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param app_settings: The dictionary containing the static site function app settings to update.
         Required.
        :type app_settings: ~azure.mgmt.web.v2022_09_01.models.StringDictionary
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_static_site_function_app_settings(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        app_settings: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Creates or updates the function app settings of a static site.

        Description for Creates or updates the function app settings of a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param app_settings: The dictionary containing the static site function app settings to update.
         Required.
        :type app_settings: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_static_site_function_app_settings(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        app_settings: Union[_models.StringDictionary, IO[bytes]],
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Creates or updates the function app settings of a static site.

        Description for Creates or updates the function app settings of a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param app_settings: The dictionary containing the static site function app settings to update.
         Is either a StringDictionary type or a IO[bytes] type. Required.
        :type app_settings: ~azure.mgmt.web.v2022_09_01.models.StringDictionary or IO[bytes]
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StringDictionary] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(app_settings, (IOBase, bytes)):
            _content = app_settings
        else:
            _json = self._serialize.body(app_settings, "StringDictionary")

        _request = build_create_or_update_static_site_function_app_settings_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StringDictionary", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_user_roles_invitation_link(
        self,
        resource_group_name: str,
        name: str,
        static_site_user_roles_invitation_envelope: _models.StaticSiteUserInvitationRequestResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StaticSiteUserInvitationResponseResource:
        """Creates an invitation link for a user with the role.

        Description for Creates an invitation link for a user with the role.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param static_site_user_roles_invitation_envelope: Required.
        :type static_site_user_roles_invitation_envelope:
         ~azure.mgmt.web.v2022_09_01.models.StaticSiteUserInvitationRequestResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StaticSiteUserInvitationResponseResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StaticSiteUserInvitationResponseResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_user_roles_invitation_link(
        self,
        resource_group_name: str,
        name: str,
        static_site_user_roles_invitation_envelope: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StaticSiteUserInvitationResponseResource:
        """Creates an invitation link for a user with the role.

        Description for Creates an invitation link for a user with the role.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param static_site_user_roles_invitation_envelope: Required.
        :type static_site_user_roles_invitation_envelope: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StaticSiteUserInvitationResponseResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StaticSiteUserInvitationResponseResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_user_roles_invitation_link(
        self,
        resource_group_name: str,
        name: str,
        static_site_user_roles_invitation_envelope: Union[_models.StaticSiteUserInvitationRequestResource, IO[bytes]],
        **kwargs: Any
    ) -> _models.StaticSiteUserInvitationResponseResource:
        """Creates an invitation link for a user with the role.

        Description for Creates an invitation link for a user with the role.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param static_site_user_roles_invitation_envelope: Is either a
         StaticSiteUserInvitationRequestResource type or a IO[bytes] type. Required.
        :type static_site_user_roles_invitation_envelope:
         ~azure.mgmt.web.v2022_09_01.models.StaticSiteUserInvitationRequestResource or IO[bytes]
        :return: StaticSiteUserInvitationResponseResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StaticSiteUserInvitationResponseResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StaticSiteUserInvitationResponseResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(static_site_user_roles_invitation_envelope, (IOBase, bytes)):
            _content = static_site_user_roles_invitation_envelope
        else:
            _json = self._serialize.body(
                static_site_user_roles_invitation_envelope, "StaticSiteUserInvitationRequestResource"
            )

        _request = build_create_user_roles_invitation_link_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StaticSiteUserInvitationResponseResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_static_site_custom_domains(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncItemPaged["_models.StaticSiteCustomDomainOverviewARMResource"]:
        """Gets all static site custom domains for a particular static site.

        Description for Gets all static site custom domains for a particular static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site resource to search in. Required.
        :type name: str
        :return: An iterator like instance of either StaticSiteCustomDomainOverviewARMResource or the
         result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2022_09_01.models.StaticSiteCustomDomainOverviewARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.StaticSiteCustomDomainOverviewCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_static_site_custom_domains_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("StaticSiteCustomDomainOverviewCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_static_site_custom_domain(
        self, resource_group_name: str, name: str, domain_name: str, **kwargs: Any
    ) -> _models.StaticSiteCustomDomainOverviewARMResource:
        """Gets an existing custom domain for a particular static site.

        Description for Gets an existing custom domain for a particular static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site resource to search in. Required.
        :type name: str
        :param domain_name: The custom domain name. Required.
        :type domain_name: str
        :return: StaticSiteCustomDomainOverviewARMResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StaticSiteCustomDomainOverviewARMResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.StaticSiteCustomDomainOverviewARMResource] = kwargs.pop("cls", None)

        _request = build_get_static_site_custom_domain_request(
            resource_group_name=resource_group_name,
            name=name,
            domain_name=domain_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StaticSiteCustomDomainOverviewARMResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_or_update_static_site_custom_domain_initial(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        domain_name: str,
        static_site_custom_domain_request_properties_envelope: Union[
            _models.StaticSiteCustomDomainRequestPropertiesARMResource, IO[bytes]
        ],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(static_site_custom_domain_request_properties_envelope, (IOBase, bytes)):
            _content = static_site_custom_domain_request_properties_envelope
        else:
            _json = self._serialize.body(
                static_site_custom_domain_request_properties_envelope,
                "StaticSiteCustomDomainRequestPropertiesARMResource",
            )

        _request = build_create_or_update_static_site_custom_domain_request(
            resource_group_name=resource_group_name,
            name=name,
            domain_name=domain_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update_static_site_custom_domain(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        domain_name: str,
        static_site_custom_domain_request_properties_envelope: _models.StaticSiteCustomDomainRequestPropertiesARMResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.StaticSiteCustomDomainOverviewARMResource]:
        """Creates a new static site custom domain in an existing resource group and static site.

        Description for Creates a new static site custom domain in an existing resource group and
        static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param domain_name: The custom domain to create. Required.
        :type domain_name: str
        :param static_site_custom_domain_request_properties_envelope: A JSON representation of the
         static site custom domain request properties. See example. Required.
        :type static_site_custom_domain_request_properties_envelope:
         ~azure.mgmt.web.v2022_09_01.models.StaticSiteCustomDomainRequestPropertiesARMResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either
         StaticSiteCustomDomainOverviewARMResource or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2022_09_01.models.StaticSiteCustomDomainOverviewARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update_static_site_custom_domain(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        domain_name: str,
        static_site_custom_domain_request_properties_envelope: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.StaticSiteCustomDomainOverviewARMResource]:
        """Creates a new static site custom domain in an existing resource group and static site.

        Description for Creates a new static site custom domain in an existing resource group and
        static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param domain_name: The custom domain to create. Required.
        :type domain_name: str
        :param static_site_custom_domain_request_properties_envelope: A JSON representation of the
         static site custom domain request properties. See example. Required.
        :type static_site_custom_domain_request_properties_envelope: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either
         StaticSiteCustomDomainOverviewARMResource or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2022_09_01.models.StaticSiteCustomDomainOverviewARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update_static_site_custom_domain(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        domain_name: str,
        static_site_custom_domain_request_properties_envelope: Union[
            _models.StaticSiteCustomDomainRequestPropertiesARMResource, IO[bytes]
        ],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.StaticSiteCustomDomainOverviewARMResource]:
        """Creates a new static site custom domain in an existing resource group and static site.

        Description for Creates a new static site custom domain in an existing resource group and
        static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param domain_name: The custom domain to create. Required.
        :type domain_name: str
        :param static_site_custom_domain_request_properties_envelope: A JSON representation of the
         static site custom domain request properties. See example. Is either a
         StaticSiteCustomDomainRequestPropertiesARMResource type or a IO[bytes] type. Required.
        :type static_site_custom_domain_request_properties_envelope:
         ~azure.mgmt.web.v2022_09_01.models.StaticSiteCustomDomainRequestPropertiesARMResource or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns either
         StaticSiteCustomDomainOverviewARMResource or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2022_09_01.models.StaticSiteCustomDomainOverviewARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StaticSiteCustomDomainOverviewARMResource] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_static_site_custom_domain_initial(
                resource_group_name=resource_group_name,
                name=name,
                domain_name=domain_name,
                static_site_custom_domain_request_properties_envelope=static_site_custom_domain_request_properties_envelope,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize(
                "StaticSiteCustomDomainOverviewARMResource", pipeline_response.http_response
            )
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.StaticSiteCustomDomainOverviewARMResource].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.StaticSiteCustomDomainOverviewARMResource](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _delete_static_site_custom_domain_initial(  # pylint: disable=name-too-long
        self, resource_group_name: str, name: str, domain_name: str, **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_delete_static_site_custom_domain_request(
            resource_group_name=resource_group_name,
            name=name,
            domain_name=domain_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_delete_static_site_custom_domain(
        self, resource_group_name: str, name: str, domain_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes a custom domain.

        Description for Deletes a custom domain.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param domain_name: The custom domain to delete. Required.
        :type domain_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_static_site_custom_domain_initial(
                resource_group_name=resource_group_name,
                name=name,
                domain_name=domain_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _validate_custom_domain_can_be_added_to_static_site_initial(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        domain_name: str,
        static_site_custom_domain_request_properties_envelope: Union[
            _models.StaticSiteCustomDomainRequestPropertiesARMResource, IO[bytes]
        ],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(static_site_custom_domain_request_properties_envelope, (IOBase, bytes)):
            _content = static_site_custom_domain_request_properties_envelope
        else:
            _json = self._serialize.body(
                static_site_custom_domain_request_properties_envelope,
                "StaticSiteCustomDomainRequestPropertiesARMResource",
            )

        _request = build_validate_custom_domain_can_be_added_to_static_site_request(
            resource_group_name=resource_group_name,
            name=name,
            domain_name=domain_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_validate_custom_domain_can_be_added_to_static_site(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        domain_name: str,
        static_site_custom_domain_request_properties_envelope: _models.StaticSiteCustomDomainRequestPropertiesARMResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Validates a particular custom domain can be added to a static site.

        Description for Validates a particular custom domain can be added to a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param domain_name: The custom domain to validate. Required.
        :type domain_name: str
        :param static_site_custom_domain_request_properties_envelope: A JSON representation of the
         static site custom domain request properties. See example. Required.
        :type static_site_custom_domain_request_properties_envelope:
         ~azure.mgmt.web.v2022_09_01.models.StaticSiteCustomDomainRequestPropertiesARMResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_validate_custom_domain_can_be_added_to_static_site(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        domain_name: str,
        static_site_custom_domain_request_properties_envelope: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Validates a particular custom domain can be added to a static site.

        Description for Validates a particular custom domain can be added to a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param domain_name: The custom domain to validate. Required.
        :type domain_name: str
        :param static_site_custom_domain_request_properties_envelope: A JSON representation of the
         static site custom domain request properties. See example. Required.
        :type static_site_custom_domain_request_properties_envelope: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_validate_custom_domain_can_be_added_to_static_site(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        domain_name: str,
        static_site_custom_domain_request_properties_envelope: Union[
            _models.StaticSiteCustomDomainRequestPropertiesARMResource, IO[bytes]
        ],
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Validates a particular custom domain can be added to a static site.

        Description for Validates a particular custom domain can be added to a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param domain_name: The custom domain to validate. Required.
        :type domain_name: str
        :param static_site_custom_domain_request_properties_envelope: A JSON representation of the
         static site custom domain request properties. See example. Is either a
         StaticSiteCustomDomainRequestPropertiesARMResource type or a IO[bytes] type. Required.
        :type static_site_custom_domain_request_properties_envelope:
         ~azure.mgmt.web.v2022_09_01.models.StaticSiteCustomDomainRequestPropertiesARMResource or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._validate_custom_domain_can_be_added_to_static_site_initial(
                resource_group_name=resource_group_name,
                name=name,
                domain_name=domain_name,
                static_site_custom_domain_request_properties_envelope=static_site_custom_domain_request_properties_envelope,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace
    def get_database_connections(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncItemPaged["_models.DatabaseConnection"]:
        """Returns overviews of database connections for a static site.

        Returns overviews of database connections for a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :return: An iterator like instance of either DatabaseConnection or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2022_09_01.models.DatabaseConnection]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.DatabaseConnectionCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_get_database_connections_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DatabaseConnectionCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_database_connection(
        self, resource_group_name: str, name: str, database_connection_name: str, **kwargs: Any
    ) -> _models.DatabaseConnection:
        """Returns overview of a database connection for a static site by name.

        Returns overview of a database connection for a static site by name.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param database_connection_name: Name of the database connection. Required.
        :type database_connection_name: str
        :return: DatabaseConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.DatabaseConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.DatabaseConnection] = kwargs.pop("cls", None)

        _request = build_get_database_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            database_connection_name=database_connection_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DatabaseConnection", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_or_update_database_connection(
        self,
        resource_group_name: str,
        name: str,
        database_connection_name: str,
        database_connection_request_envelope: _models.DatabaseConnection,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DatabaseConnection:
        """Create or update a database connection for a static site.

        Description for Create or update a database connection for a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param database_connection_name: Name of the database connection. Required.
        :type database_connection_name: str
        :param database_connection_request_envelope: A JSON representation of the database connection
         request properties. Required.
        :type database_connection_request_envelope:
         ~azure.mgmt.web.v2022_09_01.models.DatabaseConnection
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DatabaseConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.DatabaseConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_database_connection(
        self,
        resource_group_name: str,
        name: str,
        database_connection_name: str,
        database_connection_request_envelope: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DatabaseConnection:
        """Create or update a database connection for a static site.

        Description for Create or update a database connection for a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param database_connection_name: Name of the database connection. Required.
        :type database_connection_name: str
        :param database_connection_request_envelope: A JSON representation of the database connection
         request properties. Required.
        :type database_connection_request_envelope: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DatabaseConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.DatabaseConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_database_connection(
        self,
        resource_group_name: str,
        name: str,
        database_connection_name: str,
        database_connection_request_envelope: Union[_models.DatabaseConnection, IO[bytes]],
        **kwargs: Any
    ) -> _models.DatabaseConnection:
        """Create or update a database connection for a static site.

        Description for Create or update a database connection for a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param database_connection_name: Name of the database connection. Required.
        :type database_connection_name: str
        :param database_connection_request_envelope: A JSON representation of the database connection
         request properties. Is either a DatabaseConnection type or a IO[bytes] type. Required.
        :type database_connection_request_envelope:
         ~azure.mgmt.web.v2022_09_01.models.DatabaseConnection or IO[bytes]
        :return: DatabaseConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.DatabaseConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DatabaseConnection] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(database_connection_request_envelope, (IOBase, bytes)):
            _content = database_connection_request_envelope
        else:
            _json = self._serialize.body(database_connection_request_envelope, "DatabaseConnection")

        _request = build_create_or_update_database_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            database_connection_name=database_connection_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DatabaseConnection", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_database_connection(
        self, resource_group_name: str, name: str, database_connection_name: str, **kwargs: Any
    ) -> None:
        """Delete a database connection for a static site.

        Delete a database connection for a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param database_connection_name: Name of the database connection. Required.
        :type database_connection_name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_database_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            database_connection_name=database_connection_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def update_database_connection(
        self,
        resource_group_name: str,
        name: str,
        database_connection_name: str,
        database_connection_request_envelope: _models.DatabaseConnectionPatchRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DatabaseConnection:
        """Create or update a database connection for a static site.

        Description for Create or update a database connection for a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param database_connection_name: Name of the database connection. Required.
        :type database_connection_name: str
        :param database_connection_request_envelope: A JSON representation of the database connection
         request properties. Required.
        :type database_connection_request_envelope:
         ~azure.mgmt.web.v2022_09_01.models.DatabaseConnectionPatchRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DatabaseConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.DatabaseConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_database_connection(
        self,
        resource_group_name: str,
        name: str,
        database_connection_name: str,
        database_connection_request_envelope: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DatabaseConnection:
        """Create or update a database connection for a static site.

        Description for Create or update a database connection for a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param database_connection_name: Name of the database connection. Required.
        :type database_connection_name: str
        :param database_connection_request_envelope: A JSON representation of the database connection
         request properties. Required.
        :type database_connection_request_envelope: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DatabaseConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.DatabaseConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_database_connection(
        self,
        resource_group_name: str,
        name: str,
        database_connection_name: str,
        database_connection_request_envelope: Union[_models.DatabaseConnectionPatchRequest, IO[bytes]],
        **kwargs: Any
    ) -> _models.DatabaseConnection:
        """Create or update a database connection for a static site.

        Description for Create or update a database connection for a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param database_connection_name: Name of the database connection. Required.
        :type database_connection_name: str
        :param database_connection_request_envelope: A JSON representation of the database connection
         request properties. Is either a DatabaseConnectionPatchRequest type or a IO[bytes] type.
         Required.
        :type database_connection_request_envelope:
         ~azure.mgmt.web.v2022_09_01.models.DatabaseConnectionPatchRequest or IO[bytes]
        :return: DatabaseConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.DatabaseConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DatabaseConnection] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(database_connection_request_envelope, (IOBase, bytes)):
            _content = database_connection_request_envelope
        else:
            _json = self._serialize.body(database_connection_request_envelope, "DatabaseConnectionPatchRequest")

        _request = build_update_database_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            database_connection_name=database_connection_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DatabaseConnection", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_database_connection_with_details(
        self, resource_group_name: str, name: str, database_connection_name: str, **kwargs: Any
    ) -> _models.DatabaseConnection:
        """Returns details of a database connection for a static site by name.

        Returns details of a database connection for a static site by name.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param database_connection_name: Name of the database connection. Required.
        :type database_connection_name: str
        :return: DatabaseConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.DatabaseConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.DatabaseConnection] = kwargs.pop("cls", None)

        _request = build_get_database_connection_with_details_request(
            resource_group_name=resource_group_name,
            name=name,
            database_connection_name=database_connection_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DatabaseConnection", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _detach_static_site_initial(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_detach_static_site_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_detach_static_site(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Detaches a static site.

        Description for Detaches a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site to detach. Required.
        :type name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._detach_static_site_initial(
                resource_group_name=resource_group_name,
                name=name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace
    def list_static_site_functions(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncItemPaged["_models.StaticSiteFunctionOverviewARMResource"]:
        """Gets the functions of a static site.

        Description for Gets the functions of a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :return: An iterator like instance of either StaticSiteFunctionOverviewARMResource or the
         result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2022_09_01.models.StaticSiteFunctionOverviewARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.StaticSiteFunctionOverviewCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_static_site_functions_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("StaticSiteFunctionOverviewCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def list_static_site_app_settings(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.StringDictionary:
        """Gets the application settings of a static site.

        Description for Gets the application settings of a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.StringDictionary] = kwargs.pop("cls", None)

        _request = build_list_static_site_app_settings_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StringDictionary", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_static_site_configured_roles(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.StringList:
        """Lists the roles configured for the static site.

        Description for Lists the roles configured for the static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :return: StringList or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StringList
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.StringList] = kwargs.pop("cls", None)

        _request = build_list_static_site_configured_roles_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StringList", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_static_site_function_app_settings(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.StringDictionary:
        """Gets the application settings of a static site.

        Description for Gets the application settings of a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.StringDictionary] = kwargs.pop("cls", None)

        _request = build_list_static_site_function_app_settings_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StringDictionary", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_static_site_secrets(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.StringDictionary:
        """Lists the secrets for an existing static site.

        Description for Lists the secrets for an existing static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.StringDictionary] = kwargs.pop("cls", None)

        _request = build_list_static_site_secrets_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StringDictionary", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_private_endpoint_connection_list(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncItemPaged["_models.RemotePrivateEndpointConnectionARMResource"]:
        """Gets the list of private endpoint connections associated with a static site.

        Description for Gets the list of private endpoint connections associated with a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :return: An iterator like instance of either RemotePrivateEndpointConnectionARMResource or the
         result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2022_09_01.models.RemotePrivateEndpointConnectionARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.PrivateEndpointConnectionCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_get_private_endpoint_connection_list_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PrivateEndpointConnectionCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_private_endpoint_connection(
        self, resource_group_name: str, name: str, private_endpoint_connection_name: str, **kwargs: Any
    ) -> _models.RemotePrivateEndpointConnectionARMResource:
        """Gets a private endpoint connection.

        Description for Gets a private endpoint connection.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param private_endpoint_connection_name: Name of the private endpoint connection. Required.
        :type private_endpoint_connection_name: str
        :return: RemotePrivateEndpointConnectionARMResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.RemotePrivateEndpointConnectionARMResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.RemotePrivateEndpointConnectionARMResource] = kwargs.pop("cls", None)

        _request = build_get_private_endpoint_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            private_endpoint_connection_name=private_endpoint_connection_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RemotePrivateEndpointConnectionARMResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _approve_or_reject_private_endpoint_connection_initial(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        private_endpoint_connection_name: str,
        private_endpoint_wrapper: Union[_models.RemotePrivateEndpointConnectionARMResource, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(private_endpoint_wrapper, (IOBase, bytes)):
            _content = private_endpoint_wrapper
        else:
            _json = self._serialize.body(private_endpoint_wrapper, "RemotePrivateEndpointConnectionARMResource")

        _request = build_approve_or_reject_private_endpoint_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            private_endpoint_connection_name=private_endpoint_connection_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_approve_or_reject_private_endpoint_connection(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        private_endpoint_connection_name: str,
        private_endpoint_wrapper: _models.RemotePrivateEndpointConnectionARMResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RemotePrivateEndpointConnectionARMResource]:
        """Approves or rejects a private endpoint connection.

        Description for Approves or rejects a private endpoint connection.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param private_endpoint_connection_name: Name of the private endpoint connection. Required.
        :type private_endpoint_connection_name: str
        :param private_endpoint_wrapper: Request body. Required.
        :type private_endpoint_wrapper:
         ~azure.mgmt.web.v2022_09_01.models.RemotePrivateEndpointConnectionARMResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either
         RemotePrivateEndpointConnectionARMResource or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2022_09_01.models.RemotePrivateEndpointConnectionARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_approve_or_reject_private_endpoint_connection(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        private_endpoint_connection_name: str,
        private_endpoint_wrapper: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RemotePrivateEndpointConnectionARMResource]:
        """Approves or rejects a private endpoint connection.

        Description for Approves or rejects a private endpoint connection.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param private_endpoint_connection_name: Name of the private endpoint connection. Required.
        :type private_endpoint_connection_name: str
        :param private_endpoint_wrapper: Request body. Required.
        :type private_endpoint_wrapper: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either
         RemotePrivateEndpointConnectionARMResource or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2022_09_01.models.RemotePrivateEndpointConnectionARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_approve_or_reject_private_endpoint_connection(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        private_endpoint_connection_name: str,
        private_endpoint_wrapper: Union[_models.RemotePrivateEndpointConnectionARMResource, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RemotePrivateEndpointConnectionARMResource]:
        """Approves or rejects a private endpoint connection.

        Description for Approves or rejects a private endpoint connection.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param private_endpoint_connection_name: Name of the private endpoint connection. Required.
        :type private_endpoint_connection_name: str
        :param private_endpoint_wrapper: Request body. Is either a
         RemotePrivateEndpointConnectionARMResource type or a IO[bytes] type. Required.
        :type private_endpoint_wrapper:
         ~azure.mgmt.web.v2022_09_01.models.RemotePrivateEndpointConnectionARMResource or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either
         RemotePrivateEndpointConnectionARMResource or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2022_09_01.models.RemotePrivateEndpointConnectionARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RemotePrivateEndpointConnectionARMResource] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._approve_or_reject_private_endpoint_connection_initial(
                resource_group_name=resource_group_name,
                name=name,
                private_endpoint_connection_name=private_endpoint_connection_name,
                private_endpoint_wrapper=private_endpoint_wrapper,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize(
                "RemotePrivateEndpointConnectionARMResource", pipeline_response.http_response
            )
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.RemotePrivateEndpointConnectionARMResource].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.RemotePrivateEndpointConnectionARMResource](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _delete_private_endpoint_connection_initial(  # pylint: disable=name-too-long
        self, resource_group_name: str, name: str, private_endpoint_connection_name: str, **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_delete_private_endpoint_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            private_endpoint_connection_name=private_endpoint_connection_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_delete_private_endpoint_connection(
        self, resource_group_name: str, name: str, private_endpoint_connection_name: str, **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Deletes a private endpoint connection.

        Description for Deletes a private endpoint connection.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param private_endpoint_connection_name: Name of the private endpoint connection. Required.
        :type private_endpoint_connection_name: str
        :return: An instance of AsyncLROPoller that returns either JSON or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[JSON] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_private_endpoint_connection_initial(
                resource_group_name=resource_group_name,
                name=name,
                private_endpoint_connection_name=private_endpoint_connection_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("object", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[JSON].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[JSON](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def get_private_link_resources(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.PrivateLinkResourcesWrapper:
        """Gets the private link resources.

        Description for Gets the private link resources.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the site. Required.
        :type name: str
        :return: PrivateLinkResourcesWrapper or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.PrivateLinkResourcesWrapper
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.PrivateLinkResourcesWrapper] = kwargs.pop("cls", None)

        _request = build_get_private_link_resources_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("PrivateLinkResourcesWrapper", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def reset_static_site_api_key(
        self,
        resource_group_name: str,
        name: str,
        reset_properties_envelope: _models.StaticSiteResetPropertiesARMResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Resets the api key for an existing static site.

        Description for Resets the api key for an existing static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param reset_properties_envelope: Required.
        :type reset_properties_envelope:
         ~azure.mgmt.web.v2022_09_01.models.StaticSiteResetPropertiesARMResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def reset_static_site_api_key(
        self,
        resource_group_name: str,
        name: str,
        reset_properties_envelope: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Resets the api key for an existing static site.

        Description for Resets the api key for an existing static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param reset_properties_envelope: Required.
        :type reset_properties_envelope: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def reset_static_site_api_key(
        self,
        resource_group_name: str,
        name: str,
        reset_properties_envelope: Union[_models.StaticSiteResetPropertiesARMResource, IO[bytes]],
        **kwargs: Any
    ) -> None:
        """Resets the api key for an existing static site.

        Description for Resets the api key for an existing static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param reset_properties_envelope: Is either a StaticSiteResetPropertiesARMResource type or a
         IO[bytes] type. Required.
        :type reset_properties_envelope:
         ~azure.mgmt.web.v2022_09_01.models.StaticSiteResetPropertiesARMResource or IO[bytes]
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(reset_properties_envelope, (IOBase, bytes)):
            _content = reset_properties_envelope
        else:
            _json = self._serialize.body(reset_properties_envelope, "StaticSiteResetPropertiesARMResource")

        _request = build_reset_static_site_api_key_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace
    def get_database_connections_with_details(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncItemPaged["_models.DatabaseConnection"]:
        """Returns details of database connections for a static site.

        Returns details of database connections for a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :return: An iterator like instance of either DatabaseConnection or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2022_09_01.models.DatabaseConnection]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.DatabaseConnectionCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_get_database_connections_with_details_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DatabaseConnectionCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def get_user_provided_function_apps_for_static_site(  # pylint: disable=name-too-long
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncItemPaged["_models.StaticSiteUserProvidedFunctionAppARMResource"]:
        """Gets the details of the user provided function apps registered with a static site.

        Description for Gets the details of the user provided function apps registered with a static
        site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :return: An iterator like instance of either StaticSiteUserProvidedFunctionAppARMResource or
         the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2022_09_01.models.StaticSiteUserProvidedFunctionAppARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.StaticSiteUserProvidedFunctionAppsCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_get_user_provided_function_apps_for_static_site_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("StaticSiteUserProvidedFunctionAppsCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_user_provided_function_app_for_static_site(  # pylint: disable=name-too-long
        self, resource_group_name: str, name: str, function_app_name: str, **kwargs: Any
    ) -> _models.StaticSiteUserProvidedFunctionAppARMResource:
        """Gets the details of the user provided function app registered with a static site.

        Description for Gets the details of the user provided function app registered with a static
        site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param function_app_name: Name of the function app registered with the static site. Required.
        :type function_app_name: str
        :return: StaticSiteUserProvidedFunctionAppARMResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StaticSiteUserProvidedFunctionAppARMResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.StaticSiteUserProvidedFunctionAppARMResource] = kwargs.pop("cls", None)

        _request = build_get_user_provided_function_app_for_static_site_request(
            resource_group_name=resource_group_name,
            name=name,
            function_app_name=function_app_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize(
            "StaticSiteUserProvidedFunctionAppARMResource", pipeline_response.http_response
        )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _register_user_provided_function_app_with_static_site_initial(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        function_app_name: str,
        static_site_user_provided_function_envelope: Union[
            _models.StaticSiteUserProvidedFunctionAppARMResource, IO[bytes]
        ],
        is_forced: Optional[bool] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(static_site_user_provided_function_envelope, (IOBase, bytes)):
            _content = static_site_user_provided_function_envelope
        else:
            _json = self._serialize.body(
                static_site_user_provided_function_envelope, "StaticSiteUserProvidedFunctionAppARMResource"
            )

        _request = build_register_user_provided_function_app_with_static_site_request(
            resource_group_name=resource_group_name,
            name=name,
            function_app_name=function_app_name,
            subscription_id=self._config.subscription_id,
            is_forced=is_forced,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_register_user_provided_function_app_with_static_site(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        function_app_name: str,
        static_site_user_provided_function_envelope: _models.StaticSiteUserProvidedFunctionAppARMResource,
        is_forced: Optional[bool] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.StaticSiteUserProvidedFunctionAppARMResource]:
        """Register a user provided function app with a static site.

        Description for Register a user provided function app with a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param function_app_name: Name of the function app to register with the static site. Required.
        :type function_app_name: str
        :param static_site_user_provided_function_envelope: A JSON representation of the user provided
         function app properties. See example. Required.
        :type static_site_user_provided_function_envelope:
         ~azure.mgmt.web.v2022_09_01.models.StaticSiteUserProvidedFunctionAppARMResource
        :param is_forced: Specify :code:`<code>true</code>` to force the update of the auth
         configuration on the function app even if an AzureStaticWebApps provider is already configured
         on the function app. The default is :code:`<code>false</code>`. Default value is None.
        :type is_forced: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either
         StaticSiteUserProvidedFunctionAppARMResource or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2022_09_01.models.StaticSiteUserProvidedFunctionAppARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_register_user_provided_function_app_with_static_site(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        function_app_name: str,
        static_site_user_provided_function_envelope: IO[bytes],
        is_forced: Optional[bool] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.StaticSiteUserProvidedFunctionAppARMResource]:
        """Register a user provided function app with a static site.

        Description for Register a user provided function app with a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param function_app_name: Name of the function app to register with the static site. Required.
        :type function_app_name: str
        :param static_site_user_provided_function_envelope: A JSON representation of the user provided
         function app properties. See example. Required.
        :type static_site_user_provided_function_envelope: IO[bytes]
        :param is_forced: Specify :code:`<code>true</code>` to force the update of the auth
         configuration on the function app even if an AzureStaticWebApps provider is already configured
         on the function app. The default is :code:`<code>false</code>`. Default value is None.
        :type is_forced: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either
         StaticSiteUserProvidedFunctionAppARMResource or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2022_09_01.models.StaticSiteUserProvidedFunctionAppARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_register_user_provided_function_app_with_static_site(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        function_app_name: str,
        static_site_user_provided_function_envelope: Union[
            _models.StaticSiteUserProvidedFunctionAppARMResource, IO[bytes]
        ],
        is_forced: Optional[bool] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[_models.StaticSiteUserProvidedFunctionAppARMResource]:
        """Register a user provided function app with a static site.

        Description for Register a user provided function app with a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param function_app_name: Name of the function app to register with the static site. Required.
        :type function_app_name: str
        :param static_site_user_provided_function_envelope: A JSON representation of the user provided
         function app properties. See example. Is either a StaticSiteUserProvidedFunctionAppARMResource
         type or a IO[bytes] type. Required.
        :type static_site_user_provided_function_envelope:
         ~azure.mgmt.web.v2022_09_01.models.StaticSiteUserProvidedFunctionAppARMResource or IO[bytes]
        :param is_forced: Specify :code:`<code>true</code>` to force the update of the auth
         configuration on the function app even if an AzureStaticWebApps provider is already configured
         on the function app. The default is :code:`<code>false</code>`. Default value is None.
        :type is_forced: bool
        :return: An instance of AsyncLROPoller that returns either
         StaticSiteUserProvidedFunctionAppARMResource or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2022_09_01.models.StaticSiteUserProvidedFunctionAppARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StaticSiteUserProvidedFunctionAppARMResource] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._register_user_provided_function_app_with_static_site_initial(
                resource_group_name=resource_group_name,
                name=name,
                function_app_name=function_app_name,
                static_site_user_provided_function_envelope=static_site_user_provided_function_envelope,
                is_forced=is_forced,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize(
                "StaticSiteUserProvidedFunctionAppARMResource", pipeline_response.http_response
            )
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.StaticSiteUserProvidedFunctionAppARMResource].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.StaticSiteUserProvidedFunctionAppARMResource](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace_async
    async def detach_user_provided_function_app_from_static_site(  # pylint: disable=name-too-long
        self, resource_group_name: str, name: str, function_app_name: str, **kwargs: Any
    ) -> None:
        """Detach the user provided function app from the static site.

        Description for Detach the user provided function app from the static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param function_app_name: Name of the function app registered with the static site. Required.
        :type function_app_name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_detach_user_provided_function_app_from_static_site_request(
            resource_group_name=resource_group_name,
            name=name,
            function_app_name=function_app_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    async def _create_zip_deployment_for_static_site_initial(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        static_site_zip_deployment_envelope: Union[_models.StaticSiteZipDeploymentARMResource, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(static_site_zip_deployment_envelope, (IOBase, bytes)):
            _content = static_site_zip_deployment_envelope
        else:
            _json = self._serialize.body(static_site_zip_deployment_envelope, "StaticSiteZipDeploymentARMResource")

        _request = build_create_zip_deployment_for_static_site_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_zip_deployment_for_static_site(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        static_site_zip_deployment_envelope: _models.StaticSiteZipDeploymentARMResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deploys zipped content to a static site.

        Description for Deploys zipped content to a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param static_site_zip_deployment_envelope: A JSON representation of the
         StaticSiteZipDeployment properties. See example. Required.
        :type static_site_zip_deployment_envelope:
         ~azure.mgmt.web.v2022_09_01.models.StaticSiteZipDeploymentARMResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_zip_deployment_for_static_site(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        static_site_zip_deployment_envelope: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deploys zipped content to a static site.

        Description for Deploys zipped content to a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param static_site_zip_deployment_envelope: A JSON representation of the
         StaticSiteZipDeployment properties. See example. Required.
        :type static_site_zip_deployment_envelope: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_zip_deployment_for_static_site(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        name: str,
        static_site_zip_deployment_envelope: Union[_models.StaticSiteZipDeploymentARMResource, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deploys zipped content to a static site.

        Description for Deploys zipped content to a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param static_site_zip_deployment_envelope: A JSON representation of the
         StaticSiteZipDeployment properties. See example. Is either a StaticSiteZipDeploymentARMResource
         type or a IO[bytes] type. Required.
        :type static_site_zip_deployment_envelope:
         ~azure.mgmt.web.v2022_09_01.models.StaticSiteZipDeploymentARMResource or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_zip_deployment_for_static_site_initial(
                resource_group_name=resource_group_name,
                name=name,
                static_site_zip_deployment_envelope=static_site_zip_deployment_envelope,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _validate_backend_initial(
        self,
        resource_group_name: str,
        name: str,
        linked_backend_name: str,
        static_site_linked_backend_envelope: Union[_models.StaticSiteLinkedBackendARMResource, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(static_site_linked_backend_envelope, (IOBase, bytes)):
            _content = static_site_linked_backend_envelope
        else:
            _json = self._serialize.body(static_site_linked_backend_envelope, "StaticSiteLinkedBackendARMResource")

        _request = build_validate_backend_request(
            resource_group_name=resource_group_name,
            name=name,
            linked_backend_name=linked_backend_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202, 204]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_validate_backend(
        self,
        resource_group_name: str,
        name: str,
        linked_backend_name: str,
        static_site_linked_backend_envelope: _models.StaticSiteLinkedBackendARMResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Validates that a backend can be linked to a static site.

        Validates that a backend can be linked to a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param linked_backend_name: Name of the linked backend that should be retrieved. Required.
        :type linked_backend_name: str
        :param static_site_linked_backend_envelope: A JSON representation of the linked backend request
         properties. Required.
        :type static_site_linked_backend_envelope:
         ~azure.mgmt.web.v2022_09_01.models.StaticSiteLinkedBackendARMResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_validate_backend(
        self,
        resource_group_name: str,
        name: str,
        linked_backend_name: str,
        static_site_linked_backend_envelope: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Validates that a backend can be linked to a static site.

        Validates that a backend can be linked to a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param linked_backend_name: Name of the linked backend that should be retrieved. Required.
        :type linked_backend_name: str
        :param static_site_linked_backend_envelope: A JSON representation of the linked backend request
         properties. Required.
        :type static_site_linked_backend_envelope: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_validate_backend(
        self,
        resource_group_name: str,
        name: str,
        linked_backend_name: str,
        static_site_linked_backend_envelope: Union[_models.StaticSiteLinkedBackendARMResource, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Validates that a backend can be linked to a static site.

        Validates that a backend can be linked to a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param linked_backend_name: Name of the linked backend that should be retrieved. Required.
        :type linked_backend_name: str
        :param static_site_linked_backend_envelope: A JSON representation of the linked backend request
         properties. Is either a StaticSiteLinkedBackendARMResource type or a IO[bytes] type. Required.
        :type static_site_linked_backend_envelope:
         ~azure.mgmt.web.v2022_09_01.models.StaticSiteLinkedBackendARMResource or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._validate_backend_initial(
                resource_group_name=resource_group_name,
                name=name,
                linked_backend_name=linked_backend_name,
                static_site_linked_backend_envelope=static_site_linked_backend_envelope,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _validate_backend_for_build_initial(
        self,
        resource_group_name: str,
        name: str,
        environment_name: str,
        linked_backend_name: str,
        static_site_linked_backend_envelope: Union[_models.StaticSiteLinkedBackendARMResource, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(static_site_linked_backend_envelope, (IOBase, bytes)):
            _content = static_site_linked_backend_envelope
        else:
            _json = self._serialize.body(static_site_linked_backend_envelope, "StaticSiteLinkedBackendARMResource")

        _request = build_validate_backend_for_build_request(
            resource_group_name=resource_group_name,
            name=name,
            environment_name=environment_name,
            linked_backend_name=linked_backend_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202, 204]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_validate_backend_for_build(
        self,
        resource_group_name: str,
        name: str,
        environment_name: str,
        linked_backend_name: str,
        static_site_linked_backend_envelope: _models.StaticSiteLinkedBackendARMResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Validates that a backend can be linked to a static site build.

        Validates that a backend can be linked to a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :param linked_backend_name: Name of the linked backend that should be retrieved. Required.
        :type linked_backend_name: str
        :param static_site_linked_backend_envelope: A JSON representation of the linked backend request
         properties. Required.
        :type static_site_linked_backend_envelope:
         ~azure.mgmt.web.v2022_09_01.models.StaticSiteLinkedBackendARMResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_validate_backend_for_build(
        self,
        resource_group_name: str,
        name: str,
        environment_name: str,
        linked_backend_name: str,
        static_site_linked_backend_envelope: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Validates that a backend can be linked to a static site build.

        Validates that a backend can be linked to a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :param linked_backend_name: Name of the linked backend that should be retrieved. Required.
        :type linked_backend_name: str
        :param static_site_linked_backend_envelope: A JSON representation of the linked backend request
         properties. Required.
        :type static_site_linked_backend_envelope: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_validate_backend_for_build(
        self,
        resource_group_name: str,
        name: str,
        environment_name: str,
        linked_backend_name: str,
        static_site_linked_backend_envelope: Union[_models.StaticSiteLinkedBackendARMResource, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Validates that a backend can be linked to a static site build.

        Validates that a backend can be linked to a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :param linked_backend_name: Name of the linked backend that should be retrieved. Required.
        :type linked_backend_name: str
        :param static_site_linked_backend_envelope: A JSON representation of the linked backend request
         properties. Is either a StaticSiteLinkedBackendARMResource type or a IO[bytes] type. Required.
        :type static_site_linked_backend_envelope:
         ~azure.mgmt.web.v2022_09_01.models.StaticSiteLinkedBackendARMResource or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._validate_backend_for_build_initial(
                resource_group_name=resource_group_name,
                name=name,
                environment_name=environment_name,
                linked_backend_name=linked_backend_name,
                static_site_linked_backend_envelope=static_site_linked_backend_envelope,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace
    def get_linked_backends(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncItemPaged["_models.StaticSiteLinkedBackendARMResource"]:
        """Returns details of all backends linked to a static site.

        Returns details of all backends linked to a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :return: An iterator like instance of either StaticSiteLinkedBackendARMResource or the result
         of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2022_09_01.models.StaticSiteLinkedBackendARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.StaticSiteLinkedBackendsCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_get_linked_backends_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("StaticSiteLinkedBackendsCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def get_linked_backends_for_build(
        self, resource_group_name: str, name: str, environment_name: str, **kwargs: Any
    ) -> AsyncItemPaged["_models.StaticSiteLinkedBackendARMResource"]:
        """Returns details of all backends linked to a static site build.

        Returns details of all backends linked to a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :return: An iterator like instance of either StaticSiteLinkedBackendARMResource or the result
         of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2022_09_01.models.StaticSiteLinkedBackendARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.StaticSiteLinkedBackendsCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_get_linked_backends_for_build_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    environment_name=environment_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("StaticSiteLinkedBackendsCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_linked_backend(
        self, resource_group_name: str, name: str, linked_backend_name: str, **kwargs: Any
    ) -> _models.StaticSiteLinkedBackendARMResource:
        """Returns the details of a linked backend linked to a static site by name.

        Returns the details of a linked backend linked to a static site by name.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param linked_backend_name: Name of the linked backend that should be retrieved. Required.
        :type linked_backend_name: str
        :return: StaticSiteLinkedBackendARMResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StaticSiteLinkedBackendARMResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.StaticSiteLinkedBackendARMResource] = kwargs.pop("cls", None)

        _request = build_get_linked_backend_request(
            resource_group_name=resource_group_name,
            name=name,
            linked_backend_name=linked_backend_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StaticSiteLinkedBackendARMResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _link_backend_initial(
        self,
        resource_group_name: str,
        name: str,
        linked_backend_name: str,
        static_site_linked_backend_envelope: Union[_models.StaticSiteLinkedBackendARMResource, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(static_site_linked_backend_envelope, (IOBase, bytes)):
            _content = static_site_linked_backend_envelope
        else:
            _json = self._serialize.body(static_site_linked_backend_envelope, "StaticSiteLinkedBackendARMResource")

        _request = build_link_backend_request(
            resource_group_name=resource_group_name,
            name=name,
            linked_backend_name=linked_backend_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_link_backend(
        self,
        resource_group_name: str,
        name: str,
        linked_backend_name: str,
        static_site_linked_backend_envelope: _models.StaticSiteLinkedBackendARMResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.StaticSiteLinkedBackendARMResource]:
        """Link backend to a static site.

        Link backend to a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param linked_backend_name: Name of the backend to link to the static site. Required.
        :type linked_backend_name: str
        :param static_site_linked_backend_envelope: A JSON representation of the linked backend request
         properties. Required.
        :type static_site_linked_backend_envelope:
         ~azure.mgmt.web.v2022_09_01.models.StaticSiteLinkedBackendARMResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either StaticSiteLinkedBackendARMResource
         or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2022_09_01.models.StaticSiteLinkedBackendARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_link_backend(
        self,
        resource_group_name: str,
        name: str,
        linked_backend_name: str,
        static_site_linked_backend_envelope: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.StaticSiteLinkedBackendARMResource]:
        """Link backend to a static site.

        Link backend to a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param linked_backend_name: Name of the backend to link to the static site. Required.
        :type linked_backend_name: str
        :param static_site_linked_backend_envelope: A JSON representation of the linked backend request
         properties. Required.
        :type static_site_linked_backend_envelope: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either StaticSiteLinkedBackendARMResource
         or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2022_09_01.models.StaticSiteLinkedBackendARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_link_backend(
        self,
        resource_group_name: str,
        name: str,
        linked_backend_name: str,
        static_site_linked_backend_envelope: Union[_models.StaticSiteLinkedBackendARMResource, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.StaticSiteLinkedBackendARMResource]:
        """Link backend to a static site.

        Link backend to a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param linked_backend_name: Name of the backend to link to the static site. Required.
        :type linked_backend_name: str
        :param static_site_linked_backend_envelope: A JSON representation of the linked backend request
         properties. Is either a StaticSiteLinkedBackendARMResource type or a IO[bytes] type. Required.
        :type static_site_linked_backend_envelope:
         ~azure.mgmt.web.v2022_09_01.models.StaticSiteLinkedBackendARMResource or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either StaticSiteLinkedBackendARMResource
         or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2022_09_01.models.StaticSiteLinkedBackendARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StaticSiteLinkedBackendARMResource] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._link_backend_initial(
                resource_group_name=resource_group_name,
                name=name,
                linked_backend_name=linked_backend_name,
                static_site_linked_backend_envelope=static_site_linked_backend_envelope,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("StaticSiteLinkedBackendARMResource", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.StaticSiteLinkedBackendARMResource].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.StaticSiteLinkedBackendARMResource](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace_async
    async def unlink_backend(
        self,
        resource_group_name: str,
        name: str,
        linked_backend_name: str,
        is_cleaning_auth_config: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """Unlink a backend from a static site.

        Unlink a backend from a static site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param linked_backend_name: Name of the backend linked to the static site. Required.
        :type linked_backend_name: str
        :param is_cleaning_auth_config: Decides if Easy Auth configuration will be removed from backend
         configuration. Default value is None.
        :type is_cleaning_auth_config: bool
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_unlink_backend_request(
            resource_group_name=resource_group_name,
            name=name,
            linked_backend_name=linked_backend_name,
            subscription_id=self._config.subscription_id,
            is_cleaning_auth_config=is_cleaning_auth_config,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_linked_backend_for_build(
        self, resource_group_name: str, name: str, environment_name: str, linked_backend_name: str, **kwargs: Any
    ) -> _models.StaticSiteLinkedBackendARMResource:
        """Returns the details of a linked backend linked to a static site build by name.

        Returns the details of a linked backend linked to a static site build by name.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :param linked_backend_name: Name of the linked backend that should be retrieved. Required.
        :type linked_backend_name: str
        :return: StaticSiteLinkedBackendARMResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2022_09_01.models.StaticSiteLinkedBackendARMResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[_models.StaticSiteLinkedBackendARMResource] = kwargs.pop("cls", None)

        _request = build_get_linked_backend_for_build_request(
            resource_group_name=resource_group_name,
            name=name,
            environment_name=environment_name,
            linked_backend_name=linked_backend_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StaticSiteLinkedBackendARMResource", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _link_backend_to_build_initial(
        self,
        resource_group_name: str,
        name: str,
        environment_name: str,
        linked_backend_name: str,
        static_site_linked_backend_envelope: Union[_models.StaticSiteLinkedBackendARMResource, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(static_site_linked_backend_envelope, (IOBase, bytes)):
            _content = static_site_linked_backend_envelope
        else:
            _json = self._serialize.body(static_site_linked_backend_envelope, "StaticSiteLinkedBackendARMResource")

        _request = build_link_backend_to_build_request(
            resource_group_name=resource_group_name,
            name=name,
            environment_name=environment_name,
            linked_backend_name=linked_backend_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_link_backend_to_build(
        self,
        resource_group_name: str,
        name: str,
        environment_name: str,
        linked_backend_name: str,
        static_site_linked_backend_envelope: _models.StaticSiteLinkedBackendARMResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.StaticSiteLinkedBackendARMResource]:
        """Link backend to a static site build.

        Link backend to a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :param linked_backend_name: Name of the backend to link to the static site. Required.
        :type linked_backend_name: str
        :param static_site_linked_backend_envelope: A JSON representation of the linked backend request
         properties. Required.
        :type static_site_linked_backend_envelope:
         ~azure.mgmt.web.v2022_09_01.models.StaticSiteLinkedBackendARMResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either StaticSiteLinkedBackendARMResource
         or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2022_09_01.models.StaticSiteLinkedBackendARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_link_backend_to_build(
        self,
        resource_group_name: str,
        name: str,
        environment_name: str,
        linked_backend_name: str,
        static_site_linked_backend_envelope: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.StaticSiteLinkedBackendARMResource]:
        """Link backend to a static site build.

        Link backend to a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :param linked_backend_name: Name of the backend to link to the static site. Required.
        :type linked_backend_name: str
        :param static_site_linked_backend_envelope: A JSON representation of the linked backend request
         properties. Required.
        :type static_site_linked_backend_envelope: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either StaticSiteLinkedBackendARMResource
         or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2022_09_01.models.StaticSiteLinkedBackendARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_link_backend_to_build(
        self,
        resource_group_name: str,
        name: str,
        environment_name: str,
        linked_backend_name: str,
        static_site_linked_backend_envelope: Union[_models.StaticSiteLinkedBackendARMResource, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.StaticSiteLinkedBackendARMResource]:
        """Link backend to a static site build.

        Link backend to a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :param linked_backend_name: Name of the backend to link to the static site. Required.
        :type linked_backend_name: str
        :param static_site_linked_backend_envelope: A JSON representation of the linked backend request
         properties. Is either a StaticSiteLinkedBackendARMResource type or a IO[bytes] type. Required.
        :type static_site_linked_backend_envelope:
         ~azure.mgmt.web.v2022_09_01.models.StaticSiteLinkedBackendARMResource or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either StaticSiteLinkedBackendARMResource
         or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2022_09_01.models.StaticSiteLinkedBackendARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StaticSiteLinkedBackendARMResource] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._link_backend_to_build_initial(
                resource_group_name=resource_group_name,
                name=name,
                environment_name=environment_name,
                linked_backend_name=linked_backend_name,
                static_site_linked_backend_envelope=static_site_linked_backend_envelope,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("StaticSiteLinkedBackendARMResource", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.StaticSiteLinkedBackendARMResource].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.StaticSiteLinkedBackendARMResource](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace_async
    async def unlink_backend_from_build(
        self,
        resource_group_name: str,
        name: str,
        environment_name: str,
        linked_backend_name: str,
        is_cleaning_auth_config: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """Unlink a backend from a static site build.

        Unlink a backend from a static site build.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the static site. Required.
        :type name: str
        :param environment_name: The stage site identifier. Required.
        :type environment_name: str
        :param linked_backend_name: Name of the backend linked to the static site. Required.
        :type linked_backend_name: str
        :param is_cleaning_auth_config: Decides if auth will be removed from backend configuration.
         Default value is None.
        :type is_cleaning_auth_config: bool
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2022-09-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_unlink_backend_from_build_request(
            resource_group_name=resource_group_name,
            name=name,
            environment_name=environment_name,
            linked_backend_name=linked_backend_name,
            subscription_id=self._config.subscription_id,
            is_cleaning_auth_config=is_cleaning_auth_config,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore
