/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.dameng.model;

import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.dameng.model.DamengTable;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObjectStatisticsCollector;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class DamengSchema
extends GenericSchema
implements DBPQualifiedObject,
DBPObjectStatisticsCollector {
    @NotNull
    private String schemaName;
    private boolean persisted;
    private boolean hasStatistics;

    public DamengSchema(GenericDataSource dataSource, String schemaName, boolean persisted) {
        super(dataSource, null, schemaName);
        this.schemaName = schemaName;
        this.persisted = persisted;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.schemaName;
    }

    public void setName(@NotNull String schemaName) {
        this.schemaName = schemaName;
    }

    public boolean isStatisticsCollected() {
        return this.hasStatistics;
    }

    public void collectObjectStatistics(DBRProgressMonitor monitor, boolean totalSizeOnly, boolean forceRefresh) throws DBException {
        if (this.hasStatistics || forceRefresh) {
            return;
        }
        try {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table status");){
                    JDBCPreparedStatement dbStat = session.prepareStatement("SELECT TABLE_NAME,TABLE_USED_PAGES(OWNER,TABLE_NAME) * PAGE AS DISK_SIZE FROM ALL_TABLES WHERE owner = ?");
                    dbStat.setString(1, this.getName());
                    Throwable throwable2 = null;
                    Object var9_13 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            String tableName = dbResult.getString(1);
                            DamengTable table = (DamengTable)this.getTable(monitor, tableName);
                            if (table == null) continue;
                            table.fetchStatistics(dbResult);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBCException("Error reading schema relation statistics", (Throwable)e);
            }
        }
        finally {
            this.hasStatistics = true;
        }
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this});
    }

    public boolean isPersisted() {
        return this.persisted;
    }
}

