#pragma once

#include "esphome/core/component.h"
#include "esphome/components/sensor/sensor.h"
#include "esphome/components/binary_sensor/binary_sensor.h"
#include "esphome/components/esp32_ble_tracker/esp32_ble_tracker.h"
#include "esphome/components/xiaomi_ble/xiaomi_ble.h"

#ifdef USE_ESP32

namespace esphome {
namespace xiaomi_wx08zm {

class XiaomiWX08ZM : public Component,
                     public binary_sensor::BinarySensorInitiallyOff,
                     public esp32_ble_tracker::ESPBTDeviceListener {
 public:
  void set_address(uint64_t address) { address_ = address; }

  bool parse_device(const esp32_ble_tracker::ESPBTDevice &device) override;

  void dump_config() override;
  void set_tablet(sensor::Sensor *tablet) { tablet_ = tablet; }
  void set_battery_level(sensor::Sensor *battery_level) { battery_level_ = battery_level; }

 protected:
  uint64_t address_;
  sensor::Sensor *tablet_{nullptr};
  sensor::Sensor *battery_level_{nullptr};
};

}  // namespace xiaomi_wx08zm
}  // namespace esphome

#endif
