/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.bookmarks.mindmapmode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.bookmarks.mindmapmode.NodeBookmark;
import org.freeplane.features.bookmarks.mindmapmode.NodeBookmarkDescriptor;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

public class MapBookmarks
implements IExtension {
    private MapModel map;
    private List<String> nodeIDs;
    private Map<String, NodeBookmarkDescriptor> bookmarks;
    private Map<String, String> selectedNodesBySelectionRoot;

    public static MapBookmarks of(MapModel map) {
        MapBookmarks bookmarks = (MapBookmarks)map.getExtension(MapBookmarks.class);
        if (bookmarks == null) {
            bookmarks = new MapBookmarks(map);
            map.addExtension((IExtension)bookmarks);
        }
        return bookmarks;
    }

    MapBookmarks(MapModel map) {
        this.map = map;
        this.nodeIDs = new ArrayList<String>();
        this.bookmarks = new HashMap<String, NodeBookmarkDescriptor>();
        this.selectedNodesBySelectionRoot = new HashMap<String, String>();
    }

    void add(String id, NodeBookmarkDescriptor bookmark) {
        if (this.bookmarks.put(id, bookmark) == null) {
            this.nodeIDs.add(id);
        }
    }

    void addAtPosition(String id, NodeBookmarkDescriptor bookmark, int position) {
        if (this.bookmarks.put(id, bookmark) == null) {
            List<String> visibleBookmarkIds = this.getVisibleBookmarkIds();
            int insertPosition = Math.max(0, Math.min(position, visibleBookmarkIds.size()));
            if (insertPosition >= visibleBookmarkIds.size()) {
                this.nodeIDs.add(id);
            } else {
                String targetNodeId = visibleBookmarkIds.get(insertPosition);
                int targetIndex = this.nodeIDs.indexOf(targetNodeId);
                this.nodeIDs.add(targetIndex, id);
            }
        }
    }

    boolean remove(String id) {
        if (id == null) {
            return false;
        }
        if (this.bookmarks.remove(id) != null) {
            this.nodeIDs.remove(id);
            return true;
        }
        return false;
    }

    boolean move(String id, int indexInVisibleList) {
        if (!this.bookmarkExists(id)) {
            return false;
        }
        List<String> visibleBookmarks = this.getVisibleBookmarkIds();
        if (this.isIndexOutOfBounds(indexInVisibleList, visibleBookmarks) || !this.isBookmarkVisible(id, visibleBookmarks)) {
            return false;
        }
        if (this.isBookmarkAtTargetPosition(id, indexInVisibleList, visibleBookmarks)) {
            return true;
        }
        this.moveBookmarkInList(id, indexInVisibleList, visibleBookmarks);
        this.updateNodeIdList(visibleBookmarks);
        return true;
    }

    private boolean bookmarkExists(String id) {
        return id != null && this.bookmarks.containsKey(id) && this.map.getNodeForID(id) != null;
    }

    private boolean isBookmarkVisible(String id, List<String> visibleNodes) {
        return visibleNodes.contains(id);
    }

    private List<String> getVisibleBookmarkIds() {
        return this.nodeIDs.stream().filter(nodeId -> this.map.getNodeForID(nodeId) != null).collect(Collectors.toList());
    }

    private boolean isIndexOutOfBounds(int index, List<String> visibleNodes) {
        return index < 0 || index >= visibleNodes.size();
    }

    private boolean isBookmarkAtTargetPosition(String id, int targetIndex, List<String> visibleBookmarks) {
        return visibleBookmarks.indexOf(id) == targetIndex;
    }

    private void moveBookmarkInList(String id, int targetIndex, List<String> visibleBookmarks) {
        int currentIndex = visibleBookmarks.indexOf(id);
        visibleBookmarks.remove(currentIndex);
        visibleBookmarks.add(targetIndex, id);
    }

    private void updateNodeIdList(List<String> reorderedVisibleBookmarks) {
        ArrayList<String> newNodeIDs = new ArrayList<String>();
        int visibleIndex = 0;
        for (String nodeId : this.nodeIDs) {
            if (this.map.getNodeForID(nodeId) != null) {
                newNodeIDs.add(reorderedVisibleBookmarks.get(visibleIndex++));
                continue;
            }
            newNodeIDs.add(nodeId);
        }
        this.nodeIDs = newNodeIDs;
    }

    public NodeBookmark getBookmark(String id) {
        NodeBookmarkDescriptor descriptor = this.bookmarks.get(id);
        if (descriptor == null) {
            return null;
        }
        NodeModel node = this.map.getNodeForID(id);
        if (node == null) {
            return null;
        }
        return new NodeBookmark(node, descriptor);
    }

    public List<String> getNodeIDs() {
        return this.nodeIDs.stream().filter(id -> this.map.getNodeForID(id) != null).collect(Collectors.toList());
    }

    public List<NodeBookmark> getBookmarks() {
        return this.nodeIDs.stream().map(this::getBookmark).filter(x -> x != null).collect(Collectors.toList());
    }

    public MapModel getMap() {
        return this.map;
    }

    int size() {
        return this.bookmarks.size();
    }

    public boolean contains(String id) {
        return this.bookmarks.containsKey(id);
    }

    boolean clear() {
        if (this.bookmarks.isEmpty()) {
            return false;
        }
        this.bookmarks.clear();
        this.nodeIDs.clear();
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.bookmarks, this.map, this.nodeIDs);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapBookmarks other = (MapBookmarks)obj;
        return Objects.equals(this.bookmarks, other.bookmarks) && Objects.equals(this.map, other.map) && Objects.equals(this.nodeIDs, other.nodeIDs);
    }

    boolean opensAsRoot(NodeModel node) {
        NodeBookmarkDescriptor descriptor = this.bookmarks.get(node.getID());
        return descriptor != null && descriptor.opensAsRoot();
    }

    void onSelect(NodeModel node) {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        String rootId = selection.getSelectionRoot().getID();
        String nodeId = node.createID();
        this.selectedNodesBySelectionRoot.put(rootId, nodeId);
    }

    NodeModel getSelectedNodeForRoot(NodeModel node) {
        String rootId = node.getID();
        String selectedNodeId = this.selectedNodesBySelectionRoot.getOrDefault(rootId, rootId);
        if (selectedNodeId.equals(rootId)) {
            return node;
        }
        NodeModel selectedNode = this.map.getNodeForID(selectedNodeId);
        return selectedNode != null ? selectedNode : node;
    }
}

