/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon.mindmapmode;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.svgicons.FreeplaneIconFactory;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.Tag;
import org.freeplane.features.icon.TagCategories;
import org.freeplane.features.icon.factory.IconFactory;
import org.freeplane.features.icon.mindmapmode.JTagTree;
import org.freeplane.features.icon.mindmapmode.MIconController;
import org.freeplane.features.icon.mindmapmode.TagTreeViewerFactory;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

public class TagPanelManager {
    private final JPanel tagPanel;
    private JTagTree tagTree;
    private Font treeFont;
    private TagCategories treeCategories;
    private final MIconController iconController;
    private final JButton editCategoriesButton;
    private final JTextField filterField = new JTextField();
    private Timer filterTimer;
    private final WeakHashMap<MapModel, TreeCache> treeCache = new WeakHashMap();

    public TagPanelManager(ModeController modeController) {
        this.tagPanel = new JPanel(new GridBagLayout());
        this.tagPanel.setMinimumSize(new Dimension(0, 0));
        this.tagPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.editCategoriesButton = new JButton((Action)modeController.getAction("ManageTagCategoriesAction"));
        TableCreator tableCreator = new TableCreator();
        MapController mapController = modeController.getMapController();
        mapController.addNodeSelectionListener((INodeSelectionListener)tableCreator);
        mapController.addMapChangeListener((IMapChangeListener)tableCreator);
        this.tagPanel.addHierarchyListener(tableCreator);
        this.iconController = (MIconController)modeController.getExtension(IconController.class);
        this.updateTreeAndButton(null);
    }

    public JPanel getTagPanel() {
        return this.tagPanel;
    }

    private void updateTreeAndButton(JTree tree) {
        this.tagPanel.removeAll();
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.insets = new Insets(5, 5, 0, 5);
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.setOpaque(false);
        JLabel filterLabel = new JLabel();
        Icon filterIcon = ResourceController.getResourceController().getIcon("filterIcon");
        Icon scaledIcon = IconFactory.getInstance().getScaledIcon(filterIcon, (Component)filterLabel);
        filterLabel.setIcon(FreeplaneIconFactory.toImageIcon((Icon)scaledIcon));
        GridBagConstraints labelGbc = new GridBagConstraints();
        labelGbc.gridx = 0;
        labelGbc.gridy = 0;
        labelGbc.insets = new Insets(0, 0, 0, 5);
        filterPanel.add((Component)filterLabel, labelGbc);
        GridBagConstraints fieldGbc = new GridBagConstraints();
        fieldGbc.gridx = 1;
        fieldGbc.gridy = 0;
        fieldGbc.fill = 2;
        fieldGbc.weightx = 1.0;
        filterPanel.add((Component)this.filterField, fieldGbc);
        gbc.gridy = gridy++;
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.weightx = 1.0;
        this.tagPanel.add((Component)filterPanel, gbc);
        if (tree != null) {
            gbc.gridy = gridy++;
            gbc.anchor = 11;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(0, 5, 5, 5);
            this.tagPanel.add((Component)tree, gbc);
        }
        GridBagConstraints gbcButton = new GridBagConstraints();
        gbcButton.gridx = 0;
        gbcButton.gridy = gridy++;
        gbcButton.insets = new Insets(5, 5, 5, 5);
        gbcButton.anchor = 17;
        gbcButton.fill = 0;
        this.tagPanel.add((Component)this.editCategoriesButton, gbcButton);
        GridBagConstraints gbcFiller = new GridBagConstraints();
        gbcFiller.gridx = 0;
        gbcFiller.gridy = gridy;
        gbcFiller.weighty = 1.0;
        gbcFiller.fill = 3;
        JPanel filler = new JPanel();
        filler.setOpaque(false);
        this.tagPanel.add((Component)filler, gbcFiller);
        this.tagPanel.revalidate();
        this.tagPanel.repaint();
    }

    private void setupFilterField() {
        if (this.filterTimer != null) {
            this.filterTimer.stop();
        }
        this.filterField.getDocument().addDocumentListener(new DocumentListener(){

            private void restartTimer() {
                if (TagPanelManager.this.filterTimer != null) {
                    TagPanelManager.this.filterTimer.restart();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.restartTimer();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.restartTimer();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.restartTimer();
            }
        });
        this.filterTimer = new Timer(300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TagPanelManager.this.filterTimer.stop();
                if (TagPanelManager.this.tagTree != null) {
                    TagPanelManager.this.applyFilter();
                }
            }
        });
        this.filterTimer.setRepeats(false);
    }

    private void applyFilter() {
        String text = this.filterField.getText().trim();
        this.tagTree.setFilter(text.isEmpty() ? null : node -> node.toString().toLowerCase().contains(text.toLowerCase()));
    }

    private class TableCreator
    implements INodeSelectionListener,
    IMapChangeListener,
    HierarchyListener {
        private TableCreator() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if ((e.getChangeFlags() & 4L) != 0L && TagPanelManager.this.tagPanel.isShowing()) {
                this.onChange(Controller.getCurrentController().getMap());
            }
        }

        public void onDeselect(NodeModel node) {
            TagPanelManager.this.updateTreeAndButton(null);
        }

        public void onSelect(NodeModel node) {
            this.onChange(node.getMap());
        }

        private void onChange(MapModel map) {
            if (!TagPanelManager.this.tagPanel.isShowing()) {
                return;
            }
            if (map == null) {
                TagPanelManager.this.updateTreeAndButton(null);
                return;
            }
            TagCategories newCategories = map.getIconRegistry().getTagCategories();
            Font newFont = TagPanelManager.this.iconController.getTagFont(map.getRootNode());
            TreeCache cached = (TreeCache)TagPanelManager.this.treeCache.get(map);
            if (cached != null && cached.categories == newCategories && cached.font.equals(newFont)) {
                TagPanelManager.this.tagTree = cached.tree;
                TagPanelManager.this.treeCategories = cached.categories;
                TagPanelManager.this.treeFont = cached.font;
            } else {
                TagPanelManager.this.treeCategories = newCategories;
                TagPanelManager.this.treeFont = newFont;
                TagPanelManager.this.tagTree = new TagTreeViewerFactory(newCategories, newFont).getTree();
                TagPanelManager.this.tagTree.setFont(newFont);
                TagPanelManager.this.applyFilter();
                TagPanelManager.this.tagTree.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (e.getClickCount() != 2) {
                            return;
                        }
                        TableCreator.this.insertTagIntoSelectedNodes(e);
                    }
                });
                TagPanelManager.this.setupFilterField();
                TagPanelManager.this.treeCache.put(map, new TreeCache(TagPanelManager.this.tagTree, TagPanelManager.this.treeCategories, TagPanelManager.this.treeFont));
            }
            TagPanelManager.this.updateTreeAndButton(TagPanelManager.this.tagTree);
        }

        public void mapChanged(MapChangeEvent event) {
            this.onChange(event.getMap());
        }

        private void insertTagIntoSelectedNodes(MouseEvent e) {
            int y;
            int x;
            JTagTree tree = (JTagTree)e.getSource();
            TreePath path = tree.getPathForLocation(x = e.getX(), y = e.getY());
            if (path == null) {
                return;
            }
            Rectangle nodeBounds = tree.getUI().getPathBounds(tree, path);
            if (nodeBounds == null) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Tag tag = TagPanelManager.this.treeCategories.categorizedTag(node);
            TagPanelManager.this.iconController.insertTagsIntoSelectedNodes(Collections.singletonList(tag));
        }
    }

    private static class TreeCache {
        final JTagTree tree;
        final TagCategories categories;
        final Font font;

        TreeCache(JTagTree tree, TagCategories categories, Font font) {
            this.tree = tree;
            this.categories = categories;
            this.font = font;
        }
    }
}

