/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.mindmapmode;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.util.HashSet;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import org.apache.commons.lang.StringUtils;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.text.mindmapmode.EditNodeBase;
import org.freeplane.features.text.mindmapmode.EditNodeWYSIWYG;
import org.freeplane.features.text.mindmapmode.IEditBaseCreator;
import org.freeplane.features.url.UrlManager;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.MapViewController;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.ZoomableLabel;
import org.freeplane.view.swing.map.mindmapmode.EditNodeExternalApplication;
import org.freeplane.view.swing.map.mindmapmode.EditNodeTextField;

public class MMapViewController
extends MapViewController
implements IEditBaseCreator {
    @Override
    public EditNodeBase createEditor(NodeModel node, Object nodeProperty, Object content, EditNodeBase.IEditControl editControl, boolean editLong) {
        boolean editExternal;
        if (!(content instanceof String)) {
            throw new IllegalArgumentException("Unknown content type " + content);
        }
        String text = (String)content;
        String htmlEditingOption = ResourceController.getResourceController().getProperty("html_editing_option");
        boolean editInternalWysiwyg = editLong && StringUtils.equals((String)htmlEditingOption, (String)"internal-wysiwyg");
        boolean bl = editExternal = editLong && StringUtils.equals((String)htmlEditingOption, (String)"external");
        if (!HtmlUtils.isHtml((String)text)) {
            text = HtmlUtils.plainToHTML((String)text);
        }
        if (editInternalWysiwyg) {
            EditNodeWYSIWYG editNodeWYSIWYG = new EditNodeWYSIWYG(node, text, editControl, true);
            int preferredHeight = (int)((double)this.getComponent(node).getHeight() * 1.2);
            preferredHeight = Math.max(preferredHeight, Integer.parseInt(ResourceController.getResourceController().getProperty("el__min_default_window_height")));
            preferredHeight = Math.min(preferredHeight, Integer.parseInt(ResourceController.getResourceController().getProperty("el__max_default_window_height")));
            int preferredWidth = (int)((double)this.getComponent(node).getWidth() * 1.2);
            preferredWidth = Math.max(preferredWidth, Integer.parseInt(ResourceController.getResourceController().getProperty("el__min_default_window_width")));
            preferredWidth = Math.min(preferredWidth, Integer.parseInt(ResourceController.getResourceController().getProperty("el__max_default_window_width")));
            Dimension preferredSize = new Dimension(preferredWidth, preferredHeight);
            editNodeWYSIWYG.setPreferredContentSize(preferredSize);
            MainView mainView = (MainView)this.getComponent(node);
            NodeView nodeView = mainView.getNodeView();
            ComponentOrientation componentOrientation = mainView.getComponentOrientation();
            if (EditNodeBase.EditedComponent.TEXT.equals((Object)editControl.getEditType())) {
                Font font = this.getFont(node);
                editNodeWYSIWYG.setTitle("edit_long_node");
                editNodeWYSIWYG.setFont(font);
                Color nodeTextColor = nodeView.getTextColor(LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
                editNodeWYSIWYG.setTextColor(nodeTextColor);
                editNodeWYSIWYG.setBackground(nodeView.getTextBackground(LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE));
                editNodeWYSIWYG.setTextAlignment(mainView.getHorizontalAlignment());
                editNodeWYSIWYG.setComponentOrientation(componentOrientation);
                editNodeWYSIWYG.setCustomStyleSheet(mainView.getStyleSheet());
            } else if (EditNodeBase.EditedComponent.DETAIL.equals((Object)editControl.getEditType())) {
                MapView map = nodeView.getMap();
                editNodeWYSIWYG.setTitle("edit_details");
                editNodeWYSIWYG.setFont(map.getDetailFont());
                editNodeWYSIWYG.setTextColor(map.getDetailForeground());
                Color detailBackground = map.getDetailBackground();
                editNodeWYSIWYG.setBackground(detailBackground != null ? detailBackground : nodeView.getBlendedBackgroundColor());
                editNodeWYSIWYG.setTextAlignment(map.getDetailHorizontalAlignment());
                editNodeWYSIWYG.setComponentOrientation(componentOrientation);
                editNodeWYSIWYG.setCustomStyleSheet(map.getDetailCss().getStyleSheet());
            } else if (EditNodeBase.EditedComponent.NOTE.equals((Object)editControl.getEditType())) {
                MapView map = nodeView.getMap();
                editNodeWYSIWYG.setTitle("edit_note");
                editNodeWYSIWYG.setFont(map.getNoteFont());
                editNodeWYSIWYG.setTextColor(map.getNoteForeground());
                Color noteBackground = map.getNoteBackground();
                editNodeWYSIWYG.setBackground(noteBackground != null ? noteBackground : map.getBackground());
                editNodeWYSIWYG.setTextAlignment(map.getNoteHorizontalAlignment());
                editNodeWYSIWYG.setComponentOrientation(componentOrientation);
                editNodeWYSIWYG.setCustomStyleSheet(map.getNoteCss().getStyleSheet());
            }
            return editNodeWYSIWYG;
        }
        if (editExternal) {
            return new EditNodeExternalApplication(node, text, editControl);
        }
        EditNodeBase textfield = this.createEditor(node, editControl.getEditType(), text, editControl);
        if (textfield != null) {
            return textfield;
        }
        return this.createEditor(node, nodeProperty, text, editControl, true);
    }

    private EditNodeBase createEditor(NodeModel node, EditNodeBase.EditedComponent parent, String text, EditNodeBase.IEditControl editControl) {
        JComponent component;
        MainView mainView = (MainView)this.getComponent(node);
        NodeView nodeView = mainView.getNodeView();
        Object parentComponent = EditNodeBase.EditedComponent.TEXT.equals((Object)parent) ? mainView : (EditNodeBase.EditedComponent.DETAIL.equals((Object)parent) ? ((component = nodeView.getContent(4)) instanceof ZoomableLabel ? (ZoomableLabel)component : null) : null);
        if (parentComponent == null || !parentComponent.isVisible()) {
            return null;
        }
        EditNodeTextField textField = new EditNodeTextField(node, (ZoomableLabel)parentComponent, text, editControl);
        if (EditNodeBase.EditedComponent.TEXT.equals((Object)parent)) {
            textField.setBackground(nodeView.getTextBackground(LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE));
        } else if (EditNodeBase.EditedComponent.DETAIL.equals((Object)parent)) {
            Color detailBackground = nodeView.getMap().getDetailBackground();
            textField.setBackground(detailBackground != null ? detailBackground : nodeView.getBlendedBackgroundColor());
        }
        return textField;
    }

    public MMapViewController(Controller controller) {
        super(controller);
        new EditNodeTextField(null, null, null, null);
    }

    @Override
    public JEditorPane createTextEditorPane(Supplier<JScrollPane> scrollPaneSupplier, NodeModel node, Object nodeProperty, Object content, boolean editInline) {
        return null;
    }

    public boolean saveAllModifiedMaps() {
        return this.saveAllModifiedMapsExcept(null);
    }

    public boolean saveAllModifiedMapsExcept(MapModel mapToKeepOpen) {
        MapModel currentMap = this.getMap();
        if (currentMap != null && currentMap != mapToKeepOpen && !this.saveModifiedIfNotCancelled(currentMap)) {
            return false;
        }
        HashSet otherMaps = new HashSet(this.getMaps().values());
        otherMaps.remove(mapToKeepOpen);
        otherMaps.remove(this.getMap());
        for (MapModel map : otherMaps) {
            if (this.saveModifiedIfNotCancelled(map)) continue;
            return false;
        }
        return true;
    }

    public boolean saveModifiedIfNotCancelled(MapModel map) {
        if (!map.isSaved() && !map.isReadOnly()) {
            UrlManager fileManager;
            boolean savingNotCancelled;
            this.changeToMap(map);
            MapView mapView = this.getMapView();
            if (mapView.getMap() != map) {
                return true;
            }
            String text = TextUtils.getText((String)"save_unsaved") + "\n" + map.getTitle();
            String title = TextUtils.getText((String)"SaveAction.text");
            Frame viewFrame = UITools.getCurrentFrame();
            Component dialogParent = viewFrame != null && viewFrame.isShowing() && viewFrame.getExtendedState() != 1 ? viewFrame : UITools.getCurrentRootComponent();
            int returnVal = JOptionPane.showOptionDialog(dialogParent, text, title, 1, 3, null, null, null);
            if (returnVal == 0 ? !(savingNotCancelled = (fileManager = (UrlManager)mapView.getModeController().getExtension(UrlManager.class)).save(map)) : returnVal == 2 || returnVal == -1) {
                return false;
            }
        }
        return true;
    }
}

