/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.jdk18;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.InterfaceAdapter;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.VMBridge;

public class VMBridge_jdk18
extends VMBridge {
    private static final ThreadLocal<Object[]> contextLocal = new ThreadLocal();

    @Override
    protected Object getThreadContextHelper() {
        Object[] objectArray = contextLocal.get();
        if (objectArray == null) {
            objectArray = new Object[1];
            contextLocal.set(objectArray);
        }
        return objectArray;
    }

    @Override
    protected Context getContext(Object object) {
        Object[] objectArray = (Object[])object;
        return (Context)objectArray[0];
    }

    @Override
    protected void setContext(Object object, Context context) {
        Object[] objectArray = (Object[])object;
        objectArray[0] = context;
    }

    @Override
    protected boolean tryToMakeAccessible(AccessibleObject accessibleObject) {
        if (accessibleObject.isAccessible()) {
            return true;
        }
        try {
            accessibleObject.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return accessibleObject.isAccessible();
    }

    @Override
    protected Object getInterfaceProxyHelper(ContextFactory contextFactory, Class<?>[] classArray) {
        Constructor<?> constructor;
        ClassLoader classLoader = classArray[0].getClassLoader();
        Class<?> clazz = Proxy.getProxyClass(classLoader, classArray);
        try {
            constructor = clazz.getConstructor(InvocationHandler.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(noSuchMethodException);
        }
        return constructor;
    }

    @Override
    protected Object newInterfaceProxy(Object object, final ContextFactory contextFactory, final InterfaceAdapter interfaceAdapter, final Object object2, final Scriptable scriptable) {
        Object t;
        Constructor constructor = (Constructor)object;
        InvocationHandler invocationHandler = new InvocationHandler(){

            @Override
            public Object invoke(Object object, Method method, Object[] objectArray) {
                if (method.getDeclaringClass() == Object.class) {
                    String string = method.getName();
                    if (string.equals("equals")) {
                        Object object22 = objectArray[0];
                        return object == object22;
                    }
                    if (string.equals("hashCode")) {
                        return object2.hashCode();
                    }
                    if (string.equals("toString")) {
                        return "Proxy[" + object2.toString() + "]";
                    }
                }
                return interfaceAdapter.invoke(contextFactory, object2, scriptable, object, method, objectArray);
            }
        };
        try {
            t = constructor.newInstance(invocationHandler);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw Context.throwAsScriptRuntimeEx(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalStateException(instantiationException);
        }
        return t;
    }
}

