/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.table.AbstractGTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableFilterPanel;
import docking.widgets.table.RowObjectTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;

public class ListSelectionTableDialog<T>
extends DialogComponentProvider {
    private GTable gTable;
    private T selectedValue;
    private List<T> selectedValues = new ArrayList<T>();
    private GTableFilterPanel<T> filterPanel;
    private RowObjectTableModel<T> model;

    public ListSelectionTableDialog(String title, List<T> list) {
        super(title, true, false, true, false);
        this.model = new ListTableModel(list);
        this.addWorkPanel(this.build());
        this.addOKButton();
        this.addCancelButton();
        this.updateOkButtonEnablement();
        this.setFocusComponent(this.filterPanel);
    }

    public ListSelectionTableDialog(String title, RowObjectTableModel<T> model) {
        super(title, true, false, true, false);
        this.model = model;
        this.addWorkPanel(this.build());
        this.addOKButton();
        this.addCancelButton();
        this.updateOkButtonEnablement();
        this.setFocusComponent(this.filterPanel);
    }

    @Override
    protected void okCallback() {
        int[] selectedRows = this.gTable.getSelectedRows();
        if (selectedRows.length > 0) {
            this.selectedValues.clear();
            for (int selectedRow : selectedRows) {
                int modelRow = this.filterPanel.getModelRow(selectedRow);
                T rowObject = this.model.getRowObject(modelRow);
                this.selectedValues.add(rowObject);
            }
            this.selectedValue = this.selectedValues.isEmpty() ? null : this.selectedValues.get(0);
            this.close();
        }
    }

    @Override
    public void close() {
        super.close();
        this.filterPanel.dispose();
    }

    private JComponent build() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.gTable = new GTable();
        this.gTable.getAccessibleContext().setAccessibleName("List Selection");
        this.gTable.getSelectionModel().setSelectionMode(0);
        JScrollPane scroll = new JScrollPane(this.gTable);
        scroll.getAccessibleContext().setAccessibleName("List Selection");
        this.filterPanel = new GTableFilterPanel<T>(this.gTable, this.model);
        this.filterPanel.getAccessibleContext().setAccessibleName("Filter");
        panel.add((Component)scroll, "Center");
        panel.add(this.filterPanel, "South");
        this.gTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    ListSelectionTableDialog.this.okCallback();
                    e.consume();
                }
            }
        });
        this.gTable.getSelectionModel().addListSelectionListener(e -> this.updateOkButtonEnablement());
        this.gTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    ListSelectionTableDialog.this.okCallback();
                }
            }
        });
        panel.getAccessibleContext().setAccessibleName("List Selection Table");
        return panel;
    }

    private void updateOkButtonEnablement() {
        this.setOkEnabled(!this.gTable.getSelectionModel().isSelectionEmpty());
    }

    public T getSelectedItem() {
        return this.selectedValue;
    }

    public List<T> getSelectedItems() {
        return this.selectedValues;
    }

    public T show(Component parent) {
        this.setSelectionMode(false);
        DockingWindowManager.showDialog(parent, this);
        return this.getSelectedItem();
    }

    public List<T> showSelectMultiple(Component parent) {
        this.setSelectionMode(true);
        DockingWindowManager.showDialog(parent, this);
        return this.getSelectedItems();
    }

    @Deprecated
    public void setMultiSelectionMode(boolean enable) {
        this.setSelectionMode(enable);
    }

    private void setSelectionMode(boolean allowMultipleSelections) {
        ListSelectionModel selectionModel = this.gTable.getSelectionModel();
        if (allowMultipleSelections) {
            selectionModel.setSelectionMode(2);
        } else {
            selectionModel.setSelectionMode(0);
        }
    }

    public void hideOkButton() {
        this.removeButton(this.okButton);
    }

    private class ListTableModel
    extends AbstractGTableModel<T> {
        private List<T> data;

        ListTableModel(List<T> list) {
            this.data = list;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return "Name";
        }

        @Override
        public String getName() {
            return ListSelectionTableDialog.this.getTitle();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public List<T> getModelData() {
            return this.data;
        }

        @Override
        public Object getColumnValueForRow(T t, int columnIndex) {
            return t;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }
    }
}

